/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.component.dataexporter.CSVOutputHandler;
import com.icesoft.faces.component.dataexporter.DataExporter;
import com.icesoft.faces.component.dataexporter.ExcelOutputHandler;
import com.icesoft.faces.component.dataexporter.OutputTypeHandler;
import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.ext.UIColumn;
import com.icesoft.faces.component.outputresource.OutputResourceRenderer;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.FileResource;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.renderkit.dom_html_basic.FormRenderer;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataExporterRenderer
extends OutputResourceRenderer {
    private static final String PREPARE_FILE_HIDDEN_SUFFIX = "_pfl";

    public void encodeBegin(FacesContext fc, UIComponent uiC) throws IOException {
        DataExporter oe = (DataExporter)uiC;
        if (oe.getUIData() != null && oe.getType() != null && oe.getType().length() > 0) {
            if (oe.isReadyToExport()) {
                File file;
                if (oe.getResource() == null && (file = this.createFile(fc, oe.getUIData(), (DataExporter)uiC)) != null) {
                    oe.setResource((Resource)new FileResource(file));
                }
                super.encodeBegin(fc, (UIComponent)oe);
                FormRenderer.addHiddenField((FacesContext)fc, (String)DataExporterRenderer.deriveCommonHiddenFieldName(fc, (UIComponent)oe));
            } else {
                this.renderPrepareFileLink(fc, oe);
            }
        } else {
            DOMContext domContext = DOMContext.attachDOMContext((FacesContext)fc, (UIComponent)oe);
            if (!domContext.isInitialized()) {
                domContext.createRootElement("div");
            }
            Element root = (Element)domContext.getRootNode();
            root.setAttribute("id", oe.getClientId(fc) + "_cont");
            domContext.setCursorParent((Node)root);
        }
    }

    private void renderPrepareFileLink(FacesContext fc, DataExporter oe) throws IOException {
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)fc, (UIComponent)oe);
        if (!domContext.isInitialized()) {
            domContext.createRootElement("div");
        }
        Element root = (Element)domContext.getRootNode();
        root.setAttribute("id", oe.getClientId(fc) + "_cont");
        domContext.setCursorParent((Node)root);
        HtmlCommandLink link = (HtmlCommandLink)fc.getApplication().createComponent("com.icesoft.faces.HtmlCommandLink");
        FormRenderer.addHiddenField((FacesContext)fc, (String)DataExporterRenderer.deriveCommonHiddenFieldName(fc, (UIComponent)oe));
        link.setId(oe.getId() + PREPARE_FILE_HIDDEN_SUFFIX);
        String clickToCreateFileText = oe.getClickToCreateFileText();
        if (clickToCreateFileText == null) {
            clickToCreateFileText = "Click to create export file";
        }
        link.setValue(clickToCreateFileText);
        link.setTransient(true);
        oe.getChildren().add(link);
        link.encodeBegin(fc);
        link.encodeEnd(fc);
        oe.getChildren().clear();
    }

    protected static String deriveCommonHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        if (Beans.isDesignTime()) {
            return "";
        }
        UIComponent parentNamingContainer = DataExporterRenderer.findForm((UIComponent)uiComponent);
        String parentClientId = parentNamingContainer.getClientId(facesContext);
        String hiddenFieldName = parentClientId + ':' + "_id" + "cl";
        return hiddenFieldName;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.validateParameters(context, component, DataExporter.class);
        String hiddenFieldKey = DataExporterRenderer.deriveCommonHiddenFieldName(context, component);
        String param = (String)context.getExternalContext().getRequestParameterMap().get(hiddenFieldKey);
        if (param != null && (component.getClientId(context) + PREPARE_FILE_HIDDEN_SUFFIX).equals(param)) {
            ((DataExporter)component).setReadyToExport(true);
        }
    }

    private File createFile(FacesContext fc, UIData uiData, DataExporter oe) {
        OutputTypeHandler outputHandler = null;
        ServletContext context = ((HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(false)).getServletContext();
        try {
            File exportDir = new File(context.getRealPath("/export"));
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            String pathWithoutExt = context.getRealPath("/export") + "/export_" + new Date().getTime();
            if (oe.getOutputTypeHandler() != null) {
                outputHandler = oe.getOutputTypeHandler();
            } else if ("excel".equals(oe.getType())) {
                outputHandler = new ExcelOutputHandler(pathWithoutExt + ".xls", fc, uiData.getId());
            } else if ("csv".equals(oe.getType())) {
                outputHandler = new CSVOutputHandler(pathWithoutExt + ".csv");
            }
            this.renderToHandler(outputHandler, uiData, fc, oe);
            oe.setMimeType(outputHandler.getMimeType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputHandler != null ? outputHandler.getFile() : null;
    }

    private String encodeParentAndChildrenAsString(FacesContext fc, UIComponent uic, String str) {
        Object value = uic.getAttributes().get("value");
        if (value != null) {
            str = str + "" + value;
        } else {
            ValueBinding vb = uic.getValueBinding("value");
            if (vb != null) {
                str = str + vb.getValue(fc).toString();
            }
        }
        if (uic.getChildCount() > 0) {
            Iterator iter = uic.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = (UIComponent)iter.next();
                str = str + this.encodeParentAndChildrenAsString(fc, child, str);
            }
        }
        return str;
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            results.add(kid);
        }
        return results;
    }

    private void renderToHandler(OutputTypeHandler outputHandler, UIData uiData, FacesContext fc, DataExporter oe) {
        try {
            UIColumn nextColumn;
            int rowIndex = uiData.getFirst();
            int colIndex = 0;
            int numberOfRowsToDisplay = uiData.getRows();
            int countOfRowsDisplayed = 0;
            uiData.setRowIndex(rowIndex);
            Iterator childColumns = this.getRenderedChildColumnsList((UIComponent)uiData).iterator();
            while (childColumns.hasNext()) {
                nextColumn = (UIColumn)((Object)childColumns.next());
                UIComponent headerComp = nextColumn.getFacet("header");
                if (headerComp != null) {
                    String headerText = "";
                    if ((headerText = this.encodeParentAndChildrenAsString(fc, headerComp, headerText)) != null) {
                        outputHandler.writeHeaderCell(headerText, colIndex);
                    }
                }
                ++colIndex;
            }
            while (uiData.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay)) {
                childColumns = this.getRenderedChildColumnsList((UIComponent)uiData).iterator();
                colIndex = 0;
                while (childColumns.hasNext()) {
                    nextColumn = (UIColumn)((Object)childColumns.next());
                    String output = null;
                    String stringOutput = "";
                    Iterator childrenOfThisColumn = nextColumn.getChildren().iterator();
                    while (childrenOfThisColumn.hasNext()) {
                        UIComponent nextChild = (UIComponent)childrenOfThisColumn.next();
                        if (!nextChild.isRendered()) continue;
                        stringOutput = stringOutput + this.encodeParentAndChildrenAsString(fc, nextChild, stringOutput);
                    }
                    output = stringOutput;
                    outputHandler.writeCell(output, colIndex, rowIndex);
                    ++colIndex;
                }
                ++countOfRowsDisplayed;
                uiData.setRowIndex(++rowIndex);
            }
            uiData.setRowIndex(-1);
            outputHandler.flushFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

