/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.element;

import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jxmpp.jid.Jid;

public class MamElements {
    public static final String NAMESPACE = "urn:xmpp:mam:2";

    public static class NeverJidListElement
    implements Element {
        private List<Jid> neverJids;

        public NeverJidListElement(List<Jid> neverJids) {
            this.neverJids = neverJids;
        }

        public CharSequence toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("never");
            for (Jid jid : this.neverJids) {
                xml.element("jid", (CharSequence)jid);
            }
            xml.closeElement("never");
            return xml;
        }
    }

    public static class AlwaysJidListElement
    implements Element {
        private final List<Jid> alwaysJids;

        AlwaysJidListElement(List<Jid> alwaysJids) {
            this.alwaysJids = alwaysJids;
        }

        public CharSequence toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("always");
            for (Jid jid : this.alwaysJids) {
                xml.element("jid", (CharSequence)jid);
            }
            xml.closeElement("always");
            return xml;
        }
    }

    public static class MamResultExtension
    implements ExtensionElement {
        public static final String ELEMENT = "result";
        public static final QName QNAME = new QName("urn:xmpp:mam:2", "result");
        private final String id;
        private final Forwarded<Message> forwarded;
        private String queryId;

        public MamResultExtension(String queryId, String id, Forwarded<Message> forwarded) {
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new IllegalArgumentException("id must not be null or empty");
            }
            if (forwarded == null) {
                throw new IllegalArgumentException("forwarded must no be null");
            }
            this.id = id;
            this.forwarded = forwarded;
            this.queryId = queryId;
        }

        public String getId() {
            return this.id;
        }

        public Forwarded<Message> getForwarded() {
            return this.forwarded;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public final String getNamespace() {
            return MamElements.NAMESPACE;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            xml.optAttribute("queryid", this.getQueryId());
            xml.optAttribute("id", this.getId());
            xml.rightAngleBracket();
            xml.append(this.getForwarded());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public static MamResultExtension from(MessageView message) {
            return (MamResultExtension)message.getExtension(MamResultExtension.class);
        }
    }
}

