/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.element;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_markup.element.MarkupElement;

public class ListElement
extends MarkupElement.NonEmptyChildElement {
    public static final String ELEMENT = "list";
    public static final String ELEM_LI = "li";
    private final List<ListEntryElement> entries;

    public ListElement(int start, int end, List<ListEntryElement> entries) {
        super(start, end);
        this.entries = Collections.unmodifiableList(entries);
    }

    public List<ListEntryElement> getEntries() {
        return this.entries;
    }

    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public void appendInnerXml(XmlStringBuilder xml) {
        xml.append(this.getEntries());
    }

    public static class ListEntryElement
    implements ExtensionElement {
        private final int start;

        public ListEntryElement(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public String getElementName() {
            return ListElement.ELEM_LI;
        }

        public String getNamespace() {
            return "urn:xmpp:markup:0";
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            xml.attribute("start", this.getStart());
            xml.closeEmptyElement();
            return xml;
        }
    }
}

