/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_markup.element.BlockQuoteElement;
import org.jivesoftware.smackx.message_markup.element.CodeBlockElement;
import org.jivesoftware.smackx.message_markup.element.ListElement;
import org.jivesoftware.smackx.message_markup.element.SpanElement;

public class MarkupElement
implements ExtensionElement {
    public static final String NAMESPACE = "urn:xmpp:markup:0";
    public static final String ELEMENT = "markup";
    private final List<MarkupChildElement> childElements;

    public MarkupElement(List<MarkupChildElement> childElements) {
        this.childElements = Collections.unmodifiableList(childElements);
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public List<MarkupChildElement> getChildElements() {
        return this.childElements;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).rightAngleBracket();
        for (MarkupChildElement child : this.getChildElements()) {
            xml.append(child.toXML());
        }
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static abstract class BlockLevelMarkupElement
    extends MarkupChildElement {
        protected BlockLevelMarkupElement(int start, int end) {
            super(start, end);
        }

        @Override
        protected final void afterXmlPrelude(XmlStringBuilder xml) {
            xml.closeEmptyElement();
        }
    }

    public static abstract class NonEmptyChildElement
    extends MarkupChildElement {
        protected NonEmptyChildElement(int start, int end) {
            super(start, end);
        }

        @Override
        protected final void afterXmlPrelude(XmlStringBuilder xml) {
            xml.rightAngleBracket();
            this.appendInnerXml(xml);
            xml.closeElement((NamedElement)this);
        }

        protected abstract void appendInnerXml(XmlStringBuilder var1);
    }

    public static abstract class MarkupChildElement
    implements ExtensionElement {
        public static final String ATTR_START = "start";
        public static final String ATTR_END = "end";
        private final int start;
        private final int end;

        protected MarkupChildElement(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final String getNamespace() {
            return MarkupElement.NAMESPACE;
        }

        public final XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            xml.attribute(ATTR_START, this.getStart());
            xml.attribute(ATTR_END, this.getEnd());
            this.afterXmlPrelude(xml);
            return xml;
        }

        protected abstract void afterXmlPrelude(XmlStringBuilder var1);
    }

    public static final class Builder {
        private final List<SpanElement> spans = new ArrayList<SpanElement>();
        private final List<BlockQuoteElement> quotes = new ArrayList<BlockQuoteElement>();
        private final List<CodeBlockElement> codes = new ArrayList<CodeBlockElement>();
        private final List<ListElement> lists = new ArrayList<ListElement>();

        private Builder() {
        }

        public Builder setDeleted(int start, int end) {
            return this.addSpan(start, end, Collections.singleton(SpanElement.SpanStyle.deleted));
        }

        public Builder setEmphasis(int start, int end) {
            return this.addSpan(start, end, Collections.singleton(SpanElement.SpanStyle.emphasis));
        }

        public Builder setCode(int start, int end) {
            return this.addSpan(start, end, Collections.singleton(SpanElement.SpanStyle.code));
        }

        public Builder addSpan(int start, int end, Set<SpanElement.SpanStyle> styles) {
            Builder.verifyStartEnd(start, end);
            for (SpanElement other : this.spans) {
                if ((start < other.getStart() || start > other.getEnd()) && (end < other.getStart() || end > other.getEnd())) continue;
                throw new IllegalArgumentException("Spans MUST NOT overlap each other.");
            }
            this.spans.add(new SpanElement(start, end, styles));
            return this;
        }

        public Builder setBlockQuote(int start, int end) {
            Builder.verifyStartEnd(start, end);
            for (BlockQuoteElement other : this.quotes) {
                int endPos;
                Integer s = start;
                Integer e = end;
                int startPos = s.compareTo(other.getStart()) * s.compareTo(other.getEnd());
                int allowed = startPos * (endPos = e.compareTo(other.getStart()) * e.compareTo(other.getEnd()));
                if (allowed >= 1) continue;
                throw new IllegalArgumentException("BlockQuotes MUST NOT overlap each others boundaries");
            }
            this.quotes.add(new BlockQuoteElement(start, end));
            return this;
        }

        public Builder setCodeBlock(int start, int end) {
            Builder.verifyStartEnd(start, end);
            this.codes.add(new CodeBlockElement(start, end));
            return this;
        }

        public ListBuilder beginList() {
            return new ListBuilder(this);
        }

        public MarkupElement build() {
            ArrayList<MarkupChildElement> children = new ArrayList<MarkupChildElement>();
            children.addAll(this.spans);
            children.addAll(this.quotes);
            children.addAll(this.codes);
            children.addAll(this.lists);
            return new MarkupElement(children);
        }

        private static void verifyStartEnd(int start, int end) {
            if (start >= end || start < 0) {
                throw new IllegalArgumentException("Start value (" + start + ") MUST be greater equal than 0 and MUST be smaller than end value (" + end + ").");
            }
        }

        public static final class ListBuilder {
            private final Builder markup;
            private final ArrayList<ListElement.ListEntryElement> entries = new ArrayList();
            private int end = -1;

            private ListBuilder(Builder markup) {
                this.markup = markup;
            }

            public ListBuilder addEntry(int start, int end) {
                ListElement.ListEntryElement last;
                Builder.verifyStartEnd(start, end);
                ListElement.ListEntryElement listEntryElement = last = this.entries.size() == 0 ? null : this.entries.get(this.entries.size() - 1);
                if (last != null && start != this.end) {
                    throw new IllegalArgumentException("Next entries start must be equal to last entries end (" + this.end + ").");
                }
                this.entries.add(new ListElement.ListEntryElement(start));
                this.end = end;
                return this;
            }

            public Builder endList() {
                if (this.entries.size() > 0) {
                    ListElement.ListEntryElement first = this.entries.get(0);
                    ListElement list = new ListElement(first.getStart(), this.end, this.entries);
                    this.markup.lists.add(list);
                }
                return this.markup;
            }
        }
    }
}

