/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muclight.MUCLightAffiliation;
import org.jivesoftware.smackx.muclight.MUCLightRoomConfiguration;
import org.jivesoftware.smackx.muclight.MUCLightRoomInfo;
import org.jivesoftware.smackx.muclight.element.MUCLightAffiliationsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightChangeAffiliationsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightConfigurationIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightCreateIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightDestroyIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightGetAffiliationsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightGetConfigsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightGetInfoIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightInfoIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightSetConfigsIQ;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public class MultiUserChatLight {
    public static final String NAMESPACE = "urn:xmpp:muclight:0";
    public static final String AFFILIATIONS = "#affiliations";
    public static final String INFO = "#info";
    public static final String CONFIGURATION = "#configuration";
    public static final String CREATE = "#create";
    public static final String DESTROY = "#destroy";
    public static final String BLOCKING = "#blocking";
    private final XMPPConnection connection;
    private final EntityJid room;
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final StanzaFilter fromRoomFilter;
    private final StanzaFilter fromRoomGroupChatFilter;
    private final StanzaListener messageListener;
    private StanzaCollector messageCollector;

    MultiUserChatLight(XMPPConnection connection, EntityJid room) {
        this.connection = connection;
        this.room = room;
        this.fromRoomFilter = FromMatchesFilter.create((Jid)room);
        this.fromRoomGroupChatFilter = new AndFilter(new StanzaFilter[]{this.fromRoomFilter, MessageTypeFilter.GROUPCHAT});
        this.messageListener = new StanzaListener(){

            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                Message message = (Message)packet;
                for (MessageListener listener : MultiUserChatLight.this.messageListeners) {
                    listener.processMessage(message);
                }
            }
        };
        connection.addSyncStanzaListener(this.messageListener, this.fromRoomGroupChatFilter);
    }

    public EntityJid getRoom() {
        return this.room;
    }

    public void sendMessage(String text) throws SmackException.NotConnectedException, InterruptedException {
        MessageBuilder message = this.buildMessage();
        message.setBody(text);
        this.connection.sendStanza((Stanza)message.build());
    }

    @Deprecated
    public Chat createPrivateChat(EntityJid occupant, ChatMessageListener listener) {
        return ChatManager.getInstanceFor((XMPPConnection)this.connection).createChat(occupant, listener);
    }

    @Deprecated
    public Message createMessage() {
        return ((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to((Jid)this.room)).build();
    }

    public MessageBuilder buildMessage() {
        return (MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to((Jid)this.room);
    }

    @Deprecated
    public void sendMessage(Message message) throws SmackException.NotConnectedException, InterruptedException {
        this.sendMessage(message.asBuilder());
    }

    public void sendMessage(MessageBuilder messageBuilder) throws SmackException.NotConnectedException, InterruptedException {
        Message message = ((MessageBuilder)messageBuilder.to((Jid)this.room)).ofType(Message.Type.groupchat).build();
        this.connection.sendStanza((Stanza)message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() throws InterruptedException {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) throws InterruptedException {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public boolean addMessageListener(MessageListener listener) {
        return this.messageListeners.add(listener);
    }

    public boolean removeMessageListener(MessageListener listener) {
        return this.messageListeners.remove(listener);
    }

    private void removeConnectionCallbacks() {
        this.connection.removeSyncStanzaListener(this.messageListener);
        if (this.messageCollector != null) {
            this.messageCollector.cancel();
            this.messageCollector = null;
        }
    }

    public String toString() {
        return "MUC Light: " + this.room + "(" + this.connection.getUser() + ")";
    }

    public void create(String roomName, String subject, HashMap<String, String> customConfigs, List<Jid> occupants) throws Exception {
        MUCLightCreateIQ createMUCLightIQ = new MUCLightCreateIQ(this.room, roomName, occupants);
        this.messageCollector = this.connection.createStanzaCollector(this.fromRoomGroupChatFilter);
        try {
            this.connection.createStanzaCollectorAndSend((IQ)createMUCLightIQ).nextResultOrThrow();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            this.removeConnectionCallbacks();
            throw e;
        }
    }

    public void create(String roomName, List<Jid> occupants) throws Exception {
        this.create(roomName, null, null, occupants);
    }

    public void leave() throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        HashMap<Jid, MUCLightAffiliation> affiliations = new HashMap<Jid, MUCLightAffiliation>();
        affiliations.put((Jid)this.connection.getUser(), MUCLightAffiliation.none);
        MUCLightChangeAffiliationsIQ changeAffiliationsIQ = new MUCLightChangeAffiliationsIQ((Jid)this.room, affiliations);
        IQ responseIq = (IQ)this.connection.createStanzaCollectorAndSend((IQ)changeAffiliationsIQ).nextResultOrThrow();
        boolean roomLeft = responseIq.getType().equals((Object)IQ.Type.result);
        if (roomLeft) {
            this.removeConnectionCallbacks();
        }
    }

    public MUCLightRoomInfo getFullInfo(String version) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightGetInfoIQ mucLightGetInfoIQ = new MUCLightGetInfoIQ((Jid)this.room, version);
        IQ responseIq = (IQ)this.connection.createStanzaCollectorAndSend((IQ)mucLightGetInfoIQ).nextResultOrThrow();
        MUCLightInfoIQ mucLightInfoResponseIQ = (MUCLightInfoIQ)responseIq;
        return new MUCLightRoomInfo(mucLightInfoResponseIQ.getVersion(), (Jid)this.room, mucLightInfoResponseIQ.getConfiguration(), mucLightInfoResponseIQ.getOccupants());
    }

    public MUCLightRoomInfo getFullInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getFullInfo(null);
    }

    public MUCLightRoomConfiguration getConfiguration(String version) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightGetConfigsIQ mucLightGetConfigsIQ = new MUCLightGetConfigsIQ((Jid)this.room, version);
        IQ responseIq = (IQ)this.connection.createStanzaCollectorAndSend((IQ)mucLightGetConfigsIQ).nextResultOrThrow();
        MUCLightConfigurationIQ mucLightConfigurationIQ = (MUCLightConfigurationIQ)responseIq;
        return mucLightConfigurationIQ.getConfiguration();
    }

    public MUCLightRoomConfiguration getConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getConfiguration(null);
    }

    public HashMap<Jid, MUCLightAffiliation> getAffiliations(String version) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightGetAffiliationsIQ mucLightGetAffiliationsIQ = new MUCLightGetAffiliationsIQ((Jid)this.room, version);
        IQ responseIq = (IQ)this.connection.createStanzaCollectorAndSend((IQ)mucLightGetAffiliationsIQ).nextResultOrThrow();
        MUCLightAffiliationsIQ mucLightAffiliationsIQ = (MUCLightAffiliationsIQ)responseIq;
        return mucLightAffiliationsIQ.getAffiliations();
    }

    public HashMap<Jid, MUCLightAffiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliations(null);
    }

    public void changeAffiliations(HashMap<Jid, MUCLightAffiliation> affiliations) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightChangeAffiliationsIQ changeAffiliationsIQ = new MUCLightChangeAffiliationsIQ((Jid)this.room, affiliations);
        this.connection.createStanzaCollectorAndSend((IQ)changeAffiliationsIQ).nextResultOrThrow();
    }

    public void destroy() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightDestroyIQ mucLightDestroyIQ = new MUCLightDestroyIQ((Jid)this.room);
        IQ responseIq = (IQ)this.connection.createStanzaCollectorAndSend((IQ)mucLightDestroyIQ).nextResultOrThrow();
        boolean roomDestroyed = responseIq.getType().equals((Object)IQ.Type.result);
        if (roomDestroyed) {
            this.removeConnectionCallbacks();
        }
    }

    public void changeSubject(String subject) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightSetConfigsIQ mucLightSetConfigIQ = new MUCLightSetConfigsIQ((Jid)this.room, null, subject, null);
        this.connection.createStanzaCollectorAndSend((IQ)mucLightSetConfigIQ).nextResultOrThrow();
    }

    public void changeRoomName(String roomName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightSetConfigsIQ mucLightSetConfigIQ = new MUCLightSetConfigsIQ((Jid)this.room, roomName, null);
        this.connection.createStanzaCollectorAndSend((IQ)mucLightSetConfigIQ).nextResultOrThrow();
    }

    public void setRoomConfigs(HashMap<String, String> customConfigs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.setRoomConfigs(null, customConfigs);
    }

    public void setRoomConfigs(String roomName, HashMap<String, String> customConfigs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightSetConfigsIQ mucLightSetConfigIQ = new MUCLightSetConfigsIQ((Jid)this.room, roomName, customConfigs);
        this.connection.createStanzaCollectorAndSend((IQ)mucLightSetConfigIQ).nextResultOrThrow();
    }
}

