/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.reference.element;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.BareJid;

public class ReferenceElement
implements ExtensionElement {
    public static final String ELEMENT = "reference";
    public static final String ATTR_BEGIN = "begin";
    public static final String ATTR_END = "end";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_ANCHOR = "anchor";
    public static final String ATTR_URI = "uri";
    private final Integer begin;
    private final Integer end;
    private final Type type;
    private final String anchor;
    private final URI uri;
    private final ExtensionElement child;

    public ReferenceElement(Integer begin, Integer end, Type type, String anchor, URI uri, ExtensionElement child) {
        if (begin != null && begin < 0) {
            throw new IllegalArgumentException("Attribute 'begin' MUST NOT be smaller than 0.");
        }
        if (end != null && end < 0) {
            throw new IllegalArgumentException("Attribute 'end' MUST NOT be smaller than 0.");
        }
        if (begin != null && end != null && begin >= end) {
            throw new IllegalArgumentException("Attribute 'begin' MUST be smaller than attribute 'end'.");
        }
        Objects.requireNonNull((Object)((Object)type));
        this.begin = begin;
        this.end = end;
        this.type = type;
        this.anchor = anchor;
        this.uri = uri;
        this.child = child;
    }

    public ReferenceElement(Integer begin, Integer end, Type type, String anchor, URI uri) {
        this(begin, end, type, anchor, uri, null);
    }

    public Integer getBegin() {
        return this.begin;
    }

    public Integer getEnd() {
        return this.end;
    }

    public Type getType() {
        return this.type;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public URI getUri() {
        return this.uri;
    }

    public static void addMention(Stanza stanza, int begin, int end, BareJid jid) {
        URI uri;
        try {
            uri = new URI("xmpp:" + jid.toString());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)"Cannot create URI from bareJid.");
        }
        ReferenceElement reference = new ReferenceElement(begin, end, Type.mention, null, uri);
        stanza.addExtension((ExtensionElement)reference);
    }

    public static List<ReferenceElement> getReferencesFromStanza(Stanza stanza) {
        ArrayList<ReferenceElement> references = new ArrayList<ReferenceElement>();
        List extensions = stanza.getExtensions(ELEMENT, "urn:xmpp:reference:0");
        for (ExtensionElement e : extensions) {
            references.add((ReferenceElement)e);
        }
        return references;
    }

    public static boolean containsReferences(Stanza stanza) {
        return ReferenceElement.getReferencesFromStanza(stanza).size() > 0;
    }

    public String getNamespace() {
        return "urn:xmpp:reference:0";
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).optIntAttribute(ATTR_BEGIN, this.begin != null ? this.begin : -1).optIntAttribute(ATTR_END, this.end != null ? this.end : -1).attribute(ATTR_TYPE, this.type.toString()).optAttribute(ATTR_ANCHOR, this.anchor).optAttribute(ATTR_URI, this.uri != null ? this.uri.toString() : null);
        if (this.child == null) {
            return xml.closeEmptyElement();
        }
        return xml.rightAngleBracket().append(this.child.toXML()).closeElement((NamedElement)this);
    }

    public static enum Type {
        mention,
        data;

    }
}

