/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoRatchet;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.exceptions.UntrustedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoStoreConnector;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.InvalidVersionException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public class SignalOmemoRatchet
extends OmemoRatchet<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> {
    private static final Logger LOGGER = Logger.getLogger(OmemoRatchet.class.getName());
    private final SignalOmemoStoreConnector storeConnector;

    SignalOmemoRatchet(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> store) {
        super(omemoManager, store);
        this.storeConnector = new SignalOmemoStoreConnector(omemoManager, store);
    }

    public byte[] doubleRatchetDecrypt(OmemoDevice sender, byte[] encryptedKey) throws CorruptedOmemoKeyException, NoRawSessionException, CryptoFailedException, UntrustedOmemoIdentityException, IOException {
        byte[] decryptedKey;
        SessionCipher cipher = this.getCipher(sender);
        try {
            PreKeySignalMessage preKeyMessage = new PreKeySignalMessage(encryptedKey);
            if (!preKeyMessage.getPreKeyId().isPresent()) {
                throw new CryptoFailedException("PreKeyMessage did not contain a preKeyId.");
            }
            IdentityKey messageIdentityKey = preKeyMessage.getIdentityKey();
            IdentityKey previousIdentityKey = (IdentityKey)this.store.loadOmemoIdentityKey(this.storeConnector.getOurDevice(), sender);
            if (previousIdentityKey != null && !previousIdentityKey.getFingerprint().equals(messageIdentityKey.getFingerprint())) {
                throw new UntrustedOmemoIdentityException(sender, this.store.keyUtil().getFingerprintOfIdentityKey((Object)previousIdentityKey), this.store.keyUtil().getFingerprintOfIdentityKey((Object)messageIdentityKey));
            }
            try {
                decryptedKey = cipher.decrypt(preKeyMessage);
            }
            catch (UntrustedIdentityException e) {
                throw new AssertionError((Object)"Signals trust management MUST be disabled.");
            }
            catch (InvalidKeyException | LegacyMessageException e) {
                throw new CryptoFailedException((Exception)e);
            }
            catch (InvalidKeyIdException e) {
                throw new NoRawSessionException(sender, (Exception)((Object)e));
            }
            catch (DuplicateMessageException e) {
                LOGGER.log(Level.INFO, "Decryption of PreKeyMessage from " + sender + " failed, since the message has been decrypted before.");
                return null;
            }
        }
        catch (InvalidMessageException | InvalidVersionException noPreKeyMessage) {
            try {
                SignalMessage message = new SignalMessage(encryptedKey);
                decryptedKey = this.getCipher(sender).decrypt(message);
            }
            catch (UntrustedIdentityException e) {
                throw new AssertionError((Object)"Signals trust management MUST be disabled.");
            }
            catch (InvalidMessageException | NoSessionException e) {
                throw new NoRawSessionException(sender, (Exception)e);
            }
            catch (LegacyMessageException e) {
                throw new CryptoFailedException((Exception)((Object)e));
            }
            catch (DuplicateMessageException e1) {
                LOGGER.log(Level.INFO, "Decryption of SignalMessage from " + sender + " failed, since the message has been decrypted before.");
                return null;
            }
        }
        return decryptedKey;
    }

    public CiphertextTuple doubleRatchetEncrypt(OmemoDevice recipient, byte[] messageKey) {
        CiphertextMessage ciphertextMessage;
        try {
            ciphertextMessage = this.getCipher(recipient).encrypt(messageKey);
        }
        catch (UntrustedIdentityException e) {
            throw new AssertionError((Object)"Signals trust management MUST be disabled.");
        }
        int type = ciphertextMessage.getType() == 3 ? 1 : 0;
        return new CiphertextTuple(ciphertextMessage.serialize(), type);
    }

    private SessionCipher getCipher(OmemoDevice device) {
        return new SessionCipher((SessionStore)this.storeConnector, (PreKeyStore)this.storeConnector, (SignedPreKeyStore)this.storeConnector, (IdentityKeyStore)this.storeConnector, SignalOmemoStoreConnector.asAddress(device));
    }
}

