/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.maven.plugins.shade.filter.DependenciesClassAdapter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassDependencies {
    static final String CLASS_SUFFIX = ".class";
    static final String SERVICES_ENTRY_PREFIX = "META-INF/services/";
    private static final Splitter SERVICES_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\n\r")).trimResults().omitEmptyStrings();
    private final SetMultimap<String, String> services = HashMultimap.create();
    private final Multimap<String, String> dependencies = HashMultimap.create((int)100, (int)100);
    private final Set<String> classes = Sets.newHashSetWithExpectedSize((int)1000);
    private final Set<String> included = Sets.newHashSetWithExpectedSize((int)100);
    private final List<SimpleFilter> currentFilters = Lists.newArrayList();
    private final List<SimpleFilter> filters;
    boolean allClassesSpecificallyIncluded;

    ClassDependencies(List<SimpleFilter> filters) {
        this.filters = filters;
    }

    String readClass(InputStream input) throws IOException {
        DependenciesClassAdapter adapter = DependenciesClassAdapter.readFrom(input);
        this.dependencies.putAll((Object)adapter.getName(), adapter.getDependencies());
        return adapter.getName();
    }

    final Set<String> buildAllUnusedClasses() {
        TransitiveDependenciesCollector collecter = new TransitiveDependenciesCollector();
        collecter.addAll(this.included);
        this.collectUsedServiceProviders(collecter);
        return Sets.difference(this.classes, (Set)collecter.all);
    }

    private void collectUsedServiceProviders(TransitiveDependenciesCollector collecter) {
        for (Map.Entry providers : this.services.asMap().entrySet()) {
            if (!collecter.all.contains(providers.getKey())) continue;
            collecter.addAll((Iterable)providers.getValue());
        }
    }

    void addJar(File jarFile) throws IOException {
        this.setupCurrentFilters(jarFile);
        this.traverse(jarFile);
        this.currentFilters.clear();
    }

    private void setupCurrentFilters(File jarFile) {
        Preconditions.checkState((boolean)this.currentFilters.isEmpty());
        for (SimpleFilter filter : this.filters) {
            if (!filter.canFilter(jarFile)) continue;
            this.currentFilters.add(filter);
        }
    }

    protected void readEntry(String entryName, InputStream inputStream) throws IOException {
        if (entryName.startsWith(SERVICES_ENTRY_PREFIX)) {
            this.readServiceEntry(entryName, inputStream);
        } else if (entryName.endsWith(CLASS_SUFFIX)) {
            this.readClassEntry(entryName, inputStream);
        }
    }

    private void readServiceEntry(String name, InputStream inputStream) throws IOException {
        if (!this.isIncluded(name)) {
            return;
        }
        String typeName = ClassDependencies.toClassFilePath(name.replace(SERVICES_ENTRY_PREFIX, ""));
        if (typeName.isEmpty()) {
            return;
        }
        boolean forcedInclusion = this.isSpecificallyIncluded(name);
        if (forcedInclusion) {
            this.included.add(typeName);
        }
        String content = IOUtil.toString((InputStream)inputStream, (String)Charsets.UTF_8.name());
        for (String providerType : SERVICES_SPLITTER.split((CharSequence)content)) {
            String providerName = ClassDependencies.toClassFilePath(providerType);
            this.services.put((Object)typeName, (Object)providerName);
            if (!forcedInclusion) continue;
            this.included.add(providerName);
        }
    }

    static String toClassFilePath(String providerType) {
        return providerType.replace('.', '/');
    }

    private void readClassEntry(String entryName, InputStream inputStream) throws IOException {
        String typeName = this.readClass(inputStream);
        this.classes.add(typeName);
        if (this.isSpecificallyIncluded(entryName)) {
            this.included.add(typeName);
        }
    }

    private boolean isIncluded(String name) {
        for (SimpleFilter filter : this.currentFilters) {
            if (!filter.isFiltered(name)) continue;
            return false;
        }
        return true;
    }

    private boolean isSpecificallyIncluded(String name) {
        if (this.allClassesSpecificallyIncluded) {
            return true;
        }
        for (SimpleFilter filter : this.currentFilters) {
            if (!filter.isSpecificallyIncluded(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void traverse(File jarFile) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
        try {
            JarEntry jarEntry;
            jarInputStream.getManifest();
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                this.readEntry(jarEntry.getName(), jarInputStream);
            }
        }
        finally {
            jarInputStream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransitiveDependenciesCollector {
        private final Set<String> all = Sets.newHashSet();

        private TransitiveDependenciesCollector() {
        }

        void add(String typeName) {
            if (this.all.add(typeName)) {
                this.addAll(ClassDependencies.this.dependencies.get((Object)typeName));
            }
        }

        void addAll(Iterable<String> typeNames) {
            for (String typeName : typeNames) {
                this.add(typeName);
            }
        }
    }
}

