package org.immutables.value.processor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.processor.meta.GsonMirrors;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.ValueType;

/**
 * Immutable implementation of {@link Gsons.TypeAdapterTypes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTypeAdapterTypes.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Gsons.TypeAdapterTypes"})
@Immutable
public final class ImmutableTypeAdapterTypes implements Gsons.TypeAdapterTypes {
  private final Proto.AbstractDeclaring definedBy;
  private final String packageGenerated;
  private final ImmutableList<ValueType> types;
  private final GsonMirrors.TypeAdapters mirror;

  private ImmutableTypeAdapterTypes(
      Proto.AbstractDeclaring definedBy,
      String packageGenerated,
      ImmutableList<ValueType> types,
      GsonMirrors.TypeAdapters mirror) {
    this.definedBy = definedBy;
    this.packageGenerated = packageGenerated;
    this.types = types;
    this.mirror = mirror;
  }

  /**
   * @return The value of the {@code definedBy} attribute
   */
  @Override
  public Proto.AbstractDeclaring definedBy() {
    return definedBy;
  }

  /**
   * @return The value of the {@code packageGenerated} attribute
   */
  @Override
  public String packageGenerated() {
    return packageGenerated;
  }

  /**
   * @return The value of the {@code types} attribute
   */
  @Override
  public ImmutableList<ValueType> types() {
    return types;
  }

  /**
   * @return The value of the {@code mirror} attribute
   */
  @Override
  public GsonMirrors.TypeAdapters mirror() {
    return mirror;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Gsons.TypeAdapterTypes#definedBy() definedBy} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definedBy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeAdapterTypes withDefinedBy(Proto.AbstractDeclaring value) {
    if (this.definedBy == value) return this;
    Proto.AbstractDeclaring newValue = Objects.requireNonNull(value, "definedBy");
    return new ImmutableTypeAdapterTypes(newValue, this.packageGenerated, this.types, this.mirror);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Gsons.TypeAdapterTypes#packageGenerated() packageGenerated} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for packageGenerated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeAdapterTypes withPackageGenerated(String value) {
    if (this.packageGenerated.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "packageGenerated");
    return new ImmutableTypeAdapterTypes(this.definedBy, newValue, this.types, this.mirror);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Gsons.TypeAdapterTypes#types() types}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypeAdapterTypes withTypes(ValueType... elements) {
    ImmutableList<ValueType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTypeAdapterTypes(this.definedBy, this.packageGenerated, newValue, this.mirror);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Gsons.TypeAdapterTypes#types() types}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of types elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypeAdapterTypes withTypes(Iterable<? extends ValueType> elements) {
    if (this.types == elements) return this;
    ImmutableList<ValueType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTypeAdapterTypes(this.definedBy, this.packageGenerated, newValue, this.mirror);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Gsons.TypeAdapterTypes#mirror() mirror} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mirror
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeAdapterTypes withMirror(GsonMirrors.TypeAdapters value) {
    if (this.mirror == value) return this;
    GsonMirrors.TypeAdapters newValue = Objects.requireNonNull(value, "mirror");
    return new ImmutableTypeAdapterTypes(this.definedBy, this.packageGenerated, this.types, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypeAdapterTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypeAdapterTypes
        && equalTo((ImmutableTypeAdapterTypes) another);
  }

  private boolean equalTo(ImmutableTypeAdapterTypes another) {
    return definedBy.equals(another.definedBy)
        && packageGenerated.equals(another.packageGenerated)
        && types.equals(another.types)
        && mirror.equals(another.mirror);
  }

  /**
   * Computes a hash code from attributes: {@code definedBy}, {@code packageGenerated}, {@code types}, {@code mirror}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + definedBy.hashCode();
    h += (h << 5) + packageGenerated.hashCode();
    h += (h << 5) + types.hashCode();
    h += (h << 5) + mirror.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TypeAdapterTypes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TypeAdapterTypes")
        .omitNullValues()
        .add("definedBy", definedBy)
        .add("packageGenerated", packageGenerated)
        .add("types", types)
        .add("mirror", mirror)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Gsons.TypeAdapterTypes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TypeAdapterTypes instance
   */
  public static ImmutableTypeAdapterTypes copyOf(Gsons.TypeAdapterTypes instance) {
    if (instance instanceof ImmutableTypeAdapterTypes) {
      return (ImmutableTypeAdapterTypes) instance;
    }
    return ImmutableTypeAdapterTypes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTypeAdapterTypes ImmutableTypeAdapterTypes}.
   * @return A new ImmutableTypeAdapterTypes builder
   */
  public static ImmutableTypeAdapterTypes.Builder builder() {
    return new ImmutableTypeAdapterTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTypeAdapterTypes ImmutableTypeAdapterTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEFINED_BY = 0x1L;
    private static final long INIT_BIT_PACKAGE_GENERATED = 0x2L;
    private static final long INIT_BIT_MIRROR = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Proto.AbstractDeclaring definedBy;
    private @Nullable String packageGenerated;
    private ImmutableList.Builder<ValueType> types = ImmutableList.builder();
    private @Nullable GsonMirrors.TypeAdapters mirror;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TypeAdapterTypes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Gsons.TypeAdapterTypes instance) {
      Objects.requireNonNull(instance, "instance");
      definedBy(instance.definedBy());
      packageGenerated(instance.packageGenerated());
      addAllTypes(instance.types());
      mirror(instance.mirror());
      return this;
    }

    /**
     * Initializes the value for the {@link Gsons.TypeAdapterTypes#definedBy() definedBy} attribute.
     * @param definedBy The value for definedBy 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder definedBy(Proto.AbstractDeclaring definedBy) {
      this.definedBy = Objects.requireNonNull(definedBy, "definedBy");
      initBits &= ~INIT_BIT_DEFINED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link Gsons.TypeAdapterTypes#packageGenerated() packageGenerated} attribute.
     * @param packageGenerated The value for packageGenerated 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageGenerated(String packageGenerated) {
      this.packageGenerated = Objects.requireNonNull(packageGenerated, "packageGenerated");
      initBits &= ~INIT_BIT_PACKAGE_GENERATED;
      return this;
    }

    /**
     * Adds one element to {@link Gsons.TypeAdapterTypes#types() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTypes(ValueType element) {
      this.types.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Gsons.TypeAdapterTypes#types() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTypes(ValueType... elements) {
      this.types.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Gsons.TypeAdapterTypes#types() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<? extends ValueType> elements) {
      this.types = ImmutableList.builder();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link Gsons.TypeAdapterTypes#types() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<? extends ValueType> elements) {
      this.types.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Gsons.TypeAdapterTypes#mirror() mirror} attribute.
     * @param mirror The value for mirror 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mirror(GsonMirrors.TypeAdapters mirror) {
      this.mirror = Objects.requireNonNull(mirror, "mirror");
      initBits &= ~INIT_BIT_MIRROR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTypeAdapterTypes ImmutableTypeAdapterTypes}.
     * @return An immutable instance of TypeAdapterTypes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypeAdapterTypes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTypeAdapterTypes(definedBy, packageGenerated, types.build(), mirror);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_DEFINED_BY) != 0) attributes.add("definedBy");
      if ((initBits & INIT_BIT_PACKAGE_GENERATED) != 0) attributes.add("packageGenerated");
      if ((initBits & INIT_BIT_MIRROR) != 0) attributes.add("mirror");
      return "Cannot build TypeAdapterTypes, some of required attributes are not set " + attributes;
    }
  }
}
