package org.immutables.value.processor.encode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link EncodingInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new EncodingInfo.Builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "EncodingInfo"})
@Immutable
final class ImmutableEncodingInfo extends EncodingInfo {
  private final String name;
  private final ImmutableSet<String> imports;
  private final Type.Parameters typeParameters;
  private final Type.Factory typeFactory;
  private final ImmutableList<EncodedElement> element;
  private final @Nullable EncodedElement builderCopy;
  private final @Nullable EncodedElement isWasInit;
  private final EncodedElement from;
  private final EncodedElement impl;
  private final EncodedElement build;
  private final EncodedElement equals;
  private final EncodedElement hash;
  private final EncodedElement string;
  private final ImmutableSet<String> crossReferencedMethods;

  private ImmutableEncodingInfo(
      String name,
      ImmutableSet<String> imports,
      Type.Parameters typeParameters,
      Type.Factory typeFactory,
      ImmutableList<EncodedElement> element) {
    this.name = name;
    this.imports = imports;
    this.typeParameters = typeParameters;
    this.typeFactory = typeFactory;
    this.element = element;
    this.builderCopy = initShim.builderCopy();
    this.isWasInit = initShim.isWasInit();
    this.from = initShim.from();
    this.impl = initShim.impl();
    this.build = initShim.build();
    this.equals = initShim.equals();
    this.hash = initShim.hash();
    this.string = initShim.string();
    this.crossReferencedMethods = initShim.crossReferencedMethods();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private EncodedElement builderCopy;
    private int builderCopyBuildStage;

    EncodedElement builderCopy() {
      if (builderCopyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (builderCopyBuildStage == STAGE_UNINITIALIZED) {
        builderCopyBuildStage = STAGE_INITIALIZING;
        this.builderCopy = ImmutableEncodingInfo.super.builderCopy();
        builderCopyBuildStage = STAGE_INITIALIZED;
      }
      return this.builderCopy;
    }
    private EncodedElement isWasInit;
    private int isWasInitBuildStage;

    EncodedElement isWasInit() {
      if (isWasInitBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isWasInitBuildStage == STAGE_UNINITIALIZED) {
        isWasInitBuildStage = STAGE_INITIALIZING;
        this.isWasInit = ImmutableEncodingInfo.super.isWasInit();
        isWasInitBuildStage = STAGE_INITIALIZED;
      }
      return this.isWasInit;
    }
    private EncodedElement from;
    private int fromBuildStage;

    EncodedElement from() {
      if (fromBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fromBuildStage == STAGE_UNINITIALIZED) {
        fromBuildStage = STAGE_INITIALIZING;
        this.from = Objects.requireNonNull(ImmutableEncodingInfo.super.from(), "from");
        fromBuildStage = STAGE_INITIALIZED;
      }
      return this.from;
    }
    private EncodedElement impl;
    private int implBuildStage;

    EncodedElement impl() {
      if (implBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (implBuildStage == STAGE_UNINITIALIZED) {
        implBuildStage = STAGE_INITIALIZING;
        this.impl = Objects.requireNonNull(ImmutableEncodingInfo.super.impl(), "impl");
        implBuildStage = STAGE_INITIALIZED;
      }
      return this.impl;
    }
    private EncodedElement build;
    private int buildBuildStage;

    EncodedElement build() {
      if (buildBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildBuildStage == STAGE_UNINITIALIZED) {
        buildBuildStage = STAGE_INITIALIZING;
        this.build = Objects.requireNonNull(ImmutableEncodingInfo.super.build(), "build");
        buildBuildStage = STAGE_INITIALIZED;
      }
      return this.build;
    }
    private EncodedElement equals;
    private int equalsBuildStage;

    EncodedElement equals() {
      if (equalsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (equalsBuildStage == STAGE_UNINITIALIZED) {
        equalsBuildStage = STAGE_INITIALIZING;
        this.equals = Objects.requireNonNull(ImmutableEncodingInfo.super.equals(), "equals");
        equalsBuildStage = STAGE_INITIALIZED;
      }
      return this.equals;
    }
    private EncodedElement hash;
    private int hashBuildStage;

    EncodedElement hash() {
      if (hashBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hashBuildStage == STAGE_UNINITIALIZED) {
        hashBuildStage = STAGE_INITIALIZING;
        this.hash = Objects.requireNonNull(ImmutableEncodingInfo.super.hash(), "hash");
        hashBuildStage = STAGE_INITIALIZED;
      }
      return this.hash;
    }
    private EncodedElement string;
    private int stringBuildStage;

    EncodedElement string() {
      if (stringBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stringBuildStage == STAGE_UNINITIALIZED) {
        stringBuildStage = STAGE_INITIALIZING;
        this.string = Objects.requireNonNull(ImmutableEncodingInfo.super.string(), "string");
        stringBuildStage = STAGE_INITIALIZED;
      }
      return this.string;
    }
    private ImmutableSet<String> crossReferencedMethods;
    private int crossReferencedMethodsBuildStage;

    ImmutableSet<String> crossReferencedMethods() {
      if (crossReferencedMethodsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (crossReferencedMethodsBuildStage == STAGE_UNINITIALIZED) {
        crossReferencedMethodsBuildStage = STAGE_INITIALIZING;
        this.crossReferencedMethods = Objects.requireNonNull(ImmutableEncodingInfo.super.crossReferencedMethods(), "crossReferencedMethods");
        crossReferencedMethodsBuildStage = STAGE_INITIALIZED;
      }
      return this.crossReferencedMethods;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = Lists.newArrayList();
      if (builderCopyBuildStage == STAGE_INITIALIZING) attributes.add("builderCopy");
      if (isWasInitBuildStage == STAGE_INITIALIZING) attributes.add("isWasInit");
      if (fromBuildStage == STAGE_INITIALIZING) attributes.add("from");
      if (implBuildStage == STAGE_INITIALIZING) attributes.add("impl");
      if (buildBuildStage == STAGE_INITIALIZING) attributes.add("build");
      if (equalsBuildStage == STAGE_INITIALIZING) attributes.add("equals");
      if (hashBuildStage == STAGE_INITIALIZING) attributes.add("hash");
      if (stringBuildStage == STAGE_INITIALIZING) attributes.add("string");
      if (crossReferencedMethodsBuildStage == STAGE_INITIALIZING) attributes.add("crossReferencedMethods");
      return "Cannot build EncodingInfo, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  String name() {
    return name;
  }

  /**
   * @return The value of the {@code imports} attribute
   */
  @Override
  ImmutableSet<String> imports() {
    return imports;
  }

  /**
   * @return The value of the {@code typeParameters} attribute
   */
  @Override
  Type.Parameters typeParameters() {
    return typeParameters;
  }

  /**
   * @return The value of the {@code typeFactory} attribute
   */
  @Override
  Type.Factory typeFactory() {
    return typeFactory;
  }

  /**
   * @return The value of the {@code element} attribute
   */
  @Override
  ImmutableList<EncodedElement> element() {
    return element;
  }

  /**
   * @return The computed-at-construction value of the {@code builderCopy} attribute
   */
  @Override
  public @Nullable EncodedElement builderCopy() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.builderCopy()
        : this.builderCopy;
  }

  /**
   * @return The computed-at-construction value of the {@code isWasInit} attribute
   */
  @Override
  public @Nullable EncodedElement isWasInit() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isWasInit()
        : this.isWasInit;
  }

  /**
   * @return The computed-at-construction value of the {@code from} attribute
   */
  @Override
  public EncodedElement from() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.from()
        : this.from;
  }

  /**
   * @return The computed-at-construction value of the {@code impl} attribute
   */
  @Override
  public EncodedElement impl() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.impl()
        : this.impl;
  }

  /**
   * @return The computed-at-construction value of the {@code build} attribute
   */
  @Override
  public EncodedElement build() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.build()
        : this.build;
  }

  /**
   * @return The computed-at-construction value of the {@code equals} attribute
   */
  @Override
  public EncodedElement equals() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.equals()
        : this.equals;
  }

  /**
   * @return The computed-at-construction value of the {@code hash} attribute
   */
  @Override
  public EncodedElement hash() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.hash()
        : this.hash;
  }

  /**
   * @return The computed-at-construction value of the {@code string} attribute
   */
  @Override
  public EncodedElement string() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.string()
        : this.string;
  }

  /**
   * @return The computed-at-construction value of the {@code crossReferencedMethods} attribute
   */
  @Override
  ImmutableSet<String> crossReferencedMethods() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.crossReferencedMethods()
        : this.crossReferencedMethods;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodingInfo#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodingInfo withName(String value) {
    if (this.name.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "name");
    return new ImmutableEncodingInfo(newValue, this.imports, this.typeParameters, this.typeFactory, this.element);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodingInfo#imports() imports}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodingInfo withImports(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableEncodingInfo(this.name, newValue, this.typeParameters, this.typeFactory, this.element);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodingInfo#imports() imports}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of imports elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodingInfo withImports(Iterable<String> elements) {
    if (this.imports == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableEncodingInfo(this.name, newValue, this.typeParameters, this.typeFactory, this.element);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodingInfo#typeParameters() typeParameters} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeParameters
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodingInfo withTypeParameters(Type.Parameters value) {
    if (this.typeParameters == value) return this;
    Type.Parameters newValue = Objects.requireNonNull(value, "typeParameters");
    return new ImmutableEncodingInfo(this.name, this.imports, newValue, this.typeFactory, this.element);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodingInfo#typeFactory() typeFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeFactory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodingInfo withTypeFactory(Type.Factory value) {
    if (this.typeFactory == value) return this;
    Type.Factory newValue = Objects.requireNonNull(value, "typeFactory");
    return new ImmutableEncodingInfo(this.name, this.imports, this.typeParameters, newValue, this.element);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodingInfo#element() element}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodingInfo withElement(EncodedElement... elements) {
    ImmutableList<EncodedElement> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodingInfo(this.name, this.imports, this.typeParameters, this.typeFactory, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodingInfo#element() element}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of element elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodingInfo withElement(Iterable<? extends EncodedElement> elements) {
    if (this.element == elements) return this;
    ImmutableList<EncodedElement> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodingInfo(this.name, this.imports, this.typeParameters, this.typeFactory, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEncodingInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEncodingInfo
        && equalTo((ImmutableEncodingInfo) another);
  }

  private boolean equalTo(ImmutableEncodingInfo another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EncodingInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EncodingInfo")
        .omitNullValues()
        .add("name", name)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link EncodingInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EncodingInfo instance
   */
  public static EncodingInfo copyOf(EncodingInfo instance) {
    if (instance instanceof ImmutableEncodingInfo) {
      return (ImmutableEncodingInfo) instance;
    }
    return new EncodingInfo.Builder()
        .name(instance.name())
        .addAllImports(instance.imports())
        .typeParameters(instance.typeParameters())
        .typeFactory(instance.typeFactory())
        .addAllElement(instance.element())
        .build();
  }

  /**
   * Builds instances of type {@link EncodingInfo EncodingInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE_PARAMETERS = 0x2L;
    private static final long INIT_BIT_TYPE_FACTORY = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String name;
    private ImmutableSet.Builder<String> imports = ImmutableSet.builder();
    private @Nullable Type.Parameters typeParameters;
    private @Nullable Type.Factory typeFactory;
    private ImmutableList.Builder<EncodedElement> element = ImmutableList.builder();

    /**
     * Creates a builder for {@link EncodingInfo EncodingInfo} instances.
     */
    public Builder() {
      if (!(this instanceof EncodingInfo.Builder)) {
        throw new UnsupportedOperationException("Use: new EncodingInfo.Builder()");
      }
    }

    /**
     * Initializes the value for the {@link EncodingInfo#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (EncodingInfo.Builder) this;
    }

    /**
     * Adds one element to {@link EncodingInfo#imports() imports} set.
     * @param element A imports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder addImports(String element) {
      this.imports.add(element);
      return (EncodingInfo.Builder) this;
    }

    /**
     * Adds elements to {@link EncodingInfo#imports() imports} set.
     * @param elements An array of imports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder addImports(String... elements) {
      this.imports.add(elements);
      return (EncodingInfo.Builder) this;
    }

    /**
     * Adds elements to {@link EncodingInfo#imports() imports} set.
     * @param elements An iterable of imports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder addAllImports(Iterable<String> elements) {
      this.imports.addAll(elements);
      return (EncodingInfo.Builder) this;
    }

    /**
     * Initializes the value for the {@link EncodingInfo#typeParameters() typeParameters} attribute.
     * @param typeParameters The value for typeParameters 
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder typeParameters(Type.Parameters typeParameters) {
      checkNotIsSet(typeParametersIsSet(), "typeParameters");
      this.typeParameters = Objects.requireNonNull(typeParameters, "typeParameters");
      initBits &= ~INIT_BIT_TYPE_PARAMETERS;
      return (EncodingInfo.Builder) this;
    }

    /**
     * Initializes the value for the {@link EncodingInfo#typeFactory() typeFactory} attribute.
     * @param typeFactory The value for typeFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder typeFactory(Type.Factory typeFactory) {
      checkNotIsSet(typeFactoryIsSet(), "typeFactory");
      this.typeFactory = Objects.requireNonNull(typeFactory, "typeFactory");
      initBits &= ~INIT_BIT_TYPE_FACTORY;
      return (EncodingInfo.Builder) this;
    }

    /**
     * Adds one element to {@link EncodingInfo#element() element} list.
     * @param element A element element
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder addElement(EncodedElement element) {
      this.element.add(element);
      return (EncodingInfo.Builder) this;
    }

    /**
     * Adds elements to {@link EncodingInfo#element() element} list.
     * @param elements An array of element elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder addElement(EncodedElement... elements) {
      this.element.add(elements);
      return (EncodingInfo.Builder) this;
    }

    /**
     * Adds elements to {@link EncodingInfo#element() element} list.
     * @param elements An iterable of element elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final EncodingInfo.Builder addAllElement(Iterable<? extends EncodedElement> elements) {
      this.element.addAll(elements);
      return (EncodingInfo.Builder) this;
    }

    /**
     * Builds a new {@link EncodingInfo EncodingInfo}.
     * @return An immutable instance of EncodingInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EncodingInfo build() {
      checkRequiredAttributes();
      return new ImmutableEncodingInfo(name, imports.build(), typeParameters, typeFactory, element.build());
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean typeParametersIsSet() {
      return (initBits & INIT_BIT_TYPE_PARAMETERS) == 0;
    }

    private boolean typeFactoryIsSet() {
      return (initBits & INIT_BIT_TYPE_FACTORY) == 0;
    }

    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of EncodingInfo is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) attributes.add("name");
      if (!typeParametersIsSet()) attributes.add("typeParameters");
      if (!typeFactoryIsSet()) attributes.add("typeFactory");
      return "Cannot build EncodingInfo, some of required attributes are not set " + attributes;
    }
  }
}
