package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.immutables.generator.SourceExtraction;
import org.immutables.value.processor.encode.EncodingInfo;
import org.immutables.value.processor.encode.Instantiator;

/**
 * {@code ImmutableProto} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Proto}.
 * @see ImmutableProto.DeclaringPackage
 * @see ImmutableProto.Protoclass
 * @see ImmutableProto.DeclaringType
 * @see ImmutableProto.Environment
 * @see ImmutableProto.MetaAnnotated
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Proto"})
public final class ImmutableProto {
  private ImmutableProto() {}

  /**
   * Immutable implementation of {@link Proto.DeclaringPackage}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableProto.DeclaringPackage.builder()}.
   */
  @Immutable
  public static final class DeclaringPackage extends Proto.DeclaringPackage {
    private final PackageElement element;
    private final String simpleName;
    private final String name;
    private final Proto.Interning interner;
    private final Proto.Environment environment;

    private DeclaringPackage(
        PackageElement element,
        Proto.Interning interner,
        Proto.Environment environment) {
      this.element = element;
      this.interner = interner;
      this.environment = environment;
      this.simpleName = initShim.simpleName();
      this.name = initShim.name();
      this.initShim = null;
    }

    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private String simpleName;
      private int simpleNameBuildStage;

      String simpleName() {
        if (simpleNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (simpleNameBuildStage == STAGE_UNINITIALIZED) {
          simpleNameBuildStage = STAGE_INITIALIZING;
          this.simpleName = Objects.requireNonNull(DeclaringPackage.super.simpleName(), "simpleName");
          simpleNameBuildStage = STAGE_INITIALIZED;
        }
        return this.simpleName;
      }
      private String name;
      private int nameBuildStage;

      String name() {
        if (nameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (nameBuildStage == STAGE_UNINITIALIZED) {
          nameBuildStage = STAGE_INITIALIZING;
          this.name = Objects.requireNonNull(DeclaringPackage.super.name(), "name");
          nameBuildStage = STAGE_INITIALIZED;
        }
        return this.name;
      }

      private String formatInitCycleMessage() {
        ArrayList<String> attributes = Lists.newArrayList();
        if (simpleNameBuildStage == STAGE_INITIALIZING) attributes.add("simpleName");
        if (nameBuildStage == STAGE_INITIALIZING) attributes.add("name");
        return "Cannot build DeclaringPackage, attribute initializers form cycle" + attributes;
      }
    }

    /**
     * @return The value of the {@code element} attribute
     */
    @Override
    public PackageElement element() {
      return element;
    }

    /**
     * @return The computed-at-construction value of the {@code simpleName} attribute
     */
    @Override
    public String simpleName() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.simpleName()
          : this.simpleName;
    }

    /**
     * Name is the only equivalence attribute. Basically packages are interned by name.
     * @return package name
     */
    @Override
    public String name() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.name()
          : this.name;
    }

    /**
     * used to intern packaged created internally
     */
    @Override
    Proto.Interning interner() {
      return interner;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @Override
    Proto.Environment environment() {
      return environment;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.DeclaringPackage#element() element} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for element
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.DeclaringPackage withElement(PackageElement value) {
      if (this.element == value) return this;
      PackageElement newValue = Objects.requireNonNull(value, "element");
      return new ImmutableProto.DeclaringPackage(newValue, this.interner, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.DeclaringPackage#interner() interner} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for interner
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.DeclaringPackage withInterner(Proto.Interning value) {
      if (this.interner == value) return this;
      Proto.Interning newValue = Objects.requireNonNull(value, "interner");
      return new ImmutableProto.DeclaringPackage(this.element, newValue, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.DeclaringPackage#environment() environment} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.DeclaringPackage withEnvironment(Proto.Environment value) {
      if (this.environment == value) return this;
      Proto.Environment newValue = Objects.requireNonNull(value, "environment");
      return new ImmutableProto.DeclaringPackage(this.element, this.interner, newValue);
    }

    /**
     * This instance is equal to all instances of {@code DeclaringPackage} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableProto.DeclaringPackage
          && equalTo((ImmutableProto.DeclaringPackage) another);
    }

    private boolean equalTo(ImmutableProto.DeclaringPackage another) {
      return name.equals(another.name);
    }

    /**
     * Computes a hash code from attributes: {@code name}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code DeclaringPackage} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("DeclaringPackage")
          .omitNullValues()
          .add("name", name)
          .toString();
    }

    private volatile long lazyInitBitmap;

    private static final long NAMED_PARENT_PACKAGE_LAZY_INIT_BIT = 0x1L;

    private Optional<Proto.DeclaringPackage> namedParentPackage;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#namedParentPackage() namedParentPackage} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Proto.DeclaringPackage> namedParentPackage() {
      if ((lazyInitBitmap & NAMED_PARENT_PACKAGE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & NAMED_PARENT_PACKAGE_LAZY_INIT_BIT) == 0) {
            this.namedParentPackage = Objects.requireNonNull(super.namedParentPackage(), "namedParentPackage");
            lazyInitBitmap |= NAMED_PARENT_PACKAGE_LAZY_INIT_BIT;
          }
        }
      }
      return namedParentPackage;
    }

    private static final long IS_JACKSON_SERIALIZED_LAZY_INIT_BIT = 0x2L;

    private boolean isJacksonSerialized;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#isJacksonSerialized() isJacksonSerialized} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonSerialized() {
      if ((lazyInitBitmap & IS_JACKSON_SERIALIZED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_SERIALIZED_LAZY_INIT_BIT) == 0) {
            this.isJacksonSerialized = super.isJacksonSerialized();
            lazyInitBitmap |= IS_JACKSON_SERIALIZED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonSerialized;
    }

    private static final long IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT = 0x4L;

    private boolean isJacksonDeserialized;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#isJacksonDeserialized() isJacksonDeserialized} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonDeserialized() {
      if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT) == 0) {
            this.isJacksonDeserialized = super.isJacksonDeserialized();
            lazyInitBitmap |= IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonDeserialized;
    }

    private static final long IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT = 0x8L;

    private boolean isJacksonJsonTypeInfo;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#isJacksonJsonTypeInfo() isJacksonJsonTypeInfo} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonJsonTypeInfo() {
      if ((lazyInitBitmap & IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT) == 0) {
            this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
            lazyInitBitmap |= IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonJsonTypeInfo;
    }

    private static final long IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT = 0x10L;

    private boolean isSerialStructural;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#isSerialStructural() isSerialStructural} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isSerialStructural() {
      if ((lazyInitBitmap & IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT) == 0) {
            this.isSerialStructural = super.isSerialStructural();
            lazyInitBitmap |= IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT;
          }
        }
      }
      return isSerialStructural;
    }

    private static final long SERIAL_VERSION_LAZY_INIT_BIT = 0x20L;

    private Optional<Long> serialVersion;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#serialVersion() serialVersion} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Long> serialVersion() {
      if ((lazyInitBitmap & SERIAL_VERSION_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & SERIAL_VERSION_LAZY_INIT_BIT) == 0) {
            this.serialVersion = Objects.requireNonNull(super.serialVersion(), "serialVersion");
            lazyInitBitmap |= SERIAL_VERSION_LAZY_INIT_BIT;
          }
        }
      }
      return serialVersion;
    }

    private static final long STYLE_LAZY_INIT_BIT = 0x40L;

    private Optional<StyleInfo> style;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#style() style} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<StyleInfo> style() {
      if ((lazyInitBitmap & STYLE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & STYLE_LAZY_INIT_BIT) == 0) {
            this.style = Objects.requireNonNull(super.style(), "style");
            lazyInitBitmap |= STYLE_LAZY_INIT_BIT;
          }
        }
      }
      return style;
    }

    private static final long DEPLURALIZE_LAZY_INIT_BIT = 0x80L;

    private Optional<String[]> depluralize;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#depluralize() depluralize} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<String[]> depluralize() {
      if ((lazyInitBitmap & DEPLURALIZE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & DEPLURALIZE_LAZY_INIT_BIT) == 0) {
            this.depluralize = Objects.requireNonNull(super.depluralize(), "depluralize");
            lazyInitBitmap |= DEPLURALIZE_LAZY_INIT_BIT;
          }
        }
      }
      return depluralize;
    }

    private static final long INCLUDE_LAZY_INIT_BIT = 0x100L;

    private Optional<IncludeMirror> include;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#include() include} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<IncludeMirror> include() {
      if ((lazyInitBitmap & INCLUDE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & INCLUDE_LAZY_INIT_BIT) == 0) {
            this.include = Objects.requireNonNull(super.include(), "include");
            lazyInitBitmap |= INCLUDE_LAZY_INIT_BIT;
          }
        }
      }
      return include;
    }

    private static final long BUILDER_INCLUDE_LAZY_INIT_BIT = 0x200L;

    private Optional<FIncludeMirror> builderInclude;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#builderInclude() builderInclude} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<FIncludeMirror> builderInclude() {
      if ((lazyInitBitmap & BUILDER_INCLUDE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & BUILDER_INCLUDE_LAZY_INIT_BIT) == 0) {
            this.builderInclude = Objects.requireNonNull(super.builderInclude(), "builderInclude");
            lazyInitBitmap |= BUILDER_INCLUDE_LAZY_INIT_BIT;
          }
        }
      }
      return builderInclude;
    }

    private static final long TYPE_ADAPTERS_LAZY_INIT_BIT = 0x400L;

    private Optional<TypeAdaptersMirror> typeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#typeAdapters() typeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<TypeAdaptersMirror> typeAdapters() {
      if ((lazyInitBitmap & TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.typeAdapters = Objects.requireNonNull(super.typeAdapters(), "typeAdapters");
            lazyInitBitmap |= TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return typeAdapters;
    }

    private static final long OK_TYPE_ADAPTERS_LAZY_INIT_BIT = 0x800L;

    private Optional<OkTypeAdaptersMirror> okTypeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#okTypeAdapters() okTypeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<OkTypeAdaptersMirror> okTypeAdapters() {
      if ((lazyInitBitmap & OK_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & OK_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.okTypeAdapters = Objects.requireNonNull(super.okTypeAdapters(), "okTypeAdapters");
            lazyInitBitmap |= OK_TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return okTypeAdapters;
    }

    private static final long INCLUDED_TYPES_LAZY_INIT_BIT = 0x1000L;

    private List<TypeElement> includedTypes;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#includedTypes() includedTypes} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public List<TypeElement> includedTypes() {
      if ((lazyInitBitmap & INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
            this.includedTypes = Objects.requireNonNull(super.includedTypes(), "includedTypes");
            lazyInitBitmap |= INCLUDED_TYPES_LAZY_INIT_BIT;
          }
        }
      }
      return includedTypes;
    }

    private static final long BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT = 0x2000L;

    private List<TypeElement> builderIncludedTypes;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#builderIncludedTypes() builderIncludedTypes} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public List<TypeElement> builderIncludedTypes() {
      if ((lazyInitBitmap & BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
            this.builderIncludedTypes = Objects.requireNonNull(super.builderIncludedTypes(), "builderIncludedTypes");
            lazyInitBitmap |= BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT;
          }
        }
      }
      return builderIncludedTypes;
    }

    private static final long META_ANNOTATED_LAZY_INIT_BIT = 0x4000L;

    private List<Proto.MetaAnnotated> metaAnnotated;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#metaAnnotated() metaAnnotated} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public List<Proto.MetaAnnotated> metaAnnotated() {
      if ((lazyInitBitmap & META_ANNOTATED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & META_ANNOTATED_LAZY_INIT_BIT) == 0) {
            this.metaAnnotated = Objects.requireNonNull(super.metaAnnotated(), "metaAnnotated");
            lazyInitBitmap |= META_ANNOTATED_LAZY_INIT_BIT;
          }
        }
      }
      return metaAnnotated;
    }

    private static final long JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT = 0x8000L;

    private Proto.JacksonMode jacksonSerializeMode;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#jacksonSerializeMode() jacksonSerializeMode} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Proto.JacksonMode jacksonSerializeMode() {
      if ((lazyInitBitmap & JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT) == 0) {
            this.jacksonSerializeMode = Objects.requireNonNull(super.jacksonSerializeMode(), "jacksonSerializeMode");
            lazyInitBitmap |= JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT;
          }
        }
      }
      return jacksonSerializeMode;
    }

    private static final long IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT = 0x10000L;

    private boolean isJacksonDeserializedAnnotated;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringPackage#isJacksonDeserializedAnnotated() isJacksonDeserializedAnnotated} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonDeserializedAnnotated() {
      if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT) == 0) {
            this.isJacksonDeserializedAnnotated = super.isJacksonDeserializedAnnotated();
            lazyInitBitmap |= IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonDeserializedAnnotated;
    }

    /**
     * Creates an immutable copy of a {@link Proto.DeclaringPackage} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable DeclaringPackage instance
     */
    public static ImmutableProto.DeclaringPackage copyOf(Proto.DeclaringPackage instance) {
      if (instance instanceof ImmutableProto.DeclaringPackage) {
        return (ImmutableProto.DeclaringPackage) instance;
      }
      return ImmutableProto.DeclaringPackage.builder()
          .element(instance.element())
          .interner(instance.interner())
          .environment(instance.environment())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableProto.DeclaringPackage DeclaringPackage}.
     * @return A new DeclaringPackage builder
     */
    public static ImmutableProto.DeclaringPackage.Builder builder() {
      return new ImmutableProto.DeclaringPackage.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableProto.DeclaringPackage DeclaringPackage}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ELEMENT = 0x1L;
      private static final long INIT_BIT_INTERNER = 0x2L;
      private static final long INIT_BIT_ENVIRONMENT = 0x4L;
      private long initBits = 0x7L;

      private @Nullable PackageElement element;
      private @Nullable Proto.Interning interner;
      private @Nullable Proto.Environment environment;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Proto.DeclaringPackage#element() element} attribute.
       * @param element The value for element 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder element(PackageElement element) {
        checkNotIsSet(elementIsSet(), "element");
        this.element = Objects.requireNonNull(element, "element");
        initBits &= ~INIT_BIT_ELEMENT;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.DeclaringPackage#interner() interner} attribute.
       * @param interner The value for interner 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder interner(Proto.Interning interner) {
        checkNotIsSet(internerIsSet(), "interner");
        this.interner = Objects.requireNonNull(interner, "interner");
        initBits &= ~INIT_BIT_INTERNER;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.DeclaringPackage#environment() environment} attribute.
       * @param environment The value for environment 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder environment(Proto.Environment environment) {
        checkNotIsSet(environmentIsSet(), "environment");
        this.environment = Objects.requireNonNull(environment, "environment");
        initBits &= ~INIT_BIT_ENVIRONMENT;
        return this;
      }

      /**
       * Builds a new {@link ImmutableProto.DeclaringPackage DeclaringPackage}.
       * @return An immutable instance of DeclaringPackage
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableProto.DeclaringPackage build() {
        checkRequiredAttributes();
        return new ImmutableProto.DeclaringPackage(element, interner, environment);
      }

      private boolean elementIsSet() {
        return (initBits & INIT_BIT_ELEMENT) == 0;
      }

      private boolean internerIsSet() {
        return (initBits & INIT_BIT_INTERNER) == 0;
      }

      private boolean environmentIsSet() {
        return (initBits & INIT_BIT_ENVIRONMENT) == 0;
      }

      private void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of DeclaringPackage is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() throws IllegalStateException {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if (!elementIsSet()) attributes.add("element");
        if (!internerIsSet()) attributes.add("interner");
        if (!environmentIsSet()) attributes.add("environment");
        return "Cannot build DeclaringPackage, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Proto.Protoclass}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableProto.Protoclass.builder()}.
   */
  @Immutable
  public static final class Protoclass extends Proto.Protoclass {
    private final String name;
    private final Element sourceElement;
    private final Proto.DeclaringPackage packageOf;
    private final Optional<Proto.DeclaringType> declaringType;
    private final Proto.Protoclass.Kind kind;
    private final Visibility visibility;
    private final Element element;
    private final Optional<Proto.DeclaringType> enclosingOf;
    private final Proto.Environment environment;
    private final String simpleName;

    private Protoclass(
        Element sourceElement,
        Proto.DeclaringPackage packageOf,
        Optional<Proto.DeclaringType> declaringType,
        Proto.Protoclass.Kind kind,
        Proto.Environment environment) {
      this.sourceElement = sourceElement;
      this.packageOf = packageOf;
      this.declaringType = declaringType;
      this.kind = kind;
      this.environment = environment;
      this.name = initShim.name();
      this.visibility = initShim.visibility();
      this.element = initShim.element();
      this.enclosingOf = initShim.enclosingOf();
      this.simpleName = initShim.simpleName();
      this.initShim = null;
    }

    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private String name;
      private int nameBuildStage;

      String name() {
        if (nameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (nameBuildStage == STAGE_UNINITIALIZED) {
          nameBuildStage = STAGE_INITIALIZING;
          this.name = Objects.requireNonNull(Protoclass.super.name(), "name");
          nameBuildStage = STAGE_INITIALIZED;
        }
        return this.name;
      }
      private Visibility visibility;
      private int visibilityBuildStage;

      Visibility visibility() {
        if (visibilityBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (visibilityBuildStage == STAGE_UNINITIALIZED) {
          visibilityBuildStage = STAGE_INITIALIZING;
          this.visibility = Objects.requireNonNull(Protoclass.super.visibility(), "visibility");
          visibilityBuildStage = STAGE_INITIALIZED;
        }
        return this.visibility;
      }
      private Element element;
      private int elementBuildStage;

      Element element() {
        if (elementBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (elementBuildStage == STAGE_UNINITIALIZED) {
          elementBuildStage = STAGE_INITIALIZING;
          this.element = Objects.requireNonNull(Protoclass.super.element(), "element");
          elementBuildStage = STAGE_INITIALIZED;
        }
        return this.element;
      }
      private Optional<Proto.DeclaringType> enclosingOf;
      private int enclosingOfBuildStage;

      Optional<Proto.DeclaringType> enclosingOf() {
        if (enclosingOfBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (enclosingOfBuildStage == STAGE_UNINITIALIZED) {
          enclosingOfBuildStage = STAGE_INITIALIZING;
          this.enclosingOf = Objects.requireNonNull(Protoclass.super.enclosingOf(), "enclosingOf");
          enclosingOfBuildStage = STAGE_INITIALIZED;
        }
        return this.enclosingOf;
      }
      private String simpleName;
      private int simpleNameBuildStage;

      String simpleName() {
        if (simpleNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (simpleNameBuildStage == STAGE_UNINITIALIZED) {
          simpleNameBuildStage = STAGE_INITIALIZING;
          this.simpleName = Objects.requireNonNull(Protoclass.super.simpleName(), "simpleName");
          simpleNameBuildStage = STAGE_INITIALIZED;
        }
        return this.simpleName;
      }

      private String formatInitCycleMessage() {
        ArrayList<String> attributes = Lists.newArrayList();
        if (nameBuildStage == STAGE_INITIALIZING) attributes.add("name");
        if (visibilityBuildStage == STAGE_INITIALIZING) attributes.add("visibility");
        if (elementBuildStage == STAGE_INITIALIZING) attributes.add("element");
        if (enclosingOfBuildStage == STAGE_INITIALIZING) attributes.add("enclosingOf");
        if (simpleNameBuildStage == STAGE_INITIALIZING) attributes.add("simpleName");
        return "Cannot build Protoclass, attribute initializers form cycle" + attributes;
      }
    }

    /**
     * @return The computed-at-construction value of the {@code name} attribute
     */
    @Override
    public String name() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.name()
          : this.name;
    }

    /**
     * Source type elements stores type element which is used as a source of value type model.
     * It is the annotated class for {@code @Value.Immutable} or type referenced in
     * {@code @Value.Include}.
     * @return source element
     */
    @Override
    public Element sourceElement() {
      return sourceElement;
    }

    /**
     * Declaring package that defines value type (usually by import).
     * Or the package in which {@link #declaringType()} resides.
     * @return declaring package
     */
    @Override
    public Proto.DeclaringPackage packageOf() {
      return packageOf;
    }

    /**
     * The class, which is annotated to be a {@code @Value.Immutable}, {@code @Value.Include} or
     * {@code @Value.Enclosing}.
     * @return declaring type
     */
    @Override
    public Optional<Proto.DeclaringType> declaringType() {
      return declaringType;
    }

    /**
     * Kind of protoclass declaration, it specifies how exactly the protoclass was declared.
     * @return definition kind
     */
    @Override
    public Proto.Protoclass.Kind kind() {
      return kind;
    }

    /**
     * @return The computed-at-construction value of the {@code visibility} attribute
     */
    @Override
    public Visibility visibility() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.visibility()
          : this.visibility;
    }

    /**
     * Element used mostly for error reporting,
     * real model provided by {@link #sourceElement()}.
     */
    @Override
    public Element element() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.element()
          : this.element;
    }

    /**
     * @return The computed-at-construction value of the {@code enclosingOf} attribute
     */
    @Override
    public Optional<Proto.DeclaringType> enclosingOf() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.enclosingOf()
          : this.enclosingOf;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @Override
    Proto.Environment environment() {
      return environment;
    }

    /**
     * @return The computed-at-construction value of the {@code simpleName} attribute
     */
    @Override
    public String simpleName() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.simpleName()
          : this.simpleName;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.Protoclass#sourceElement() sourceElement} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for sourceElement
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.Protoclass withSourceElement(Element value) {
      if (this.sourceElement == value) return this;
      Element newValue = Objects.requireNonNull(value, "sourceElement");
      return new ImmutableProto.Protoclass(newValue, this.packageOf, this.declaringType, this.kind, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.Protoclass#packageOf() packageOf} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for packageOf
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.Protoclass withPackageOf(Proto.DeclaringPackage value) {
      if (this.packageOf == value) return this;
      Proto.DeclaringPackage newValue = Objects.requireNonNull(value, "packageOf");
      return new ImmutableProto.Protoclass(this.sourceElement, newValue, this.declaringType, this.kind, this.environment);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Proto.Protoclass#declaringType() declaringType} attribute.
     * @param value The value for declaringType
     * @return A modified copy of {@code this} object
     */
    public final ImmutableProto.Protoclass withDeclaringType(Proto.DeclaringType value) {
      Optional<Proto.DeclaringType> newValue = Optional.of(value);
      if (this.declaringType.isPresent() && this.declaringType.get() == value) return this;
      return new ImmutableProto.Protoclass(this.sourceElement, this.packageOf, newValue, this.kind, this.environment);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Proto.Protoclass#declaringType() declaringType} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for declaringType
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableProto.Protoclass withDeclaringType(Optional<? extends Proto.DeclaringType> optional) {
      Optional<Proto.DeclaringType> value = (Optional<Proto.DeclaringType>) optional;
      if (!this.declaringType.isPresent() && !value.isPresent()) return this;
      if (this.declaringType.isPresent() && value.isPresent() && this.declaringType.get() == value.get()) return this;
      return new ImmutableProto.Protoclass(this.sourceElement, this.packageOf, value, this.kind, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.Protoclass#kind() kind} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for kind
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.Protoclass withKind(Proto.Protoclass.Kind value) {
      if (this.kind == value) return this;
      Proto.Protoclass.Kind newValue = Objects.requireNonNull(value, "kind");
      return new ImmutableProto.Protoclass(this.sourceElement, this.packageOf, this.declaringType, newValue, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.Protoclass#environment() environment} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.Protoclass withEnvironment(Proto.Environment value) {
      if (this.environment == value) return this;
      Proto.Environment newValue = Objects.requireNonNull(value, "environment");
      return new ImmutableProto.Protoclass(this.sourceElement, this.packageOf, this.declaringType, this.kind, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Protoclass} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableProto.Protoclass
          && equalTo((ImmutableProto.Protoclass) another);
    }

    private boolean equalTo(ImmutableProto.Protoclass another) {
      return name.equals(another.name)
          && packageOf.equals(another.packageOf)
          && declaringType.equals(another.declaringType)
          && kind.equals(another.kind)
          && visibility.equals(another.visibility);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code packageOf}, {@code declaringType}, {@code kind}, {@code visibility}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + packageOf.hashCode();
      h += (h << 5) + declaringType.hashCode();
      h += (h << 5) + kind.hashCode();
      h += (h << 5) + visibility.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Protoclass} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Protoclass")
          .omitNullValues()
          .add("name", name)
          .add("packageOf", packageOf)
          .add("declaringType", declaringType.orNull())
          .add("kind", kind)
          .add("visibility", visibility)
          .toString();
    }

    private volatile long lazyInitBitmap;

    private static final long REPOSITORY_LAZY_INIT_BIT = 0x1L;

    private Optional<RepositoryMirror> repository;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#repository() repository} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<RepositoryMirror> repository() {
      if ((lazyInitBitmap & REPOSITORY_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & REPOSITORY_LAZY_INIT_BIT) == 0) {
            this.repository = Objects.requireNonNull(super.repository(), "repository");
            lazyInitBitmap |= REPOSITORY_LAZY_INIT_BIT;
          }
        }
      }
      return repository;
    }

    private static final long GSON_TYPE_ADAPTERS_LAZY_INIT_BIT = 0x2L;

    private Optional<TypeAdaptersMirror> gsonTypeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#gsonTypeAdapters() gsonTypeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<TypeAdaptersMirror> gsonTypeAdapters() {
      if ((lazyInitBitmap & GSON_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & GSON_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.gsonTypeAdapters = Objects.requireNonNull(super.gsonTypeAdapters(), "gsonTypeAdapters");
            lazyInitBitmap |= GSON_TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return gsonTypeAdapters;
    }

    private static final long TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT = 0x4L;

    private Optional<Proto.AbstractDeclaring> typeAdaptersProvider;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#typeAdaptersProvider() typeAdaptersProvider} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Proto.AbstractDeclaring> typeAdaptersProvider() {
      if ((lazyInitBitmap & TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT) == 0) {
            this.typeAdaptersProvider = Objects.requireNonNull(super.typeAdaptersProvider(), "typeAdaptersProvider");
            lazyInitBitmap |= TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT;
          }
        }
      }
      return typeAdaptersProvider;
    }

    private static final long OK_JSON_TYPE_ADAPTERS_LAZY_INIT_BIT = 0x8L;

    private Optional<OkTypeAdaptersMirror> okJsonTypeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#okJsonTypeAdapters() okJsonTypeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<OkTypeAdaptersMirror> okJsonTypeAdapters() {
      if ((lazyInitBitmap & OK_JSON_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & OK_JSON_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.okJsonTypeAdapters = Objects.requireNonNull(super.okJsonTypeAdapters(), "okJsonTypeAdapters");
            lazyInitBitmap |= OK_JSON_TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return okJsonTypeAdapters;
    }

    private static final long OK_TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT = 0x10L;

    private Optional<Proto.AbstractDeclaring> okTypeAdaptersProvider;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#okTypeAdaptersProvider() okTypeAdaptersProvider} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Proto.AbstractDeclaring> okTypeAdaptersProvider() {
      if ((lazyInitBitmap & OK_TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & OK_TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT) == 0) {
            this.okTypeAdaptersProvider = Objects.requireNonNull(super.okTypeAdaptersProvider(), "okTypeAdaptersProvider");
            lazyInitBitmap |= OK_TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT;
          }
        }
      }
      return okTypeAdaptersProvider;
    }

    private static final long SERIAL_VERSION_LAZY_INIT_BIT = 0x20L;

    private Optional<Long> serialVersion;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#serialVersion() serialVersion} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Long> serialVersion() {
      if ((lazyInitBitmap & SERIAL_VERSION_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & SERIAL_VERSION_LAZY_INIT_BIT) == 0) {
            this.serialVersion = Objects.requireNonNull(super.serialVersion(), "serialVersion");
            lazyInitBitmap |= SERIAL_VERSION_LAZY_INIT_BIT;
          }
        }
      }
      return serialVersion;
    }

    private static final long IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT = 0x40L;

    private boolean isSerialStructural;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#isSerialStructural() isSerialStructural} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isSerialStructural() {
      if ((lazyInitBitmap & IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT) == 0) {
            this.isSerialStructural = super.isSerialStructural();
            lazyInitBitmap |= IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT;
          }
        }
      }
      return isSerialStructural;
    }

    private static final long IS_JACKSON_SERIALIZED_LAZY_INIT_BIT = 0x80L;

    private boolean isJacksonSerialized;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#isJacksonSerialized() isJacksonSerialized} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonSerialized() {
      if ((lazyInitBitmap & IS_JACKSON_SERIALIZED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_SERIALIZED_LAZY_INIT_BIT) == 0) {
            this.isJacksonSerialized = super.isJacksonSerialized();
            lazyInitBitmap |= IS_JACKSON_SERIALIZED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonSerialized;
    }

    private static final long IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT = 0x100L;

    private boolean isJacksonDeserialized;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#isJacksonDeserialized() isJacksonDeserialized} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonDeserialized() {
      if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT) == 0) {
            this.isJacksonDeserialized = super.isJacksonDeserialized();
            lazyInitBitmap |= IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonDeserialized;
    }

    private static final long FEATURES_LAZY_INIT_BIT = 0x200L;

    private ValueImmutableInfo features;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#features() features} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public ValueImmutableInfo features() {
      if ((lazyInitBitmap & FEATURES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & FEATURES_LAZY_INIT_BIT) == 0) {
            this.features = Objects.requireNonNull(super.features(), "features");
            lazyInitBitmap |= FEATURES_LAZY_INIT_BIT;
          }
        }
      }
      return features;
    }

    private static final long STYLES_LAZY_INIT_BIT = 0x400L;

    private Styles styles;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#styles() styles} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Styles styles() {
      if ((lazyInitBitmap & STYLES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & STYLES_LAZY_INIT_BIT) == 0) {
            this.styles = Objects.requireNonNull(super.styles(), "styles");
            lazyInitBitmap |= STYLES_LAZY_INIT_BIT;
          }
        }
      }
      return styles;
    }

    private static final long DEPLURALIZE_LAZY_INIT_BIT = 0x800L;

    private Optional<String[]> depluralize;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#depluralize() depluralize} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<String[]> depluralize() {
      if ((lazyInitBitmap & DEPLURALIZE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & DEPLURALIZE_LAZY_INIT_BIT) == 0) {
            this.depluralize = Objects.requireNonNull(super.depluralize(), "depluralize");
            lazyInitBitmap |= DEPLURALIZE_LAZY_INIT_BIT;
          }
        }
      }
      return depluralize;
    }

    private static final long IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT = 0x1000L;

    private boolean isJacksonJsonTypeInfo;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#isJacksonJsonTypeInfo() isJacksonJsonTypeInfo} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonJsonTypeInfo() {
      if ((lazyInitBitmap & IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT) == 0) {
            this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
            lazyInitBitmap |= IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonJsonTypeInfo;
    }

    private static final long CONSTITUTION_LAZY_INIT_BIT = 0x2000L;

    private Constitution constitution;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#constitution() constitution} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Constitution constitution() {
      if ((lazyInitBitmap & CONSTITUTION_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & CONSTITUTION_LAZY_INIT_BIT) == 0) {
            this.constitution = Objects.requireNonNull(super.constitution(), "constitution");
            lazyInitBitmap |= CONSTITUTION_LAZY_INIT_BIT;
          }
        }
      }
      return constitution;
    }

    private static final long ENCODING_INSTANTIATOR_LAZY_INIT_BIT = 0x4000L;

    private Instantiator encodingInstantiator;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Protoclass#encodingInstantiator() encodingInstantiator} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Instantiator encodingInstantiator() {
      if ((lazyInitBitmap & ENCODING_INSTANTIATOR_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & ENCODING_INSTANTIATOR_LAZY_INIT_BIT) == 0) {
            this.encodingInstantiator = Objects.requireNonNull(super.encodingInstantiator(), "encodingInstantiator");
            lazyInitBitmap |= ENCODING_INSTANTIATOR_LAZY_INIT_BIT;
          }
        }
      }
      return encodingInstantiator;
    }

    /**
     * Creates an immutable copy of a {@link Proto.Protoclass} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Protoclass instance
     */
    public static ImmutableProto.Protoclass copyOf(Proto.Protoclass instance) {
      if (instance instanceof ImmutableProto.Protoclass) {
        return (ImmutableProto.Protoclass) instance;
      }
      return ImmutableProto.Protoclass.builder()
          .sourceElement(instance.sourceElement())
          .packageOf(instance.packageOf())
          .declaringType(instance.declaringType())
          .kind(instance.kind())
          .environment(instance.environment())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableProto.Protoclass Protoclass}.
     * @return A new Protoclass builder
     */
    public static ImmutableProto.Protoclass.Builder builder() {
      return new ImmutableProto.Protoclass.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableProto.Protoclass Protoclass}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_SOURCE_ELEMENT = 0x1L;
      private static final long INIT_BIT_PACKAGE_OF = 0x2L;
      private static final long INIT_BIT_KIND = 0x4L;
      private static final long INIT_BIT_ENVIRONMENT = 0x8L;
      private static final long OPT_BIT_DECLARING_TYPE = 0x1L;
      private long initBits = 0xfL;
      private long optBits;

      private @Nullable Element sourceElement;
      private @Nullable Proto.DeclaringPackage packageOf;
      private Optional<Proto.DeclaringType> declaringType = Optional.absent();
      private @Nullable Proto.Protoclass.Kind kind;
      private @Nullable Proto.Environment environment;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Proto.Protoclass#sourceElement() sourceElement} attribute.
       * @param sourceElement The value for sourceElement 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder sourceElement(Element sourceElement) {
        checkNotIsSet(sourceElementIsSet(), "sourceElement");
        this.sourceElement = Objects.requireNonNull(sourceElement, "sourceElement");
        initBits &= ~INIT_BIT_SOURCE_ELEMENT;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.Protoclass#packageOf() packageOf} attribute.
       * @param packageOf The value for packageOf 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder packageOf(Proto.DeclaringPackage packageOf) {
        checkNotIsSet(packageOfIsSet(), "packageOf");
        this.packageOf = Objects.requireNonNull(packageOf, "packageOf");
        initBits &= ~INIT_BIT_PACKAGE_OF;
        return this;
      }

      /**
       * Initializes the optional value {@link Proto.Protoclass#declaringType() declaringType} to declaringType.
       * @param declaringType The value for declaringType
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaringType(Proto.DeclaringType declaringType) {
        checkNotIsSet(declaringTypeIsSet(), "declaringType");
        this.declaringType = Optional.of(declaringType);
        optBits |= OPT_BIT_DECLARING_TYPE;
        return this;
      }

      /**
       * Initializes the optional value {@link Proto.Protoclass#declaringType() declaringType} to declaringType.
       * @param declaringType The value for declaringType
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder declaringType(Optional<? extends Proto.DeclaringType> declaringType) {
        checkNotIsSet(declaringTypeIsSet(), "declaringType");
        this.declaringType = (Optional<Proto.DeclaringType>) declaringType;
        optBits |= OPT_BIT_DECLARING_TYPE;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.Protoclass#kind() kind} attribute.
       * @param kind The value for kind 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder kind(Proto.Protoclass.Kind kind) {
        checkNotIsSet(kindIsSet(), "kind");
        this.kind = Objects.requireNonNull(kind, "kind");
        initBits &= ~INIT_BIT_KIND;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.Protoclass#environment() environment} attribute.
       * @param environment The value for environment 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder environment(Proto.Environment environment) {
        checkNotIsSet(environmentIsSet(), "environment");
        this.environment = Objects.requireNonNull(environment, "environment");
        initBits &= ~INIT_BIT_ENVIRONMENT;
        return this;
      }

      /**
       * Builds a new {@link ImmutableProto.Protoclass Protoclass}.
       * @return An immutable instance of Protoclass
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableProto.Protoclass build() {
        checkRequiredAttributes();
        return new ImmutableProto.Protoclass(sourceElement, packageOf, declaringType, kind, environment);
      }

      private boolean declaringTypeIsSet() {
        return (optBits & OPT_BIT_DECLARING_TYPE) != 0;
      }

      private boolean sourceElementIsSet() {
        return (initBits & INIT_BIT_SOURCE_ELEMENT) == 0;
      }

      private boolean packageOfIsSet() {
        return (initBits & INIT_BIT_PACKAGE_OF) == 0;
      }

      private boolean kindIsSet() {
        return (initBits & INIT_BIT_KIND) == 0;
      }

      private boolean environmentIsSet() {
        return (initBits & INIT_BIT_ENVIRONMENT) == 0;
      }

      private void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of Protoclass is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() throws IllegalStateException {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if (!sourceElementIsSet()) attributes.add("sourceElement");
        if (!packageOfIsSet()) attributes.add("packageOf");
        if (!kindIsSet()) attributes.add("kind");
        if (!environmentIsSet()) attributes.add("environment");
        return "Cannot build Protoclass, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Proto.DeclaringType}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableProto.DeclaringType.builder()}.
   */
  @Immutable
  public static final class DeclaringType extends Proto.DeclaringType {
    private final TypeElement element;
    private final String name;
    private final Proto.DeclaringPackage packageOf;
    private final boolean isTopLevel;
    private final Proto.Interning interner;
    private final Proto.Environment environment;
    private final String simpleName;

    private DeclaringType(
        TypeElement element,
        Proto.Interning interner,
        Proto.Environment environment) {
      this.element = element;
      this.interner = interner;
      this.environment = environment;
      this.name = initShim.name();
      this.packageOf = initShim.packageOf();
      this.isTopLevel = initShim.isTopLevel();
      this.simpleName = initShim.simpleName();
      this.initShim = null;
    }

    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private String name;
      private int nameBuildStage;

      String name() {
        if (nameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (nameBuildStage == STAGE_UNINITIALIZED) {
          nameBuildStage = STAGE_INITIALIZING;
          this.name = Objects.requireNonNull(DeclaringType.super.name(), "name");
          nameBuildStage = STAGE_INITIALIZED;
        }
        return this.name;
      }
      private Proto.DeclaringPackage packageOf;
      private int packageOfBuildStage;

      Proto.DeclaringPackage packageOf() {
        if (packageOfBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (packageOfBuildStage == STAGE_UNINITIALIZED) {
          packageOfBuildStage = STAGE_INITIALIZING;
          this.packageOf = Objects.requireNonNull(DeclaringType.super.packageOf(), "packageOf");
          packageOfBuildStage = STAGE_INITIALIZED;
        }
        return this.packageOf;
      }
      private boolean isTopLevel;
      private int isTopLevelBuildStage;

      boolean isTopLevel() {
        if (isTopLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isTopLevelBuildStage == STAGE_UNINITIALIZED) {
          isTopLevelBuildStage = STAGE_INITIALIZING;
          this.isTopLevel = DeclaringType.super.isTopLevel();
          isTopLevelBuildStage = STAGE_INITIALIZED;
        }
        return this.isTopLevel;
      }
      private String simpleName;
      private int simpleNameBuildStage;

      String simpleName() {
        if (simpleNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (simpleNameBuildStage == STAGE_UNINITIALIZED) {
          simpleNameBuildStage = STAGE_INITIALIZING;
          this.simpleName = Objects.requireNonNull(DeclaringType.super.simpleName(), "simpleName");
          simpleNameBuildStage = STAGE_INITIALIZED;
        }
        return this.simpleName;
      }

      private String formatInitCycleMessage() {
        ArrayList<String> attributes = Lists.newArrayList();
        if (nameBuildStage == STAGE_INITIALIZING) attributes.add("name");
        if (packageOfBuildStage == STAGE_INITIALIZING) attributes.add("packageOf");
        if (isTopLevelBuildStage == STAGE_INITIALIZING) attributes.add("isTopLevel");
        if (simpleNameBuildStage == STAGE_INITIALIZING) attributes.add("simpleName");
        return "Cannot build DeclaringType, attribute initializers form cycle" + attributes;
      }
    }

    /**
     * @return The value of the {@code element} attribute
     */
    @Override
    public TypeElement element() {
      return element;
    }

    /**
     * @return The computed-at-construction value of the {@code name} attribute
     */
    @Override
    public String name() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.name()
          : this.name;
    }

    /**
     * @return The computed-at-construction value of the {@code packageOf} attribute
     */
    @Override
    public Proto.DeclaringPackage packageOf() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.packageOf()
          : this.packageOf;
    }

    /**
     * @return true, if is top level
     */
    @Override
    public boolean isTopLevel() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isTopLevel()
          : this.isTopLevel;
    }

    /**
     * used to intern packaged created internally
     */
    @Override
    Proto.Interning interner() {
      return interner;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @Override
    Proto.Environment environment() {
      return environment;
    }

    /**
     * @return The computed-at-construction value of the {@code simpleName} attribute
     */
    @Override
    public String simpleName() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.simpleName()
          : this.simpleName;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.DeclaringType#element() element} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for element
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.DeclaringType withElement(TypeElement value) {
      if (this.element == value) return this;
      TypeElement newValue = Objects.requireNonNull(value, "element");
      return validate(new ImmutableProto.DeclaringType(newValue, this.interner, this.environment));
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.DeclaringType#interner() interner} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for interner
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.DeclaringType withInterner(Proto.Interning value) {
      if (this.interner == value) return this;
      Proto.Interning newValue = Objects.requireNonNull(value, "interner");
      return validate(new ImmutableProto.DeclaringType(this.element, newValue, this.environment));
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.DeclaringType#environment() environment} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.DeclaringType withEnvironment(Proto.Environment value) {
      if (this.environment == value) return this;
      Proto.Environment newValue = Objects.requireNonNull(value, "environment");
      return validate(new ImmutableProto.DeclaringType(this.element, this.interner, newValue));
    }

    /**
     * This instance is equal to all instances of {@code DeclaringType} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableProto.DeclaringType
          && equalTo((ImmutableProto.DeclaringType) another);
    }

    private boolean equalTo(ImmutableProto.DeclaringType another) {
      return name.equals(another.name);
    }

    /**
     * Computes a hash code from attributes: {@code name}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code DeclaringType} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("DeclaringType")
          .omitNullValues()
          .add("name", name)
          .toString();
    }

    private volatile long lazyInitBitmap;

    private static final long ENCLOSING_TOP_LEVEL_LAZY_INIT_BIT = 0x1L;

    private Optional<Proto.DeclaringType> enclosingTopLevel;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#enclosingTopLevel() enclosingTopLevel} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Proto.DeclaringType> enclosingTopLevel() {
      if ((lazyInitBitmap & ENCLOSING_TOP_LEVEL_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & ENCLOSING_TOP_LEVEL_LAZY_INIT_BIT) == 0) {
            this.enclosingTopLevel = Objects.requireNonNull(super.enclosingTopLevel(), "enclosingTopLevel");
            lazyInitBitmap |= ENCLOSING_TOP_LEVEL_LAZY_INIT_BIT;
          }
        }
      }
      return enclosingTopLevel;
    }

    private static final long REPOSITORY_LAZY_INIT_BIT = 0x2L;

    private Optional<RepositoryMirror> repository;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#repository() repository} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<RepositoryMirror> repository() {
      if ((lazyInitBitmap & REPOSITORY_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & REPOSITORY_LAZY_INIT_BIT) == 0) {
            this.repository = Objects.requireNonNull(super.repository(), "repository");
            lazyInitBitmap |= REPOSITORY_LAZY_INIT_BIT;
          }
        }
      }
      return repository;
    }

    private static final long ENCLOSING_OF_LAZY_INIT_BIT = 0x4L;

    private Optional<Proto.DeclaringType> enclosingOf;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#enclosingOf() enclosingOf} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Proto.DeclaringType> enclosingOf() {
      if ((lazyInitBitmap & ENCLOSING_OF_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & ENCLOSING_OF_LAZY_INIT_BIT) == 0) {
            this.enclosingOf = Objects.requireNonNull(super.enclosingOf(), "enclosingOf");
            lazyInitBitmap |= ENCLOSING_OF_LAZY_INIT_BIT;
          }
        }
      }
      return enclosingOf;
    }

    private static final long FEATURES_LAZY_INIT_BIT = 0x8L;

    private Optional<ValueImmutableInfo> features;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#features() features} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<ValueImmutableInfo> features() {
      if ((lazyInitBitmap & FEATURES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & FEATURES_LAZY_INIT_BIT) == 0) {
            this.features = Objects.requireNonNull(super.features(), "features");
            lazyInitBitmap |= FEATURES_LAZY_INIT_BIT;
          }
        }
      }
      return features;
    }

    private static final long JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT = 0x10L;

    private Proto.JacksonMode jacksonSerializeMode;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#jacksonSerializeMode() jacksonSerializeMode} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Proto.JacksonMode jacksonSerializeMode() {
      if ((lazyInitBitmap & JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT) == 0) {
            this.jacksonSerializeMode = Objects.requireNonNull(super.jacksonSerializeMode(), "jacksonSerializeMode");
            lazyInitBitmap |= JACKSON_SERIALIZE_MODE_LAZY_INIT_BIT;
          }
        }
      }
      return jacksonSerializeMode;
    }

    private static final long USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT = 0x20L;

    private boolean useImmutableDefaults;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#useImmutableDefaults() useImmutableDefaults} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean useImmutableDefaults() {
      if ((lazyInitBitmap & USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT) == 0) {
            this.useImmutableDefaults = super.useImmutableDefaults();
            lazyInitBitmap |= USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT;
          }
        }
      }
      return useImmutableDefaults;
    }

    private static final long IS_ENCLOSING_LAZY_INIT_BIT = 0x40L;

    private boolean isEnclosing;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isEnclosing() isEnclosing} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isEnclosing() {
      if ((lazyInitBitmap & IS_ENCLOSING_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_ENCLOSING_LAZY_INIT_BIT) == 0) {
            this.isEnclosing = super.isEnclosing();
            lazyInitBitmap |= IS_ENCLOSING_LAZY_INIT_BIT;
          }
        }
      }
      return isEnclosing;
    }

    private static final long IS_MODIFIABLE_LAZY_INIT_BIT = 0x80L;

    private boolean isModifiable;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isModifiable() isModifiable} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isModifiable() {
      if ((lazyInitBitmap & IS_MODIFIABLE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_MODIFIABLE_LAZY_INIT_BIT) == 0) {
            this.isModifiable = super.isModifiable();
            lazyInitBitmap |= IS_MODIFIABLE_LAZY_INIT_BIT;
          }
        }
      }
      return isModifiable;
    }

    private static final long SOURCE_CODE_LAZY_INIT_BIT = 0x100L;

    private CharSequence sourceCode;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#sourceCode() sourceCode} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public CharSequence sourceCode() {
      if ((lazyInitBitmap & SOURCE_CODE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & SOURCE_CODE_LAZY_INIT_BIT) == 0) {
            this.sourceCode = Objects.requireNonNull(super.sourceCode(), "sourceCode");
            lazyInitBitmap |= SOURCE_CODE_LAZY_INIT_BIT;
          }
        }
      }
      return sourceCode;
    }

    private static final long HEADER_COMMENTS_LAZY_INIT_BIT = 0x200L;

    private CharSequence headerComments;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#headerComments() headerComments} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public CharSequence headerComments() {
      if ((lazyInitBitmap & HEADER_COMMENTS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HEADER_COMMENTS_LAZY_INIT_BIT) == 0) {
            this.headerComments = Objects.requireNonNull(super.headerComments(), "headerComments");
            lazyInitBitmap |= HEADER_COMMENTS_LAZY_INIT_BIT;
          }
        }
      }
      return headerComments;
    }

    private static final long SOURCE_IMPORTS_LAZY_INIT_BIT = 0x400L;

    private SourceExtraction.Imports sourceImports;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#sourceImports() sourceImports} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public SourceExtraction.Imports sourceImports() {
      if ((lazyInitBitmap & SOURCE_IMPORTS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & SOURCE_IMPORTS_LAZY_INIT_BIT) == 0) {
            this.sourceImports = Objects.requireNonNull(super.sourceImports(), "sourceImports");
            lazyInitBitmap |= SOURCE_IMPORTS_LAZY_INIT_BIT;
          }
        }
      }
      return sourceImports;
    }

    private static final long TRANSFORM_LAZY_INIT_BIT = 0x800L;

    private Optional<TransformMirror> transform;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#getTransform() transform} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<TransformMirror> getTransform() {
      if ((lazyInitBitmap & TRANSFORM_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & TRANSFORM_LAZY_INIT_BIT) == 0) {
            this.transform = Objects.requireNonNull(super.getTransform(), "transform");
            lazyInitBitmap |= TRANSFORM_LAZY_INIT_BIT;
          }
        }
      }
      return transform;
    }

    private static final long TREES_INCLUDE_LAZY_INIT_BIT = 0x1000L;

    private Optional<TreesIncludeMirror> treesInclude;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#getTreesInclude() treesInclude} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<TreesIncludeMirror> getTreesInclude() {
      if ((lazyInitBitmap & TREES_INCLUDE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & TREES_INCLUDE_LAZY_INIT_BIT) == 0) {
            this.treesInclude = Objects.requireNonNull(super.getTreesInclude(), "treesInclude");
            lazyInitBitmap |= TREES_INCLUDE_LAZY_INIT_BIT;
          }
        }
      }
      return treesInclude;
    }

    private static final long VISIT_LAZY_INIT_BIT = 0x2000L;

    private Optional<VisitMirror> visit;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#getVisit() visit} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<VisitMirror> getVisit() {
      if ((lazyInitBitmap & VISIT_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & VISIT_LAZY_INIT_BIT) == 0) {
            this.visit = Objects.requireNonNull(super.getVisit(), "visit");
            lazyInitBitmap |= VISIT_LAZY_INIT_BIT;
          }
        }
      }
      return visit;
    }

    private static final long IS_AST_LAZY_INIT_BIT = 0x4000L;

    private boolean isAst;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isAst() isAst} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isAst() {
      if ((lazyInitBitmap & IS_AST_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_AST_LAZY_INIT_BIT) == 0) {
            this.isAst = super.isAst();
            lazyInitBitmap |= IS_AST_LAZY_INIT_BIT;
          }
        }
      }
      return isAst;
    }

    private static final long INCLUDE_LAZY_INIT_BIT = 0x8000L;

    private Optional<IncludeMirror> include;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#include() include} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<IncludeMirror> include() {
      if ((lazyInitBitmap & INCLUDE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & INCLUDE_LAZY_INIT_BIT) == 0) {
            this.include = Objects.requireNonNull(super.include(), "include");
            lazyInitBitmap |= INCLUDE_LAZY_INIT_BIT;
          }
        }
      }
      return include;
    }

    private static final long BUILDER_INCLUDE_LAZY_INIT_BIT = 0x10000L;

    private Optional<FIncludeMirror> builderInclude;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#builderInclude() builderInclude} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<FIncludeMirror> builderInclude() {
      if ((lazyInitBitmap & BUILDER_INCLUDE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & BUILDER_INCLUDE_LAZY_INIT_BIT) == 0) {
            this.builderInclude = Objects.requireNonNull(super.builderInclude(), "builderInclude");
            lazyInitBitmap |= BUILDER_INCLUDE_LAZY_INIT_BIT;
          }
        }
      }
      return builderInclude;
    }

    private static final long TYPE_ADAPTERS_LAZY_INIT_BIT = 0x20000L;

    private Optional<TypeAdaptersMirror> typeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#typeAdapters() typeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<TypeAdaptersMirror> typeAdapters() {
      if ((lazyInitBitmap & TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.typeAdapters = Objects.requireNonNull(super.typeAdapters(), "typeAdapters");
            lazyInitBitmap |= TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return typeAdapters;
    }

    private static final long OK_TYPE_ADAPTERS_LAZY_INIT_BIT = 0x40000L;

    private Optional<OkTypeAdaptersMirror> okTypeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#okTypeAdapters() okTypeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<OkTypeAdaptersMirror> okTypeAdapters() {
      if ((lazyInitBitmap & OK_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & OK_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.okTypeAdapters = Objects.requireNonNull(super.okTypeAdapters(), "okTypeAdapters");
            lazyInitBitmap |= OK_TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return okTypeAdapters;
    }

    private static final long INCLUDED_TYPES_LAZY_INIT_BIT = 0x80000L;

    private List<TypeElement> includedTypes;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#includedTypes() includedTypes} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public List<TypeElement> includedTypes() {
      if ((lazyInitBitmap & INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
            this.includedTypes = Objects.requireNonNull(super.includedTypes(), "includedTypes");
            lazyInitBitmap |= INCLUDED_TYPES_LAZY_INIT_BIT;
          }
        }
      }
      return includedTypes;
    }

    private static final long BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT = 0x100000L;

    private List<TypeElement> builderIncludedTypes;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#builderIncludedTypes() builderIncludedTypes} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public List<TypeElement> builderIncludedTypes() {
      if ((lazyInitBitmap & BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT) == 0) {
            this.builderIncludedTypes = Objects.requireNonNull(super.builderIncludedTypes(), "builderIncludedTypes");
            lazyInitBitmap |= BUILDER_INCLUDED_TYPES_LAZY_INIT_BIT;
          }
        }
      }
      return builderIncludedTypes;
    }

    private static final long META_ANNOTATED_LAZY_INIT_BIT = 0x200000L;

    private List<Proto.MetaAnnotated> metaAnnotated;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#metaAnnotated() metaAnnotated} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public List<Proto.MetaAnnotated> metaAnnotated() {
      if ((lazyInitBitmap & META_ANNOTATED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & META_ANNOTATED_LAZY_INIT_BIT) == 0) {
            this.metaAnnotated = Objects.requireNonNull(super.metaAnnotated(), "metaAnnotated");
            lazyInitBitmap |= META_ANNOTATED_LAZY_INIT_BIT;
          }
        }
      }
      return metaAnnotated;
    }

    private static final long STYLE_LAZY_INIT_BIT = 0x400000L;

    private Optional<StyleInfo> style;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#style() style} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<StyleInfo> style() {
      if ((lazyInitBitmap & STYLE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & STYLE_LAZY_INIT_BIT) == 0) {
            this.style = Objects.requireNonNull(super.style(), "style");
            lazyInitBitmap |= STYLE_LAZY_INIT_BIT;
          }
        }
      }
      return style;
    }

    private static final long SERIAL_VERSION_LAZY_INIT_BIT = 0x800000L;

    private Optional<Long> serialVersion;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#serialVersion() serialVersion} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<Long> serialVersion() {
      if ((lazyInitBitmap & SERIAL_VERSION_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & SERIAL_VERSION_LAZY_INIT_BIT) == 0) {
            this.serialVersion = Objects.requireNonNull(super.serialVersion(), "serialVersion");
            lazyInitBitmap |= SERIAL_VERSION_LAZY_INIT_BIT;
          }
        }
      }
      return serialVersion;
    }

    private static final long IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT = 0x1000000L;

    private boolean isSerialStructural;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isSerialStructural() isSerialStructural} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isSerialStructural() {
      if ((lazyInitBitmap & IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT) == 0) {
            this.isSerialStructural = super.isSerialStructural();
            lazyInitBitmap |= IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT;
          }
        }
      }
      return isSerialStructural;
    }

    private static final long IS_JACKSON_SERIALIZED_LAZY_INIT_BIT = 0x2000000L;

    private boolean isJacksonSerialized;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isJacksonSerialized() isJacksonSerialized} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonSerialized() {
      if ((lazyInitBitmap & IS_JACKSON_SERIALIZED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_SERIALIZED_LAZY_INIT_BIT) == 0) {
            this.isJacksonSerialized = super.isJacksonSerialized();
            lazyInitBitmap |= IS_JACKSON_SERIALIZED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonSerialized;
    }

    private static final long IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT = 0x4000000L;

    private boolean isJacksonDeserialized;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isJacksonDeserialized() isJacksonDeserialized} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonDeserialized() {
      if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT) == 0) {
            this.isJacksonDeserialized = super.isJacksonDeserialized();
            lazyInitBitmap |= IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonDeserialized;
    }

    private static final long DEPLURALIZE_LAZY_INIT_BIT = 0x8000000L;

    private Optional<String[]> depluralize;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#depluralize() depluralize} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public Optional<String[]> depluralize() {
      if ((lazyInitBitmap & DEPLURALIZE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & DEPLURALIZE_LAZY_INIT_BIT) == 0) {
            this.depluralize = Objects.requireNonNull(super.depluralize(), "depluralize");
            lazyInitBitmap |= DEPLURALIZE_LAZY_INIT_BIT;
          }
        }
      }
      return depluralize;
    }

    private static final long IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT = 0x10000000L;

    private boolean isJacksonDeserializedAnnotated;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isJacksonDeserializedAnnotated() isJacksonDeserializedAnnotated} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonDeserializedAnnotated() {
      if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT) == 0) {
            this.isJacksonDeserializedAnnotated = super.isJacksonDeserializedAnnotated();
            lazyInitBitmap |= IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonDeserializedAnnotated;
    }

    private static final long IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT = 0x20000000L;

    private boolean isJacksonJsonTypeInfo;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.DeclaringType#isJacksonJsonTypeInfo() isJacksonJsonTypeInfo} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean isJacksonJsonTypeInfo() {
      if ((lazyInitBitmap & IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT) == 0) {
            this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
            lazyInitBitmap |= IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT;
          }
        }
      }
      return isJacksonJsonTypeInfo;
    }


    private static ImmutableProto.DeclaringType validate(ImmutableProto.DeclaringType instance) {
      instance.validate();
      return instance;
    }

    /**
     * Creates an immutable copy of a {@link Proto.DeclaringType} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable DeclaringType instance
     */
    public static ImmutableProto.DeclaringType copyOf(Proto.DeclaringType instance) {
      if (instance instanceof ImmutableProto.DeclaringType) {
        return (ImmutableProto.DeclaringType) instance;
      }
      return ImmutableProto.DeclaringType.builder()
          .element(instance.element())
          .interner(instance.interner())
          .environment(instance.environment())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableProto.DeclaringType DeclaringType}.
     * @return A new DeclaringType builder
     */
    public static ImmutableProto.DeclaringType.Builder builder() {
      return new ImmutableProto.DeclaringType.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableProto.DeclaringType DeclaringType}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ELEMENT = 0x1L;
      private static final long INIT_BIT_INTERNER = 0x2L;
      private static final long INIT_BIT_ENVIRONMENT = 0x4L;
      private long initBits = 0x7L;

      private @Nullable TypeElement element;
      private @Nullable Proto.Interning interner;
      private @Nullable Proto.Environment environment;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Proto.DeclaringType#element() element} attribute.
       * @param element The value for element 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder element(TypeElement element) {
        checkNotIsSet(elementIsSet(), "element");
        this.element = Objects.requireNonNull(element, "element");
        initBits &= ~INIT_BIT_ELEMENT;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.DeclaringType#interner() interner} attribute.
       * @param interner The value for interner 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder interner(Proto.Interning interner) {
        checkNotIsSet(internerIsSet(), "interner");
        this.interner = Objects.requireNonNull(interner, "interner");
        initBits &= ~INIT_BIT_INTERNER;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.DeclaringType#environment() environment} attribute.
       * @param environment The value for environment 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder environment(Proto.Environment environment) {
        checkNotIsSet(environmentIsSet(), "environment");
        this.environment = Objects.requireNonNull(environment, "environment");
        initBits &= ~INIT_BIT_ENVIRONMENT;
        return this;
      }

      /**
       * Builds a new {@link ImmutableProto.DeclaringType DeclaringType}.
       * @return An immutable instance of DeclaringType
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableProto.DeclaringType build() {
        checkRequiredAttributes();
        return ImmutableProto.DeclaringType.validate(new ImmutableProto.DeclaringType(element, interner, environment));
      }

      private boolean elementIsSet() {
        return (initBits & INIT_BIT_ELEMENT) == 0;
      }

      private boolean internerIsSet() {
        return (initBits & INIT_BIT_INTERNER) == 0;
      }

      private boolean environmentIsSet() {
        return (initBits & INIT_BIT_ENVIRONMENT) == 0;
      }

      private void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of DeclaringType is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() throws IllegalStateException {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if (!elementIsSet()) attributes.add("element");
        if (!internerIsSet()) attributes.add("interner");
        if (!environmentIsSet()) attributes.add("environment");
        return "Cannot build DeclaringType, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Proto.Environment}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableProto.Environment.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableProto.Environment.of()}.
   */
  @Immutable
  public static final class Environment extends Proto.Environment {
    private final ProcessingEnvironment processing;
    private final Round round;
    private final StyleInfo defaultStyles;

    private Environment(
        ProcessingEnvironment processing,
        Round round) {
      this.processing = Objects.requireNonNull(processing, "processing");
      this.round = Objects.requireNonNull(round, "round");
      this.defaultStyles = Objects.requireNonNull(super.defaultStyles(), "defaultStyles");
    }

    private Environment(
        Environment original,
        ProcessingEnvironment processing,
        Round round) {
      this.processing = processing;
      this.round = round;
      this.defaultStyles = Objects.requireNonNull(super.defaultStyles(), "defaultStyles");
    }

    /**
     * @return The value of the {@code processing} attribute
     */
    @Override
    ProcessingEnvironment processing() {
      return processing;
    }

    /**
     * @return The value of the {@code round} attribute
     */
    @Override
    Round round() {
      return round;
    }

    /**
     * @return The computed-at-construction value of the {@code defaultStyles} attribute
     */
    @Override
    StyleInfo defaultStyles() {
      return defaultStyles;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.Environment#processing() processing} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for processing
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.Environment withProcessing(ProcessingEnvironment value) {
      if (this.processing == value) return this;
      ProcessingEnvironment newValue = Objects.requireNonNull(value, "processing");
      return new ImmutableProto.Environment(this, newValue, this.round);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.Environment#round() round} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for round
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.Environment withRound(Round value) {
      if (this.round == value) return this;
      Round newValue = Objects.requireNonNull(value, "round");
      return new ImmutableProto.Environment(this, this.processing, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Environment} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableProto.Environment
          && equalTo((ImmutableProto.Environment) another);
    }

    private boolean equalTo(ImmutableProto.Environment another) {
      return processing.equals(another.processing)
          && round.equals(another.round)
          && defaultStyles.equals(another.defaultStyles);
    }

    /**
     * Computes a hash code from attributes: {@code processing}, {@code round}, {@code defaultStyles}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + processing.hashCode();
      h += (h << 5) + round.hashCode();
      h += (h << 5) + defaultStyles.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Environment} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Environment")
          .omitNullValues()
          .add("processing", processing)
          .add("round", round)
          .add("defaultStyles", defaultStyles)
          .toString();
    }

    private volatile long lazyInitBitmap;

    private static final long TYPE_MORE_OBJECTS_LAZY_INIT_BIT = 0x1L;

    private String typeMoreObjects;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#typeMoreObjects() typeMoreObjects} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public String typeMoreObjects() {
      if ((lazyInitBitmap & TYPE_MORE_OBJECTS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & TYPE_MORE_OBJECTS_LAZY_INIT_BIT) == 0) {
            this.typeMoreObjects = super.typeMoreObjects();
            lazyInitBitmap |= TYPE_MORE_OBJECTS_LAZY_INIT_BIT;
          }
        }
      }
      return typeMoreObjects;
    }

    private static final long HAS_OK_JSON_LIB_LAZY_INIT_BIT = 0x2L;

    private boolean hasOkJsonLib;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasOkJsonLib() hasOkJsonLib} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasOkJsonLib() {
      if ((lazyInitBitmap & HAS_OK_JSON_LIB_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_OK_JSON_LIB_LAZY_INIT_BIT) == 0) {
            this.hasOkJsonLib = super.hasOkJsonLib();
            lazyInitBitmap |= HAS_OK_JSON_LIB_LAZY_INIT_BIT;
          }
        }
      }
      return hasOkJsonLib;
    }

    private static final long HAS_GSON_LIB_LAZY_INIT_BIT = 0x4L;

    private boolean hasGsonLib;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasGsonLib() hasGsonLib} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasGsonLib() {
      if ((lazyInitBitmap & HAS_GSON_LIB_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_GSON_LIB_LAZY_INIT_BIT) == 0) {
            this.hasGsonLib = super.hasGsonLib();
            lazyInitBitmap |= HAS_GSON_LIB_LAZY_INIT_BIT;
          }
        }
      }
      return hasGsonLib;
    }

    private static final long HAS_JACKSON_LIB_LAZY_INIT_BIT = 0x8L;

    private boolean hasJacksonLib;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasJacksonLib() hasJacksonLib} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasJacksonLib() {
      if ((lazyInitBitmap & HAS_JACKSON_LIB_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_JACKSON_LIB_LAZY_INIT_BIT) == 0) {
            this.hasJacksonLib = super.hasJacksonLib();
            lazyInitBitmap |= HAS_JACKSON_LIB_LAZY_INIT_BIT;
          }
        }
      }
      return hasJacksonLib;
    }

    private static final long HAS_MONGO_MODULE_LAZY_INIT_BIT = 0x10L;

    private boolean hasMongoModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasMongoModule() hasMongoModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasMongoModule() {
      if ((lazyInitBitmap & HAS_MONGO_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_MONGO_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasMongoModule = super.hasMongoModule();
            lazyInitBitmap |= HAS_MONGO_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasMongoModule;
    }

    private static final long HAS_SERIAL_MODULE_LAZY_INIT_BIT = 0x20L;

    private boolean hasSerialModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasSerialModule() hasSerialModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasSerialModule() {
      if ((lazyInitBitmap & HAS_SERIAL_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_SERIAL_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasSerialModule = super.hasSerialModule();
            lazyInitBitmap |= HAS_SERIAL_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasSerialModule;
    }

    private static final long HAS_TREES_MODULE_LAZY_INIT_BIT = 0x40L;

    private boolean hasTreesModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasTreesModule() hasTreesModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasTreesModule() {
      if ((lazyInitBitmap & HAS_TREES_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_TREES_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasTreesModule = super.hasTreesModule();
            lazyInitBitmap |= HAS_TREES_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasTreesModule;
    }

    private static final long HAS_AST_MODULE_LAZY_INIT_BIT = 0x80L;

    private boolean hasAstModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasAstModule() hasAstModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasAstModule() {
      if ((lazyInitBitmap & HAS_AST_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_AST_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasAstModule = super.hasAstModule();
            lazyInitBitmap |= HAS_AST_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasAstModule;
    }

    private static final long HAS_ORDINAL_MODULE_LAZY_INIT_BIT = 0x100L;

    private boolean hasOrdinalModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasOrdinalModule() hasOrdinalModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasOrdinalModule() {
      if ((lazyInitBitmap & HAS_ORDINAL_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_ORDINAL_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasOrdinalModule = super.hasOrdinalModule();
            lazyInitBitmap |= HAS_ORDINAL_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasOrdinalModule;
    }

    private static final long HAS_BUILDER_MODULE_LAZY_INIT_BIT = 0x200L;

    private boolean hasBuilderModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasBuilderModule() hasBuilderModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasBuilderModule() {
      if ((lazyInitBitmap & HAS_BUILDER_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_BUILDER_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasBuilderModule = super.hasBuilderModule();
            lazyInitBitmap |= HAS_BUILDER_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasBuilderModule;
    }

    private static final long HAS_FUNC_MODULE_LAZY_INIT_BIT = 0x400L;

    private boolean hasFuncModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasFuncModule() hasFuncModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasFuncModule() {
      if ((lazyInitBitmap & HAS_FUNC_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_FUNC_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasFuncModule = super.hasFuncModule();
            lazyInitBitmap |= HAS_FUNC_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasFuncModule;
    }

    private static final long HAS_ENCODE_MODULE_LAZY_INIT_BIT = 0x800L;

    private boolean hasEncodeModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasEncodeModule() hasEncodeModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasEncodeModule() {
      if ((lazyInitBitmap & HAS_ENCODE_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_ENCODE_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasEncodeModule = super.hasEncodeModule();
            lazyInitBitmap |= HAS_ENCODE_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasEncodeModule;
    }

    private static final long HAS_ANNOTATE_MODULE_LAZY_INIT_BIT = 0x1000L;

    private boolean hasAnnotateModule;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#hasAnnotateModule() hasAnnotateModule} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public boolean hasAnnotateModule() {
      if ((lazyInitBitmap & HAS_ANNOTATE_MODULE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & HAS_ANNOTATE_MODULE_LAZY_INIT_BIT) == 0) {
            this.hasAnnotateModule = super.hasAnnotateModule();
            lazyInitBitmap |= HAS_ANNOTATE_MODULE_LAZY_INIT_BIT;
          }
        }
      }
      return hasAnnotateModule;
    }

    private static final long DEFAULT_TYPE_ADAPTERS_LAZY_INIT_BIT = 0x2000L;

    private TypeAdaptersMirror defaultTypeAdapters;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Proto.Environment#defaultTypeAdapters() defaultTypeAdapters} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * @return A lazily initialized value of the {@code l.name} attribute
     */
    @Override
    public TypeAdaptersMirror defaultTypeAdapters() {
      if ((lazyInitBitmap & DEFAULT_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & DEFAULT_TYPE_ADAPTERS_LAZY_INIT_BIT) == 0) {
            this.defaultTypeAdapters = Objects.requireNonNull(super.defaultTypeAdapters(), "defaultTypeAdapters");
            lazyInitBitmap |= DEFAULT_TYPE_ADAPTERS_LAZY_INIT_BIT;
          }
        }
      }
      return defaultTypeAdapters;
    }

    /**
     * Construct a new immutable {@code Environment} instance.
     * @param processing The value for the {@code processing} attribute
     * @param round The value for the {@code round} attribute
     * @return An immutable Environment instance
     */
    public static ImmutableProto.Environment of(ProcessingEnvironment processing, Round round) {
      return new ImmutableProto.Environment(processing, round);
    }

    /**
     * Creates an immutable copy of a {@link Proto.Environment} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Environment instance
     */
    public static ImmutableProto.Environment copyOf(Proto.Environment instance) {
      if (instance instanceof ImmutableProto.Environment) {
        return (ImmutableProto.Environment) instance;
      }
      return ImmutableProto.Environment.builder()
          .processing(instance.processing())
          .round(instance.round())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableProto.Environment Environment}.
     * @return A new Environment builder
     */
    public static ImmutableProto.Environment.Builder builder() {
      return new ImmutableProto.Environment.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableProto.Environment Environment}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_PROCESSING = 0x1L;
      private static final long INIT_BIT_ROUND = 0x2L;
      private long initBits = 0x3L;

      private @Nullable ProcessingEnvironment processing;
      private @Nullable Round round;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Proto.Environment#processing() processing} attribute.
       * @param processing The value for processing 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder processing(ProcessingEnvironment processing) {
        checkNotIsSet(processingIsSet(), "processing");
        this.processing = Objects.requireNonNull(processing, "processing");
        initBits &= ~INIT_BIT_PROCESSING;
        return this;
      }

      /**
       * Initializes the value for the {@link Proto.Environment#round() round} attribute.
       * @param round The value for round 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder round(Round round) {
        checkNotIsSet(roundIsSet(), "round");
        this.round = Objects.requireNonNull(round, "round");
        initBits &= ~INIT_BIT_ROUND;
        return this;
      }

      /**
       * Builds a new {@link ImmutableProto.Environment Environment}.
       * @return An immutable instance of Environment
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableProto.Environment build() {
        checkRequiredAttributes();
        return new ImmutableProto.Environment(null, processing, round);
      }

      private boolean processingIsSet() {
        return (initBits & INIT_BIT_PROCESSING) == 0;
      }

      private boolean roundIsSet() {
        return (initBits & INIT_BIT_ROUND) == 0;
      }

      private void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of Environment is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() throws IllegalStateException {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if (!processingIsSet()) attributes.add("processing");
        if (!roundIsSet()) attributes.add("round");
        return "Cannot build Environment, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Proto.MetaAnnotated}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableProto.MetaAnnotated.of()}.
   */
  @Immutable
  public static final class MetaAnnotated extends Proto.MetaAnnotated {
    private final Element element;
    private final String qualifiedName;
    private final Proto.Environment environment;
    private final Set<EncodingInfo> encodings;
    private final Optional<StyleInfo> style;
    private final Optional<String[]> depluralize;
    private final Optional<Long> serialVersion;
    private final boolean isSerialStructural;
    private final boolean isJacksonSerialized;
    private final boolean isJacksonDeserialized;
    private final boolean isJacksonJsonTypeInfo;
    private final boolean isJsonQualifier;
    private final boolean isEnclosing;
    private final Optional<AnnotationInjections.InjectionInfo> injectAnnotation;

    private MetaAnnotated(
        Element element,
        String qualifiedName,
        Proto.Environment environment) {
      this.element = Objects.requireNonNull(element, "element");
      this.qualifiedName = Objects.requireNonNull(qualifiedName, "qualifiedName");
      this.environment = Objects.requireNonNull(environment, "environment");
      this.encodings = initShim.encodings();
      this.style = initShim.style();
      this.depluralize = initShim.depluralize();
      this.serialVersion = initShim.serialVersion();
      this.isSerialStructural = initShim.isSerialStructural();
      this.isJacksonSerialized = initShim.isJacksonSerialized();
      this.isJacksonDeserialized = initShim.isJacksonDeserialized();
      this.isJacksonJsonTypeInfo = initShim.isJacksonJsonTypeInfo();
      this.isJsonQualifier = initShim.isJsonQualifier();
      this.isEnclosing = initShim.isEnclosing();
      this.injectAnnotation = initShim.injectAnnotation();
      this.initShim = null;
    }

    private MetaAnnotated(
        MetaAnnotated original,
        Element element,
        String qualifiedName,
        Proto.Environment environment) {
      this.element = element;
      this.qualifiedName = qualifiedName;
      this.environment = environment;
      this.encodings = initShim.encodings();
      this.style = initShim.style();
      this.depluralize = initShim.depluralize();
      this.serialVersion = initShim.serialVersion();
      this.isSerialStructural = initShim.isSerialStructural();
      this.isJacksonSerialized = initShim.isJacksonSerialized();
      this.isJacksonDeserialized = initShim.isJacksonDeserialized();
      this.isJacksonJsonTypeInfo = initShim.isJacksonJsonTypeInfo();
      this.isJsonQualifier = initShim.isJsonQualifier();
      this.isEnclosing = initShim.isEnclosing();
      this.injectAnnotation = initShim.injectAnnotation();
      this.initShim = null;
    }

    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private Set<EncodingInfo> encodings;
      private int encodingsBuildStage;

      Set<EncodingInfo> encodings() {
        if (encodingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (encodingsBuildStage == STAGE_UNINITIALIZED) {
          encodingsBuildStage = STAGE_INITIALIZING;
          this.encodings = Objects.requireNonNull(MetaAnnotated.super.encodings(), "encodings");
          encodingsBuildStage = STAGE_INITIALIZED;
        }
        return this.encodings;
      }
      private Optional<StyleInfo> style;
      private int styleBuildStage;

      Optional<StyleInfo> style() {
        if (styleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (styleBuildStage == STAGE_UNINITIALIZED) {
          styleBuildStage = STAGE_INITIALIZING;
          this.style = Objects.requireNonNull(MetaAnnotated.super.style(), "style");
          styleBuildStage = STAGE_INITIALIZED;
        }
        return this.style;
      }
      private Optional<String[]> depluralize;
      private int depluralizeBuildStage;

      Optional<String[]> depluralize() {
        if (depluralizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (depluralizeBuildStage == STAGE_UNINITIALIZED) {
          depluralizeBuildStage = STAGE_INITIALIZING;
          this.depluralize = Objects.requireNonNull(MetaAnnotated.super.depluralize(), "depluralize");
          depluralizeBuildStage = STAGE_INITIALIZED;
        }
        return this.depluralize;
      }
      private Optional<Long> serialVersion;
      private int serialVersionBuildStage;

      Optional<Long> serialVersion() {
        if (serialVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (serialVersionBuildStage == STAGE_UNINITIALIZED) {
          serialVersionBuildStage = STAGE_INITIALIZING;
          this.serialVersion = Objects.requireNonNull(MetaAnnotated.super.serialVersion(), "serialVersion");
          serialVersionBuildStage = STAGE_INITIALIZED;
        }
        return this.serialVersion;
      }
      private boolean isSerialStructural;
      private int isSerialStructuralBuildStage;

      boolean isSerialStructural() {
        if (isSerialStructuralBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isSerialStructuralBuildStage == STAGE_UNINITIALIZED) {
          isSerialStructuralBuildStage = STAGE_INITIALIZING;
          this.isSerialStructural = MetaAnnotated.super.isSerialStructural();
          isSerialStructuralBuildStage = STAGE_INITIALIZED;
        }
        return this.isSerialStructural;
      }
      private boolean isJacksonSerialized;
      private int isJacksonSerializedBuildStage;

      boolean isJacksonSerialized() {
        if (isJacksonSerializedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isJacksonSerializedBuildStage == STAGE_UNINITIALIZED) {
          isJacksonSerializedBuildStage = STAGE_INITIALIZING;
          this.isJacksonSerialized = MetaAnnotated.super.isJacksonSerialized();
          isJacksonSerializedBuildStage = STAGE_INITIALIZED;
        }
        return this.isJacksonSerialized;
      }
      private boolean isJacksonDeserialized;
      private int isJacksonDeserializedBuildStage;

      boolean isJacksonDeserialized() {
        if (isJacksonDeserializedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isJacksonDeserializedBuildStage == STAGE_UNINITIALIZED) {
          isJacksonDeserializedBuildStage = STAGE_INITIALIZING;
          this.isJacksonDeserialized = MetaAnnotated.super.isJacksonDeserialized();
          isJacksonDeserializedBuildStage = STAGE_INITIALIZED;
        }
        return this.isJacksonDeserialized;
      }
      private boolean isJacksonJsonTypeInfo;
      private int isJacksonJsonTypeInfoBuildStage;

      boolean isJacksonJsonTypeInfo() {
        if (isJacksonJsonTypeInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isJacksonJsonTypeInfoBuildStage == STAGE_UNINITIALIZED) {
          isJacksonJsonTypeInfoBuildStage = STAGE_INITIALIZING;
          this.isJacksonJsonTypeInfo = MetaAnnotated.super.isJacksonJsonTypeInfo();
          isJacksonJsonTypeInfoBuildStage = STAGE_INITIALIZED;
        }
        return this.isJacksonJsonTypeInfo;
      }
      private boolean isJsonQualifier;
      private int isJsonQualifierBuildStage;

      boolean isJsonQualifier() {
        if (isJsonQualifierBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isJsonQualifierBuildStage == STAGE_UNINITIALIZED) {
          isJsonQualifierBuildStage = STAGE_INITIALIZING;
          this.isJsonQualifier = MetaAnnotated.super.isJsonQualifier();
          isJsonQualifierBuildStage = STAGE_INITIALIZED;
        }
        return this.isJsonQualifier;
      }
      private boolean isEnclosing;
      private int isEnclosingBuildStage;

      boolean isEnclosing() {
        if (isEnclosingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isEnclosingBuildStage == STAGE_UNINITIALIZED) {
          isEnclosingBuildStage = STAGE_INITIALIZING;
          this.isEnclosing = MetaAnnotated.super.isEnclosing();
          isEnclosingBuildStage = STAGE_INITIALIZED;
        }
        return this.isEnclosing;
      }
      private Optional<AnnotationInjections.InjectionInfo> injectAnnotation;
      private int injectAnnotationBuildStage;

      Optional<AnnotationInjections.InjectionInfo> injectAnnotation() {
        if (injectAnnotationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (injectAnnotationBuildStage == STAGE_UNINITIALIZED) {
          injectAnnotationBuildStage = STAGE_INITIALIZING;
          this.injectAnnotation = Objects.requireNonNull(MetaAnnotated.super.injectAnnotation(), "injectAnnotation");
          injectAnnotationBuildStage = STAGE_INITIALIZED;
        }
        return this.injectAnnotation;
      }

      private String formatInitCycleMessage() {
        ArrayList<String> attributes = Lists.newArrayList();
        if (encodingsBuildStage == STAGE_INITIALIZING) attributes.add("encodings");
        if (styleBuildStage == STAGE_INITIALIZING) attributes.add("style");
        if (depluralizeBuildStage == STAGE_INITIALIZING) attributes.add("depluralize");
        if (serialVersionBuildStage == STAGE_INITIALIZING) attributes.add("serialVersion");
        if (isSerialStructuralBuildStage == STAGE_INITIALIZING) attributes.add("isSerialStructural");
        if (isJacksonSerializedBuildStage == STAGE_INITIALIZING) attributes.add("isJacksonSerialized");
        if (isJacksonDeserializedBuildStage == STAGE_INITIALIZING) attributes.add("isJacksonDeserialized");
        if (isJacksonJsonTypeInfoBuildStage == STAGE_INITIALIZING) attributes.add("isJacksonJsonTypeInfo");
        if (isJsonQualifierBuildStage == STAGE_INITIALIZING) attributes.add("isJsonQualifier");
        if (isEnclosingBuildStage == STAGE_INITIALIZING) attributes.add("isEnclosing");
        if (injectAnnotationBuildStage == STAGE_INITIALIZING) attributes.add("injectAnnotation");
        return "Cannot build MetaAnnotated, attribute initializers form cycle" + attributes;
      }
    }

    /**
     * @return The value of the {@code element} attribute
     */
    @Override
    public Element element() {
      return element;
    }

    /**
     * @return The value of the {@code qualifiedName} attribute
     */
    @Override
    public String qualifiedName() {
      return qualifiedName;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @Override
    public Proto.Environment environment() {
      return environment;
    }

    /**
     * @return The computed-at-construction value of the {@code encodings} attribute
     */
    @Override
    public Set<EncodingInfo> encodings() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.encodings()
          : this.encodings;
    }

    /**
     * @return The computed-at-construction value of the {@code style} attribute
     */
    @Override
    public Optional<StyleInfo> style() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.style()
          : this.style;
    }

    /**
     * @return The computed-at-construction value of the {@code depluralize} attribute
     */
    @Override
    public Optional<String[]> depluralize() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.depluralize()
          : this.depluralize;
    }

    /**
     * @return The computed-at-construction value of the {@code serialVersion} attribute
     */
    @Override
    public Optional<Long> serialVersion() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.serialVersion()
          : this.serialVersion;
    }

    /**
     * @return The computed-at-construction value of the {@code isSerialStructural} attribute
     */
    @Override
    public boolean isSerialStructural() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isSerialStructural()
          : this.isSerialStructural;
    }

    /**
     * @return The computed-at-construction value of the {@code isJacksonSerialized} attribute
     */
    @Override
    public boolean isJacksonSerialized() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isJacksonSerialized()
          : this.isJacksonSerialized;
    }

    /**
     * @return The computed-at-construction value of the {@code isJacksonDeserialized} attribute
     */
    @Override
    public boolean isJacksonDeserialized() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isJacksonDeserialized()
          : this.isJacksonDeserialized;
    }

    /**
     * @return The computed-at-construction value of the {@code isJacksonJsonTypeInfo} attribute
     */
    @Override
    public boolean isJacksonJsonTypeInfo() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isJacksonJsonTypeInfo()
          : this.isJacksonJsonTypeInfo;
    }

    /**
     * @return The computed-at-construction value of the {@code isJsonQualifier} attribute
     */
    @Override
    public boolean isJsonQualifier() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isJsonQualifier()
          : this.isJsonQualifier;
    }

    /**
     * @return The computed-at-construction value of the {@code isEnclosing} attribute
     */
    @Override
    public boolean isEnclosing() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isEnclosing()
          : this.isEnclosing;
    }

    /**
     * @return The computed-at-construction value of the {@code injectAnnotation} attribute
     */
    @Override
    public Optional<AnnotationInjections.InjectionInfo> injectAnnotation() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.injectAnnotation()
          : this.injectAnnotation;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.MetaAnnotated#element() element} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for element
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.MetaAnnotated withElement(Element value) {
      if (this.element == value) return this;
      Element newValue = Objects.requireNonNull(value, "element");
      return new ImmutableProto.MetaAnnotated(this, newValue, this.qualifiedName, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.MetaAnnotated#qualifiedName() qualifiedName} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for qualifiedName
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.MetaAnnotated withQualifiedName(String value) {
      if (this.qualifiedName.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "qualifiedName");
      return new ImmutableProto.MetaAnnotated(this, this.element, newValue, this.environment);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Proto.MetaAnnotated#environment() environment} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableProto.MetaAnnotated withEnvironment(Proto.Environment value) {
      if (this.environment == value) return this;
      Proto.Environment newValue = Objects.requireNonNull(value, "environment");
      return new ImmutableProto.MetaAnnotated(this, this.element, this.qualifiedName, newValue);
    }

    /**
     * This instance is equal to all instances of {@code MetaAnnotated} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableProto.MetaAnnotated
          && equalTo((ImmutableProto.MetaAnnotated) another);
    }

    private boolean equalTo(ImmutableProto.MetaAnnotated another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 2091445391;
    }

    /**
     * Prints the immutable value {@code MetaAnnotated}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "MetaAnnotated{}";
    }

    /**
     * Construct a new immutable {@code MetaAnnotated} instance.
     * @param element The value for the {@code element} attribute
     * @param qualifiedName The value for the {@code qualifiedName} attribute
     * @param environment The value for the {@code environment} attribute
     * @return An immutable MetaAnnotated instance
     */
    public static ImmutableProto.MetaAnnotated of(Element element, String qualifiedName, Proto.Environment environment) {
      return new ImmutableProto.MetaAnnotated(element, qualifiedName, environment);
    }

    /**
     * Creates an immutable copy of a {@link Proto.MetaAnnotated} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable MetaAnnotated instance
     */
    public static ImmutableProto.MetaAnnotated copyOf(Proto.MetaAnnotated instance) {
      if (instance instanceof ImmutableProto.MetaAnnotated) {
        return (ImmutableProto.MetaAnnotated) instance;
      }
      return ImmutableProto.MetaAnnotated.of(instance.element(), instance.qualifiedName(), instance.environment());
    }
  }
}
