/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import io.reactivex.Flowable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.transaction.Transaction;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManagerFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.keymappers.Key2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.persistence.spi.TransactionalCacheWriter;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Store(shared=true)
@ConfiguredBy(value=JdbcStringBasedStoreConfiguration.class)
public class JdbcStringBasedStore<K, V>
implements SegmentedAdvancedLoadWriteStore<K, V>,
TransactionalCacheWriter<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JdbcStringBasedStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<Transaction, Connection> transactionConnectionMap = new ConcurrentHashMap<Transaction, Connection>();
    private JdbcStringBasedStoreConfiguration configuration;
    private GlobalConfiguration globalConfiguration;
    private Key2StringMapper key2StringMapper;
    private String cacheName;
    private ConnectionFactory connectionFactory;
    private MarshalledEntryFactory<K, V> marshalledEntryFactory;
    private StreamingMarshaller marshaller;
    private TableManager tableManager;
    private TimeService timeService;
    private KeyPartitioner keyPartitioner;
    private boolean isDistributedCache;

    public void init(InitializationContext ctx) {
        this.configuration = (JdbcStringBasedStoreConfiguration)ctx.getConfiguration();
        this.cacheName = ctx.getCache().getName();
        this.globalConfiguration = ctx.getCache().getCacheManager().getCacheManagerConfiguration();
        this.marshalledEntryFactory = ctx.getMarshalledEntryFactory();
        this.marshaller = ctx.getMarshaller();
        this.timeService = ctx.getTimeService();
        this.keyPartitioner = this.configuration.segmented() ? ctx.getKeyPartitioner() : null;
        this.isDistributedCache = ctx.getCache().getCacheConfiguration() != null && ctx.getCache().getCacheConfiguration().clustering().cacheMode().isDistributed();
    }

    public void start() {
        if (this.configuration.manageConnectionFactory()) {
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory(this.configuration.connectionFactory().connectionFactoryClass());
            factory.start(this.configuration.connectionFactory(), factory.getClass().getClassLoader());
            this.initializeConnectionFactory(factory);
        }
        try {
            Object mapper = Util.loadClassStrict((String)this.configuration.key2StringMapper(), (ClassLoader)this.globalConfiguration.classLoader()).newInstance();
            if (mapper instanceof Key2StringMapper) {
                this.key2StringMapper = (Key2StringMapper)mapper;
            }
        }
        catch (Exception e) {
            log.errorf("Trying to instantiate %s, however it failed due to %s", this.configuration.key2StringMapper(), e.getClass().getName());
            throw new IllegalStateException("This should not happen.", e);
        }
        if (trace) {
            log.tracef("Using key2StringMapper: %s", this.key2StringMapper.getClass().getName());
        }
        if (this.configuration.preload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (this.isDistributedCache) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
    }

    public void stop() {
        Object cause = null;
        try {
            if (this.tableManager != null) {
                this.tableManager.stop();
                this.tableManager = null;
            }
        }
        catch (Throwable t) {
            log.debug("Exception while stopping", t);
        }
        try {
            log.tracef("Stopping connection factory: %s", this.connectionFactory);
            if (this.connectionFactory != null) {
                this.connectionFactory.stop();
            }
        }
        catch (Throwable t) {
            log.debug("Exception while stopping", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        if (this.tableManager == null || this.connectionFactory == null) {
            return false;
        }
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            boolean bl = connection != null && connection.isValid(10);
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    void initializeConnectionFactory(ConnectionFactory connectionFactory) throws PersistenceException {
        this.connectionFactory = connectionFactory;
        this.tableManager = this.getTableManager();
        this.tableManager.setCacheName(this.cacheName);
        this.tableManager.start();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private int getSegment(MarshalledEntry entry) {
        if (this.keyPartitioner == null) {
            return -1;
        }
        return this.keyPartitioner.getSegment(entry.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MarshalledEntry entry) {
        Connection connection = null;
        String keyStr = this.key2Str(entry.getKey());
        try {
            connection = this.connectionFactory.getConnection();
            this.write(entry, connection, keyStr, this.getSegment(entry));
        }
        catch (SQLException ex) {
            log.sqlFailureStoringKey(keyStr, ex);
            throw new PersistenceException(String.format("Error while storing string key to database; key: '%s'", keyStr), (Throwable)ex);
        }
        catch (InterruptedException e) {
            if (trace) {
                log.trace("Interrupted while marshalling to store");
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    private void write(MarshalledEntry entry, Connection connection, int segment) throws SQLException, InterruptedException {
        this.write(entry, connection, this.key2Str(entry.getKey()), segment);
    }

    private void write(MarshalledEntry entry, Connection connection, String keyStr, int segment) throws SQLException, InterruptedException {
        if (this.tableManager.isUpsertSupported()) {
            this.executeUpsert(connection, entry, keyStr, segment);
        } else {
            this.executeLegacyUpdate(connection, entry, keyStr, segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpsert(Connection connection, MarshalledEntry entry, String keyStr, int segment) throws InterruptedException, SQLException {
        PreparedStatement ps = null;
        String sql = this.tableManager.getUpsertRowSql();
        if (trace) {
            log.tracef("Running sql '%s'. Key string is '%s'", sql, keyStr);
        }
        try {
            ps = connection.prepareStatement(sql);
            this.prepareUpsertStatement(entry, keyStr, segment, ps);
            ps.executeUpdate();
        }
        finally {
            JdbcUtil.safeClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLegacyUpdate(Connection connection, MarshalledEntry entry, String keyStr, int segment) throws InterruptedException, SQLException {
        String sql = this.tableManager.getSelectIdRowSql();
        if (trace) {
            log.tracef("Running sql '%s'. Key string is '%s'", sql, keyStr);
        }
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            ResultSet rs = ps.executeQuery();
            boolean update = rs.next();
            sql = update ? this.tableManager.getUpdateRowSql() : this.tableManager.getInsertRowSql();
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            if (trace) {
                log.tracef("Running sql '%s'. Key string is '%s'", sql, keyStr);
            }
            ps = connection.prepareStatement(sql);
            this.prepareStatement(entry, keyStr, segment, ps, !update);
            ps.executeUpdate();
        }
        finally {
            JdbcUtil.safeClose(ps);
        }
    }

    public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
        if (!this.tableManager.isUpsertSupported()) {
            marshalledEntries.forEach(this::write);
            return;
        }
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            try (PreparedStatement upsertBatch = connection.prepareStatement(this.tableManager.getUpsertRowSql());){
                int batchSize = 0;
                for (MarshalledEntry<K, V> marshalledEntry : marshalledEntries) {
                    String keyStr = this.key2Str(marshalledEntry.getKey());
                    this.prepareUpsertStatement(marshalledEntry, keyStr, this.getSegment(marshalledEntry), upsertBatch);
                    upsertBatch.addBatch();
                    if (++batchSize != this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    upsertBatch.executeBatch();
                    upsertBatch.clearBatch();
                }
                if (batchSize != 0) {
                    upsertBatch.executeBatch();
                }
            }
        }
        catch (InterruptedException | SQLException e) {
            throw log.sqlFailureWritingBatch(e);
        }
        finally {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    public void deleteBatch(Iterable<Object> keys) {
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            try (PreparedStatement deleteBatch = connection.prepareStatement(this.tableManager.getDeleteRowSql());){
                int batchSize = 0;
                for (Object key : keys) {
                    String keyStr = this.key2Str(key);
                    deleteBatch.setString(1, keyStr);
                    deleteBatch.addBatch();
                    if (++batchSize != this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    deleteBatch.executeBatch();
                    deleteBatch.clearBatch();
                }
                if (batchSize != 0) {
                    deleteBatch.executeBatch();
                }
            }
        }
        catch (SQLException e) {
            throw log.sqlFailureDeletingBatch(keys, e);
        }
        finally {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    public MarshalledEntry<K, V> load(Object key) {
        String lockingKey = this.key2Str(key);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        MarshalledEntry storedValue = null;
        try {
            String sql = this.tableManager.getSelectRowSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, lockingKey);
            rs = ps.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getBinaryStream(2);
                KeyValuePair icv = (KeyValuePair)this.unmarshall(inputStream);
                storedValue = this.marshalledEntryFactory.newMarshalledEntry(key, (ByteBuffer)icv.getKey(), (ByteBuffer)icv.getValue());
            }
        }
        catch (SQLException e) {
            try {
                log.sqlFailureReadingKey(key, lockingKey, e);
                throw new PersistenceException(String.format("SQL error while fetching stored entry with key: %s, lockingKey: %s", key, lockingKey), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        if (storedValue != null && storedValue.getMetadata() != null && storedValue.getMetadata().isExpired(this.timeService.wallClockTime())) {
            return null;
        }
        return storedValue;
    }

    public void clear() {
        Connection conn = null;
        Statement statement = null;
        try {
            String sql = this.tableManager.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            statement = conn.createStatement();
            int result = statement.executeUpdate(sql);
            if (log.isTraceEnabled()) {
                log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                log.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing cache store", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(statement);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(statement);
        this.connectionFactory.releaseConnection(conn);
    }

    public void clear(IntSet segments) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManager.getDeleteRowsSqlForSegments(segments.size());
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int offset = 0;
            PrimitiveIterator.OfInt segIter = segments.iterator();
            while (segIter.hasNext()) {
                ps.setInt(++offset, segIter.nextInt());
            }
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                log.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing cache store when using segments " + segments, (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    public boolean delete(Object key) {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        String keyStr = this.key2Str(key);
        try {
            String sql = this.tableManager.getDeleteRowSql();
            if (trace) {
                log.tracef("Running sql '%s' on %s", sql, keyStr);
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            bl = ps.executeUpdate() == 1;
        }
        catch (SQLException ex) {
            try {
                log.sqlFailureRemovingKeys(ex);
                throw new PersistenceException("Error while removing string keys from database", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
        return bl;
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.tableManager.getSelectOnlyExpiredRowsSql();
            conn = this.connectionFactory.getConnection();
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(sql);
            ps.setLong(1, this.timeService.wallClockTime());
            rs = ps.executeQuery();
            try (PreparedStatement batchDelete = conn.prepareStatement(this.tableManager.getDeleteRowSql());){
                int affectedRows = 0;
                boolean twoWayMapperExists = this.key2StringMapper instanceof TwoWayKey2StringMapper;
                while (rs.next()) {
                    ++affectedRows;
                    String keyStr = rs.getString(2);
                    batchDelete.setString(1, keyStr);
                    batchDelete.addBatch();
                    if (!twoWayMapperExists || purgeListener == null) continue;
                    Object key = ((TwoWayKey2StringMapper)this.key2StringMapper).getKeyMapping(keyStr);
                    purgeListener.entryPurged(key);
                }
                if (!twoWayMapperExists) {
                    log.twoWayKey2StringMapperIsMissing(TwoWayKey2StringMapper.class.getSimpleName());
                }
                if (affectedRows > 0) {
                    int[] result = batchDelete.executeBatch();
                    if (trace) {
                        log.tracef("Successfully purged %d rows.", result.length);
                    }
                }
                conn.commit();
            }
        }
        catch (SQLException e) {
            try {
                log.failedClearingJdbcCacheStore(e);
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    log.sqlFailureTxRollback(ex);
                }
                throw new PersistenceException("Failed clearing string based JDBC store", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    public boolean contains(Object key) {
        return this.load(key) != null;
    }

    private <P> Flowable<P> publish(IntSet segments, Function<ResultSet, Flowable<P>> function) {
        return Flowable.using(() -> {
            String sql = segments != null ? this.tableManager.getLoadNonExpiredRowsSqlForSegments(segments.size()) : this.tableManager.getLoadNonExpiredAllRowsSql();
            if (trace) {
                log.tracef("Running sql %s", sql);
            }
            return new FlowableConnection(this.connectionFactory, sql);
        }, fc -> {
            PreparedStatement ps = fc.statement;
            int offset = 1;
            ps.setLong(offset, this.timeService.wallClockTime());
            if (segments != null) {
                PrimitiveIterator.OfInt segIter = segments.iterator();
                while (segIter.hasNext()) {
                    ps.setInt(++offset, segIter.nextInt());
                }
            }
            ps.setFetchSize(this.tableManager.getFetchSize());
            ResultSet rs = ps.executeQuery();
            return ((Flowable)function.apply(rs)).doOnComplete(() -> JdbcUtil.safeClose(rs));
        }, FlowableConnection::close);
    }

    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return this.publish(null, rs -> Flowable.fromIterable(() -> new ResultSetKeyIterator((ResultSet)rs, filter)));
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return this.publish(segments, rs -> Flowable.fromIterable(() -> new ResultSetKeyIterator((ResultSet)rs, filter)));
    }

    public Flowable<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.publish(null, rs -> Flowable.fromIterable(() -> new ResultSetEntryIterator((ResultSet)rs, filter, fetchValue, fetchMetadata)));
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.publish(segments, rs -> Flowable.fromIterable(() -> new ResultSetEntryIterator((ResultSet)rs, filter, fetchValue, fetchMetadata)));
    }

    public void prepareWithModifications(Transaction transaction, BatchModification batchModification) throws PersistenceException {
        try {
            Connection connection = this.getTxConnection(transaction);
            connection.setAutoCommit(false);
            boolean upsertSupported = this.tableManager.isUpsertSupported();
            try (PreparedStatement upsertBatch = upsertSupported ? connection.prepareStatement(this.tableManager.getUpsertRowSql()) : null;
                 PreparedStatement deleteBatch = connection.prepareStatement(this.tableManager.getDeleteRowSql());){
                for (MarshalledEntry entry : batchModification.getMarshalledEntries()) {
                    int segment = this.getSegment(entry);
                    if (upsertSupported) {
                        String keyStr = this.key2Str(entry.getKey());
                        this.prepareUpsertStatement(entry, keyStr, segment, upsertBatch);
                        upsertBatch.addBatch();
                        continue;
                    }
                    this.write(entry, connection, segment);
                }
                for (Object key : batchModification.getKeysToRemove()) {
                    String keyStr = this.key2Str(key);
                    deleteBatch.setString(1, keyStr);
                    deleteBatch.addBatch();
                }
                if (upsertSupported && !batchModification.getMarshalledEntries().isEmpty()) {
                    upsertBatch.executeBatch();
                }
                if (!batchModification.getKeysToRemove().isEmpty()) {
                    deleteBatch.executeUpdate();
                }
            }
        }
        catch (InterruptedException | SQLException e) {
            throw log.prepareTxFailure(e);
        }
    }

    public void commit(Transaction tx) {
        try {
            Connection connection = this.getTxConnection(tx);
            connection.commit();
        }
        catch (SQLException e) {
            log.sqlFailureTxCommit(e);
            throw new PersistenceException(String.format("Error during commit of JDBC transaction (%s)", tx), (Throwable)e);
        }
        finally {
            this.destroyTxConnection(tx);
        }
    }

    public void rollback(Transaction tx) {
        try {
            Connection connection = this.getTxConnection(tx);
            connection.rollback();
        }
        catch (SQLException e) {
            log.sqlFailureTxRollback(e);
            throw new PersistenceException(String.format("Error during rollback of JDBC transaction (%s)", tx), (Throwable)e);
        }
        finally {
            this.destroyTxConnection(tx);
        }
    }

    private Connection getTxConnection(Transaction tx) {
        Connection connection = this.transactionConnectionMap.get(tx);
        if (connection == null) {
            connection = this.connectionFactory.getConnection();
            this.transactionConnectionMap.put(tx, connection);
        }
        return connection;
    }

    private void destroyTxConnection(Transaction tx) {
        Connection connection = this.transactionConnectionMap.remove(tx);
        if (connection != null) {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    public int size() {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.connectionFactory.getConnection();
            String sql = this.tableManager.getCountNonExpiredRowsSql();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, this.timeService.wallClockTime());
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                log.sqlFailureIntegratingState(e);
                throw new PersistenceException("SQL failure while integrating state into store", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return n;
    }

    public int size(IntSet segments) {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.connectionFactory.getConnection();
            String sql = this.tableManager.getCountNonExpiredRowsSqlForSegments(segments.size());
            ps = conn.prepareStatement(sql);
            int offset = 1;
            ps.setLong(offset, this.timeService.wallClockTime());
            PrimitiveIterator.OfInt segIter = segments.iterator();
            while (segIter.hasNext()) {
                ps.setInt(++offset, segIter.nextInt());
            }
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                log.sqlFailureIntegratingState(e);
                throw new PersistenceException("SQL failure while integrating state into store", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return n;
    }

    private void prepareUpsertStatement(MarshalledEntry entry, String key, int segment, PreparedStatement ps) throws InterruptedException, SQLException {
        this.prepareStatement(entry, key, segment, ps, true);
    }

    private void prepareStatement(MarshalledEntry entry, String key, int segment, PreparedStatement ps, boolean upsert) throws InterruptedException, SQLException {
        ByteBuffer byteBuffer = this.marshall(new KeyValuePair((Object)entry.getValueBytes(), (Object)entry.getMetadataBytes()));
        long expiryTime = PersistenceUtil.getExpiryTime((InternalMetadata)entry.getMetadata());
        if (upsert) {
            this.tableManager.prepareUpsertStatement(ps, key, expiryTime, segment, byteBuffer);
        } else {
            this.tableManager.prepareUpdateStatement(ps, key, expiryTime, segment, byteBuffer);
        }
    }

    private String key2Str(Object key) throws PersistenceException {
        if (!this.key2StringMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        String keyStr = this.key2StringMapper.getStringMapping(key);
        return this.tableManager.isStringEncodingRequired() ? this.tableManager.encodeString(keyStr) : keyStr;
    }

    public TableManager getTableManager() {
        if (this.tableManager == null) {
            this.tableManager = TableManagerFactory.getManager(this.connectionFactory, this.configuration);
        }
        return this.tableManager;
    }

    private void enforceTwoWayMapper(String where) throws PersistenceException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            log.invalidKey2StringMapper(where, this.key2StringMapper.getClass().getName());
            throw new PersistenceException(String.format("Invalid key to string mapper : %s", this.key2StringMapper.getClass().getName()));
        }
    }

    private ByteBuffer marshall(Object obj) throws PersistenceException, InterruptedException {
        try {
            return this.marshaller.objectToBuffer(obj);
        }
        catch (IOException e) {
            log.errorMarshallingObject(e, obj);
            throw new PersistenceException("I/O failure while marshalling object: " + obj, (Throwable)e);
        }
    }

    private <T> T unmarshall(InputStream inputStream) throws PersistenceException {
        try {
            return (T)this.marshaller.objectFromInputStream(inputStream);
        }
        catch (IOException e) {
            log.ioErrorUnmarshalling(e);
            throw new PersistenceException("I/O error while unmarshalling from stream", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.unexpectedClassNotFoundException(e);
            throw new PersistenceException("*UNEXPECTED* ClassNotFoundException. This should not happen as Bucket class exists", (Throwable)e);
        }
    }

    private class ResultSetKeyIterator
    extends AbstractIterator<K> {
        private final ResultSet rs;
        private final Predicate<? super K> filter;

        public ResultSetKeyIterator(ResultSet rs, Predicate<? super K> filter) {
            this.rs = rs;
            this.filter = filter;
        }

        protected K getNext() {
            Object key = null;
            try {
                while (key == null && this.rs.next()) {
                    String keyStr = this.rs.getString(2);
                    Object testKey = ((TwoWayKey2StringMapper)JdbcStringBasedStore.this.key2StringMapper).getKeyMapping(keyStr);
                    if (this.filter != null && !this.filter.test(testKey)) continue;
                    key = testKey;
                }
            }
            catch (SQLException e) {
                throw new CacheException((Throwable)e);
            }
            return key;
        }
    }

    private class ResultSetEntryIterator
    extends AbstractIterator<MarshalledEntry<K, V>> {
        private final ResultSet rs;
        private final Predicate<? super K> filter;
        private final boolean fetchValue;
        private final boolean fetchMetadata;

        public ResultSetEntryIterator(ResultSet rs, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
            this.rs = rs;
            this.filter = filter;
            this.fetchValue = fetchValue;
            this.fetchMetadata = fetchMetadata;
        }

        protected MarshalledEntry<K, V> getNext() {
            MarshalledEntry entry = null;
            try {
                while (entry == null && this.rs.next()) {
                    String keyStr = this.rs.getString(2);
                    Object key = ((TwoWayKey2StringMapper)JdbcStringBasedStore.this.key2StringMapper).getKeyMapping(keyStr);
                    if (this.filter != null && !this.filter.test(key)) continue;
                    if (this.fetchValue || this.fetchMetadata) {
                        InputStream inputStream = this.rs.getBinaryStream(1);
                        KeyValuePair kvp = (KeyValuePair)JdbcStringBasedStore.this.unmarshall(inputStream);
                        entry = JdbcStringBasedStore.this.marshalledEntryFactory.newMarshalledEntry(key, this.fetchValue ? (ByteBuffer)kvp.getKey() : null, this.fetchMetadata ? (ByteBuffer)kvp.getValue() : null);
                        continue;
                    }
                    entry = JdbcStringBasedStore.this.marshalledEntryFactory.newMarshalledEntry(key, null, null);
                }
            }
            catch (SQLException e) {
                throw new CacheException((Throwable)e);
            }
            return entry;
        }
    }

    class FlowableConnection {
        final boolean autoCommit;
        final ConnectionFactory factory;
        final Connection connection;
        final PreparedStatement statement;

        FlowableConnection(ConnectionFactory factory, String sql) throws SQLException {
            this.factory = factory;
            this.connection = factory.getConnection();
            this.autoCommit = this.connection.getAutoCommit();
            this.statement = this.connection.prepareStatement(sql);
            if (this.autoCommit) {
                this.connection.setAutoCommit(false);
            }
        }

        void close() {
            JdbcUtil.safeClose(this.statement);
            if (this.autoCommit) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    log.sqlFailureTxRollback(e);
                }
            }
            this.factory.releaseConnection(this.connection);
        }
    }
}

