/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.rest.configuration.AbstractRestStoreConfigurationChildBuilder;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;

public class ConnectionPoolConfigurationBuilder
extends AbstractRestStoreConfigurationChildBuilder<RestStoreConfigurationBuilder>
implements Builder<ConnectionPoolConfiguration>,
ConfigurationBuilderInfo {
    ConnectionPoolConfigurationBuilder(RestStoreConfigurationBuilder builder) {
        super(builder, ConnectionPoolConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ConnectionPoolConfiguration.ELEMENT_DEFINITION;
    }

    public ConnectionPoolConfigurationBuilder maxConnectionsPerHost(int maxConnectionsPerHost) {
        this.attributes.attribute(ConnectionPoolConfiguration.MAX_CONNECTIONS_PER_HOST).set((Object)maxConnectionsPerHost);
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxTotalConnections(int maxTotalConnections) {
        this.attributes.attribute(ConnectionPoolConfiguration.MAX_TOTAL_CONNECTIONS).set((Object)maxTotalConnections);
        return this;
    }

    public ConnectionPoolConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.attributes.attribute(ConnectionPoolConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    public ConnectionPoolConfigurationBuilder bufferSize(int bufferSize) {
        this.attributes.attribute(ConnectionPoolConfiguration.BUFFER_SIZE).set((Object)bufferSize);
        return this;
    }

    public ConnectionPoolConfigurationBuilder socketTimeout(int socketTimeout) {
        this.attributes.attribute(ConnectionPoolConfiguration.SOCKET_TIMEOUT).set((Object)socketTimeout);
        return this;
    }

    public ConnectionPoolConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.attributes.attribute(ConnectionPoolConfiguration.TCP_NO_DELAY).set((Object)tcpNoDelay);
        return this;
    }

    public void validate() {
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.attributes);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.maxConnectionsPerHost(template.maxConnectionsPerHost());
        this.maxTotalConnections(template.maxTotalConnections());
        this.connectionTimeout(template.connectionTimeout());
        this.bufferSize(template.bufferSize());
        this.socketTimeout(template.socketTimeout());
        this.tcpNoDelay(template.tcpNoDelay());
        return this;
    }
}

