/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import io.reactivex.Flowable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;
import org.infinispan.persistence.rocksdb.logging.Log;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

@Store
@ConfiguredBy(value=RocksDBStoreConfiguration.class)
public class RocksDBStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(RocksDBStore.class, Log.class);
    private RocksDBStoreConfiguration configuration;
    private BlockingQueue<ExpiryEntry> expiryEntryQueue;
    private RocksDB db;
    private RocksDB expiredDb;
    private InitializationContext ctx;
    private Semaphore semaphore;
    private WriteOptions dataWriteOptions;
    private volatile boolean stopped = true;

    public void init(InitializationContext ctx) {
        this.configuration = (RocksDBStoreConfiguration)ctx.getConfiguration();
        this.ctx = ctx;
        this.semaphore = new Semaphore(Integer.MAX_VALUE, true);
    }

    public void start() {
        this.expiryEntryQueue = new LinkedBlockingQueue<ExpiryEntry>(this.configuration.expiryQueueSize());
        try {
            this.db = this.openDatabase(this.getQualifiedLocation(), this.dataDbOptions());
            this.expiredDb = this.openDatabase(this.getQualifiedExpiredLocation(), this.expiredDbOptions());
            this.stopped = false;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to open database", (Throwable)e);
        }
    }

    private String sanitizedCacheName() {
        return this.ctx.getCache().getName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    private String getQualifiedLocation() {
        return this.configuration.location() + this.sanitizedCacheName();
    }

    private String getQualifiedExpiredLocation() {
        return this.configuration.expiredLocation() + this.sanitizedCacheName();
    }

    private WriteOptions dataWriteOptions() {
        if (this.dataWriteOptions == null) {
            this.dataWriteOptions = new WriteOptions().setDisableWAL(false);
        }
        return this.dataWriteOptions;
    }

    private Options dataDbOptions() {
        Options options = new Options().setCreateIfMissing(true);
        options.setCompressionType(CompressionType.getCompressionType((String)this.configuration.compressionType().toString()));
        return options;
    }

    private Options expiredDbOptions() {
        return new Options().setCreateIfMissing(true);
    }

    protected RocksDB openDatabase(String location, Options options) throws IOException, RocksDBException {
        File dir = new File(location);
        dir.mkdirs();
        return RocksDB.open((Options)options, (String)location);
    }

    protected void destroyDatabase(String location) throws IOException {
        System.gc();
        Util.recursiveFileRemove((File)new File(location));
    }

    protected RocksDB reinitDatabase(String location, Options options) throws IOException, RocksDBException {
        this.destroyDatabase(location);
        return this.openDatabase(location, options);
    }

    protected void reinitAllDatabases() throws IOException, RocksDBException {
        try {
            this.semaphore.acquire(Integer.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
        }
        try {
            if (this.stopped) {
                throw new PersistenceException("RocksDB is stopped");
            }
            this.db.close();
            this.expiredDb.close();
            this.db = this.reinitDatabase(this.getQualifiedLocation(), this.dataDbOptions());
            this.expiredDb = this.reinitDatabase(this.getQualifiedExpiredLocation(), this.expiredDbOptions());
        }
        finally {
            this.semaphore.release(Integer.MAX_VALUE);
        }
    }

    public void stop() {
        try {
            this.semaphore.acquire(Integer.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
        }
        try {
            this.db.close();
            this.expiredDb.close();
        }
        finally {
            this.stopped = true;
            this.semaphore.release(Integer.MAX_VALUE);
        }
    }

    public boolean isAvailable() {
        return new File(this.getQualifiedLocation()).exists() && new File(this.getQualifiedExpiredLocation()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean destroyDatabase;
        block26: {
            long count = 0L;
            destroyDatabase = false;
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
            }
            try {
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                Optional<RocksIterator> optionalIterator = RocksDBStore.wrapIterator(this.db);
                if (optionalIterator.isPresent() && this.configuration.clearThreshold() <= 0) {
                    try (RocksIterator it = optionalIterator.get();){
                        it.seekToFirst();
                        while (it.isValid()) {
                            this.db.delete(it.key());
                            if (++count > (long)this.configuration.clearThreshold()) {
                                destroyDatabase = true;
                                break block26;
                            }
                            it.next();
                        }
                        break block26;
                    }
                    catch (RocksDBException e) {
                        destroyDatabase = true;
                    }
                    break block26;
                }
                destroyDatabase = true;
            }
            finally {
                this.semaphore.release();
            }
        }
        if (destroyDatabase) {
            try {
                this.reinitAllDatabases();
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private static Optional<RocksIterator> wrapIterator(RocksDB db) {
        return Optional.of(db.newIterator(new ReadOptions().setFillCache(false)));
    }

    public int size() {
        return PersistenceUtil.count((AdvancedCacheLoader)this, null);
    }

    public boolean contains(Object key) {
        try {
            return this.load(key) != null;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private <P> Flowable<P> publish(Function<RocksIterator, Flowable<P>> function) {
        return Flowable.using(() -> {
            this.semaphore.acquire();
            if (this.stopped) {
                throw new PersistenceException("RocksDB is stopped");
            }
            return RocksDBStore.wrapIterator(this.db);
        }, opIterator -> {
            if (!opIterator.isPresent()) {
                return Flowable.empty();
            }
            RocksIterator it = (RocksIterator)opIterator.get();
            it.seekToFirst();
            return (Publisher)function.apply(it);
        }, opIterator -> {
            opIterator.ifPresent(AbstractImmutableNativeReference::close);
            this.semaphore.release();
        });
    }

    public Publisher<K> publishKeys(Predicate<? super K> filter) {
        return this.publish(it -> Flowable.fromIterable(() -> new AbstractIterator<K>((RocksIterator)it, filter){
            final /* synthetic */ RocksIterator val$it;
            final /* synthetic */ Predicate val$filter;
            {
                this.val$it = rocksIterator;
                this.val$filter = predicate;
            }

            protected K getNext() {
                Object key = null;
                try {
                    while (key == null && this.val$it.isValid()) {
                        Object testKey = RocksDBStore.this.unmarshall(this.val$it.key());
                        if (this.val$filter == null || this.val$filter.test(testKey)) {
                            key = testKey;
                        }
                        this.val$it.next();
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new CacheException((Throwable)e);
                }
                return key;
            }
        }));
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.publish(it -> Flowable.fromIterable(() -> {
            long now = this.ctx.getTimeService().wallClockTime();
            return new AbstractIterator<MarshalledEntry<K, V>>((RocksIterator)it, filter, fetchValue, fetchMetadata, now){
                final /* synthetic */ RocksIterator val$it;
                final /* synthetic */ Predicate val$filter;
                final /* synthetic */ boolean val$fetchValue;
                final /* synthetic */ boolean val$fetchMetadata;
                final /* synthetic */ long val$now;
                {
                    this.val$it = rocksIterator;
                    this.val$filter = predicate;
                    this.val$fetchValue = bl;
                    this.val$fetchMetadata = bl2;
                    this.val$now = l;
                }

                protected MarshalledEntry<K, V> getNext() {
                    MarshalledEntry entry = null;
                    try {
                        while (entry == null && this.val$it.isValid()) {
                            Object key = RocksDBStore.this.unmarshall(this.val$it.key());
                            if (this.val$filter == null || this.val$filter.test(key)) {
                                if (this.val$fetchValue || this.val$fetchMetadata) {
                                    MarshalledEntry unmarshalledEntry = (MarshalledEntry)RocksDBStore.this.unmarshall(this.val$it.value());
                                    InternalMetadata metadata = unmarshalledEntry.getMetadata();
                                    if (metadata == null || !metadata.isExpired(this.val$now)) {
                                        entry = this.val$fetchMetadata && this.val$fetchValue ? unmarshalledEntry : RocksDBStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, this.val$fetchValue ? unmarshalledEntry.getValue() : null, this.val$fetchMetadata ? unmarshalledEntry.getMetadata() : null);
                                    }
                                } else {
                                    entry = RocksDBStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, null, null);
                                }
                            }
                            this.val$it.next();
                        }
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new CacheException((Throwable)e);
                    }
                    return entry;
                }
            };
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(Object key) {
        try {
            byte[] keyBytes = this.marshall(key);
            this.semaphore.acquire();
            try {
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                if (this.db.get(keyBytes) == null) {
                    boolean bl = false;
                    return bl;
                }
                this.db.delete(keyBytes);
                return true;
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MarshalledEntry me) {
        try {
            byte[] marshelledKey = this.marshall(me.getKey());
            byte[] marshalledEntry = this.marshall(me);
            this.semaphore.acquire();
            try {
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                this.db.put(marshelledKey, marshalledEntry);
            }
            finally {
                this.semaphore.release();
            }
            InternalMetadata meta = me.getMetadata();
            if (meta != null && meta.expiryTime() > -1L) {
                this.addNewExpiry(me);
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public MarshalledEntry load(Object key) {
        try {
            byte[] marshalledEntry;
            this.semaphore.acquire();
            try {
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                marshalledEntry = this.db.get(this.marshall(key));
            }
            finally {
                this.semaphore.release();
            }
            MarshalledEntry me = (MarshalledEntry)this.unmarshall(marshalledEntry);
            if (me == null) {
                return null;
            }
            InternalMetadata meta = me.getMetadata();
            if (meta != null && meta.isExpired(this.ctx.getTimeService().wallClockTime())) {
                return null;
            }
            return me;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
        try {
            int batchSize = 0;
            WriteBatch batch = new WriteBatch();
            for (MarshalledEntry<K, V> marshalledEntry : marshalledEntries) {
                batch.put(this.marshall(marshalledEntry.getKey()), this.marshall(marshalledEntry));
                if (++batchSize != this.configuration.maxBatchSize()) continue;
                batchSize = 0;
                this.writeBatch(batch);
                batch = new WriteBatch();
            }
            if (batchSize != 0) {
                this.writeBatch(batch);
            }
            for (MarshalledEntry<K, V> marshalledEntry : marshalledEntries) {
                InternalMetadata meta = marshalledEntry.getMetadata();
                if (meta == null || meta.expiryTime() <= -1L) continue;
                this.addNewExpiry(marshalledEntry);
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void writeBatch(WriteBatch batch) throws InterruptedException, RocksDBException {
        this.semaphore.acquire();
        try {
            if (this.stopped) {
                throw new PersistenceException("RocksDB is stopped");
            }
            this.db.write(this.dataWriteOptions(), batch);
        }
        finally {
            this.semaphore.release();
        }
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
        block33: {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new PersistenceException("Cannot acquire semaphore: CacheStore is likely stopped.", (Throwable)e);
            }
            try {
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                ArrayList entries = new ArrayList();
                this.expiryEntryQueue.drainTo(entries);
                for (ExpiryEntry entry : entries) {
                    byte[] expiryBytes = this.marshall(entry.expiry);
                    byte[] keyBytes = this.marshall(entry.key);
                    byte[] existingBytes = this.expiredDb.get(expiryBytes);
                    if (existingBytes != null) {
                        Object existing = this.unmarshall(existingBytes);
                        if (existing instanceof List) {
                            ((List)existing).add(entry.key);
                            this.expiredDb.put(expiryBytes, this.marshall(existing));
                            continue;
                        }
                        ArrayList<Object> al = new ArrayList<Object>(2);
                        al.add(existing);
                        al.add(entry.key);
                        this.expiredDb.put(expiryBytes, this.marshall(al));
                        continue;
                    }
                    this.expiredDb.put(expiryBytes, keyBytes);
                }
                ArrayList<Object> times = new ArrayList<Object>();
                ArrayList<Object> keys = new ArrayList<Object>();
                long now = this.ctx.getTimeService().wallClockTime();
                Optional<RocksIterator> optionalIterator = RocksDBStore.wrapIterator(this.expiredDb);
                if (!optionalIterator.isPresent()) break block33;
                try (RocksIterator it = optionalIterator.get();){
                    Object time;
                    it.seekToFirst();
                    while (it.isValid() && (Long)(time = (Long)this.unmarshall(it.key())) <= now) {
                        times.add(time);
                        Object object = this.unmarshall(it.value());
                        if (object instanceof List) {
                            keys.addAll((List)object);
                        } else {
                            keys.add(object);
                        }
                        it.next();
                    }
                    for (Long l : times) {
                        this.expiredDb.delete(this.marshall(l));
                    }
                    if (!keys.isEmpty()) {
                        log.debugf("purge (up to) %d entries", keys.size());
                    }
                    int count = 0;
                    for (Object e : keys) {
                        MarshalledEntry me;
                        byte[] keyBytes = this.marshall(e);
                        byte[] b = this.db.get(keyBytes);
                        if (b == null || (me = (MarshalledEntry)this.ctx.getMarshaller().objectFromByteBuffer(b)).getMetadata() == null || !me.getMetadata().isExpired(now)) continue;
                        this.db.delete(keyBytes);
                        purgeListener.entryPurged(e);
                        ++count;
                    }
                    if (count != 0) {
                        log.debugf("purged %d entries", count);
                    }
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            catch (PersistenceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    private byte[] marshall(Object entry) throws IOException, InterruptedException {
        return this.ctx.getMarshaller().objectToByteBuffer(entry);
    }

    private Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        return this.ctx.getMarshaller().objectFromByteBuffer(bytes);
    }

    private void addNewExpiry(MarshalledEntry entry) throws IOException {
        long expiry = entry.getMetadata().expiryTime();
        long maxIdle = entry.getMetadata().maxIdle();
        if (maxIdle > 0L) {
            expiry = maxIdle + this.ctx.getTimeService().wallClockTime();
        }
        Long at = expiry;
        Object key = entry.getKey();
        try {
            this.expiryEntryQueue.put(new ExpiryEntry(at, key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static final class Entry {
        final byte[] key;
        final byte[] value;

        Entry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }
    }

    private static final class ExpiryEntry {
        private final Long expiry;
        private final Object key;

        private ExpiryEntry(long expiry, Object key) {
            this.expiry = expiry;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiryEntry other = (ExpiryEntry)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

