/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.io.PrintStream;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContext;

@GroupCommandDefinition(name="get", description="Displays resources.", groupCommands={Clusters.class})
public class Get
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="clusters", description="Get clusters")
    public static class Clusters
    extends CliCommand {
        @Option(shortName=110, description="Specifies the namespace where the cluster is running. Uses the default namespace if you do not specify one.")
        String namespace;
        @Option(name="all-namespaces", shortName=65, description="Displays the requested object(s) across all namespaces.")
        boolean allNamespaces;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;
        @Option(shortName=115, hasValue=false, description="Displays all secrets that the cluster uses.")
        protected boolean secrets;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            KubernetesClient client = KubernetesContext.getClient(invocation);
            GenericKubernetesResourceList resource = this.allNamespaces ? (GenericKubernetesResourceList)((AnyNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.INFINISPAN_CLUSTER_CRD).inAnyNamespace()).list() : (GenericKubernetesResourceList)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.INFINISPAN_CLUSTER_CRD).inNamespace(Kube.getNamespaceOrDefault(client, this.namespace))).list();
            List items = resource.getItems();
            PrintStream out = invocation.getShellOutput();
            out.printf("%-32s %-16s %-9s %-16s%n", "NAME", "NAMESPACE", "STATUS", "SECRETS");
            items.forEach(item -> {
                String n = item.getMetadata().getName();
                String ns = item.getMetadata().getNamespace();
                List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(ns)).withLabel("infinispan_cr", n)).list()).getItems();
                long running = pods.stream().map(p -> p.getStatus()).filter(s -> "Running".equalsIgnoreCase(s.getPhase())).count();
                out.printf("%-32s %-16s %-9s", n, ns, running + "/" + pods.size());
                if (this.secrets) {
                    String secretName = (String)Kube.getProperty(item, "spec", "security", "endpointSecretName");
                    Secret secret = Kube.getSecret(client, ns, secretName);
                    Kube.decodeOpaqueSecrets(secret).entrySet().forEach(c -> out.printf("%n%-60s%-16s %-16s", "", c.getKey(), c.getValue()));
                    out.println();
                } else {
                    out.printf(" %-16s%n", "******");
                }
            });
            return CommandResult.SUCCESS;
        }
    }
}

