/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.BackupCompleter;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.CacheConfigurationCompleter;
import org.infinispan.cli.completers.CounterCompleter;
import org.infinispan.cli.completers.SchemaCompleter;
import org.infinispan.cli.completers.TaskCompleter;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.util.Version;

@GroupCommandDefinition(name="backup", description="Manages container backup creation and restoration", activator=ConnectionActivator.class, groupCommands={Create.class, Delete.class, Get.class, ListBackups.class, Restore.class})
public class Backup
extends CliCommand {
    public static final String CACHES = "caches";
    public static final String TEMPLATES = "templates";
    public static final String COUNTERS = "counters";
    public static final String PROTO_SCHEMAS = "proto-schemas";
    public static final String TASKS = "tasks";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    private static CompletionStage<RestResponse> pollRestore(String restoreName, String container, RestClient c, RestResponse rsp) {
        if (rsp.status() != 202) {
            return CompletableFuture.completedFuture(rsp);
        }
        return Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.trampoline()).repeat(100L).flatMapSingle(Void2 -> Single.fromCompletionStage((CompletionStage)c.container().getRestore(restoreName))).takeUntil(r -> r.status() != 202).lastOrErrorStage();
    }

    private static abstract class AbstractResourceCommand
    extends AbstractBackupCommand {
        @OptionList(description="Comma separated list of caches to include, '*' indicates all available", completer=CacheCompleter.class, name="caches")
        List<String> caches;
        @OptionList(description="Comma separated list of cache templates to include, '*' indicates all available", completer=CacheConfigurationCompleter.class, name="templates")
        List<String> templates;
        @OptionList(description="Comma separated list of counters to include, '*' indicates all available", completer=CounterCompleter.class, name="counters")
        List<String> counters;
        @OptionList(description="Comma separated list of proto schemas to include, '*' indicates all available", completer=SchemaCompleter.class, name="proto-schemas")
        List<String> protoSchemas;
        @OptionList(description="Comma separated list of tasks to include, '*' indicates all available", completer=TaskCompleter.class, name="tasks")
        List<String> tasks;

        private AbstractResourceCommand() {
        }

        public Map<String, List<String>> createResourceMap() {
            HashMap<String, List<String>> resourceMap = new HashMap<String, List<String>>();
            if (this.caches != null) {
                resourceMap.put(Backup.CACHES, this.caches);
            }
            if (this.templates != null) {
                resourceMap.put(Backup.TEMPLATES, this.templates);
            }
            if (this.counters != null) {
                resourceMap.put(Backup.COUNTERS, this.counters);
            }
            if (this.protoSchemas != null) {
                resourceMap.put(Backup.PROTO_SCHEMAS, this.protoSchemas);
            }
            if (this.tasks != null) {
                resourceMap.put(Backup.TASKS, this.tasks);
            }
            return resourceMap;
        }
    }

    private static abstract class AbstractBackupCommand
    extends RestCliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        private AbstractBackupCommand() {
        }

        @Override
        public boolean isHelp() {
            return this.help;
        }
    }

    @CommandDefinition(name="restore", description="Restore a backup", activator=ConnectionActivator.class)
    public static class Restore
    extends AbstractResourceCommand {
        @Argument(description="The path of the backup file ", completer=FileOptionCompleter.class, required=true)
        Resource path;
        @Option(shortName=110, description="Defines a name for the restore request.")
        String name;
        @Option(shortName=117, description="Indicates that the path is a local file which must be uploaded to the server", hasValue=false, name="upload-backup")
        boolean upload;

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            Map resources = this.createResourceMap();
            String restoreName = this.name != null ? this.name : String.format("%s-%tY%2$tm%2$td%2$tH%2$tM%2$tS", Version.getBrandName(), LocalDateTime.now());
            String container = invocation.getContext().getConnection().getActiveContainer().getName();
            if (this.upload) {
                invocation.printf("Uploading backup '%s' and restoring%n", this.path.getAbsolutePath());
                File file = new File(this.path.getAbsolutePath());
                return client.container().restore(restoreName, file, resources).thenCompose(rsp -> Backup.pollRestore(restoreName, container, client, rsp));
            }
            invocation.printf("Restoring from backup '%s'%n", this.path.getAbsolutePath());
            return client.container().restore(restoreName, this.path.getAbsolutePath(), resources).thenCompose(rsp -> Backup.pollRestore(restoreName, container, client, rsp));
        }
    }

    @CommandDefinition(name="create", description="Create a backup on the server", activator=ConnectionActivator.class)
    public static class Create
    extends AbstractResourceCommand {
        @Option(shortName=100, description="The directory on the server to be used for creating and storing the backup")
        String dir;
        @Option(shortName=110, description="The name of the backup")
        String name;

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            String backupName = this.name != null ? this.name : String.format("%s-%tY%2$tm%2$td%2$tH%2$tM%2$tS", Version.getBrandName(), LocalDateTime.now());
            invocation.printf("Creating backup '%s'%n", backupName);
            return client.container().createBackup(backupName, this.dir, this.createResourceMap());
        }
    }

    @CommandDefinition(name="ls", description="List all backups on the server", activator=ConnectionActivator.class)
    public static class ListBackups
    extends AbstractBackupCommand {
        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            String container = invocation.getContext().getConnection().getActiveContainer().getName();
            return client.container().getBackupNames();
        }
    }

    @CommandDefinition(name="get", description="Get a backup from the server", activator=ConnectionActivator.class)
    public static class Get
    extends AbstractBackupCommand {
        public static final String NO_CONTENT = "no-content";
        @Argument(description="The name of the backup", completer=BackupCompleter.class, required=true)
        String name;
        @Option(description="No content is downloaded, but the command only returns once the backup has finished", hasValue=false, name="no-content")
        boolean noContent;

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            invocation.printf("Downloading backup %s%n", this.name);
            return Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.trampoline()).repeat(100L).flatMapSingle(Void2 -> Single.fromCompletionStage((CompletionStage)client.container().getBackup(this.name, this.noContent))).takeUntil(rsp -> rsp.status() != 202).lastOrErrorStage();
        }

        @Override
        public Connection.ResponseMode getResponseMode() {
            return this.noContent ? Connection.ResponseMode.QUIET : Connection.ResponseMode.FILE;
        }
    }

    @CommandDefinition(name="delete", description="Delete a backup on the server", activator=ConnectionActivator.class)
    public static class Delete
    extends AbstractBackupCommand {
        @Argument(description="The name of the backup", completer=BackupCompleter.class, required=true)
        String name;

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            invocation.printf("Deleting backup %s%n", this.name);
            return client.container().deleteBackup(this.name);
        }
    }
}

