/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class JsonReaderIterator
implements Iterator<Map<String, String>>,
AutoCloseable {
    private final JsonParser parser;
    private Map<String, String> row;
    private boolean eof = false;

    public JsonReaderIterator(Reader reader) throws IllegalArgumentException, IOException {
        Objects.requireNonNull(reader);
        JsonFactory jsonFactory = new JsonFactory();
        this.parser = jsonFactory.createParser(reader instanceof BufferedReader ? reader : new BufferedReader(reader));
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.row != null) {
            return true;
        }
        try {
            JsonToken token;
            do {
                if ((token = this.parser.nextToken()) == null) {
                    this.close();
                    return false;
                }
                if (token != JsonToken.START_OBJECT) continue;
                int depth = 0;
                this.row = new LinkedHashMap<String, String>();
                String key = "";
                block11: while (true) {
                    if ((token = this.parser.nextToken()) == JsonToken.END_OBJECT) {
                        if (depth == 0) {
                            return true;
                        }
                        --depth;
                        continue;
                    }
                    if (token == JsonToken.START_OBJECT) {
                        ++depth;
                        continue;
                    }
                    if (token != JsonToken.FIELD_NAME) continue;
                    String name = this.parser.currentName();
                    token = this.parser.nextToken();
                    if (token == JsonToken.START_OBJECT) {
                        key = name;
                        ++depth;
                        continue;
                    }
                    String value = this.parser.getText();
                    switch (name) {
                        case "_value": {
                            this.row.put(key, value);
                            continue block11;
                        }
                        case "_type": {
                            continue block11;
                        }
                    }
                    key = name;
                    if (value == null) continue;
                    this.row.put(key, value);
                }
            } while (token != JsonToken.VALUE_STRING);
            this.row = Map.of("", this.parser.getValueAsString());
            return true;
        }
        catch (IOException e) {
            this.close();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Map<String, String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map<String, String> currentRow = this.row;
        this.row = null;
        return currentRow;
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eof = true;
        this.row = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

