/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Immutable
public abstract class AbstractKeyOperation
extends RetryOnFailureOperation {
    private static final Log log = LogFactory.getLog(AbstractKeyOperation.class);
    protected final byte[] key;

    protected AbstractKeyOperation(TransportFactory transportFactory, byte[] key, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(transportFactory, cacheName, topologyId, flags);
        this.key = key;
    }

    @Override
    protected Transport getTransport(int retryCount) {
        if (retryCount == 0) {
            return this.transportFactory.getTransport(this.key);
        }
        return this.transportFactory.getTransport();
    }

    protected short sendKeyOperation(byte[] key, Transport transport, byte opCode, byte opRespCode) {
        long messageId = this.writeHeader(transport, opCode);
        transport.writeArray(key);
        transport.flush();
        return this.readHeaderAndValidate(transport, messageId, opRespCode);
    }

    protected byte[] returnPossiblePrevValue(Transport transport) {
        if (this.hasForceReturn(this.flags)) {
            byte[] bytes = transport.readArray();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Previous value bytes is: " + Util.printArray((byte[])bytes, (boolean)false)));
            }
            return bytes.length == 0 ? null : bytes;
        }
        return null;
    }

    private boolean hasForceReturn(Flag[] flags) {
        if (flags == null) {
            return false;
        }
        for (Flag flag : flags) {
            if (flag != Flag.FORCE_RETURN_VALUE) continue;
            return true;
        }
        return false;
    }

    protected VersionedOperationResponse returnVersionedOperationResponse(Transport transport, long messageId, byte response) {
        VersionedOperationResponse.RspCode code;
        short respStatus = this.readHeaderAndValidate(transport, messageId, response);
        if (respStatus == 0) {
            code = VersionedOperationResponse.RspCode.SUCCESS;
        } else if (respStatus == 1) {
            code = VersionedOperationResponse.RspCode.MODIFIED_KEY;
        } else if (respStatus == 2) {
            code = VersionedOperationResponse.RspCode.NO_SUCH_KEY;
        } else {
            throw new IllegalStateException("Unknown response status: " + Integer.toHexString(respStatus));
        }
        byte[] prevValue = this.returnPossiblePrevValue(transport);
        return new VersionedOperationResponse(prevValue, code);
    }
}

