/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.HotRodTimeoutException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Immutable
public abstract class HotRodOperation
implements HotRodConstants {
    static final AtomicLong MSG_ID = new AtomicLong();
    private static final Log log = LogFactory.getLog(HotRodOperation.class);
    protected final Flag[] flags;
    protected final byte[] cacheName;
    protected final AtomicInteger topologyId;
    private static final byte NO_TX = 0;
    private static final byte XA_TX = 1;

    protected HotRodOperation(Flag[] flags, byte[] cacheName, AtomicInteger topologyId) {
        this.flags = flags;
        this.cacheName = cacheName;
        this.topologyId = topologyId;
    }

    public abstract Object execute();

    protected final long writeHeader(Transport transport, short operationCode) {
        transport.writeByte((short)160);
        long messageId = MSG_ID.incrementAndGet();
        transport.writeVLong(messageId);
        transport.writeByte((short)10);
        transport.writeByte(operationCode);
        transport.writeArray(this.cacheName);
        int flagInt = 0;
        if (this.flags != null) {
            for (Flag flag : this.flags) {
                flagInt = flag.getFlagInt() | flagInt;
            }
        }
        transport.writeVInt(flagInt);
        transport.writeByte((short)3);
        transport.writeVInt(this.topologyId.get());
        transport.writeByte((short)0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("wrote header for message " + messageId + ". Operation code: " + operationCode + ". Flags: " + Integer.toHexString(flagInt)));
        }
        return messageId;
    }

    protected short readHeaderAndValidate(Transport transport, long messageId, short opRespCode) {
        short receivedOpCode;
        short magic = transport.readByte();
        if (magic != 161) {
            String message = "Invalid magic number. Expected " + Integer.toHexString(161) + " and received " + Integer.toHexString(magic);
            log.error((Object)message);
            throw new InvalidResponseException(message);
        }
        long receivedMessageId = transport.readVLong();
        if (receivedMessageId != messageId) {
            String message = "Invalid message id. Expected " + Long.toHexString(messageId) + " and received " + Long.toHexString(receivedMessageId);
            log.error((Object)message);
            throw new InvalidResponseException(message);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received response for message id: " + receivedMessageId));
        }
        if ((receivedOpCode = transport.readByte()) != opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport.readByte(), messageId, transport);
                throw new IllegalStateException("Error expected! (i.e. exception in the prev statement)");
            }
            throw new InvalidResponseException("Invalid response operation. Expected " + Integer.toHexString(opRespCode) + " and received " + Integer.toHexString(receivedOpCode));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received operation code is: " + receivedOpCode));
        }
        short status = transport.readByte();
        this.checkForErrorsInResponseStatus(status, messageId, transport);
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, this.topologyId);
        }
        return status;
    }

    protected void checkForErrorsInResponseStatus(short status, long messageId, Transport transport) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received operation status: " + status));
        }
        switch (status) {
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                String msgFromServer = transport.readString();
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Error status received from the server:" + msgFromServer + " for message id " + messageId));
                }
                throw new HotRodClientException(msgFromServer, messageId, status);
            }
            case 134: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"timeout message received from the server");
                }
                throw new HotRodTimeoutException();
            }
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status: " + Integer.toHexString(status));
            }
        }
    }

    private void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId) {
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFunctionVersion = transport.readByte();
        int hashSpace = transport.readVInt();
        int clusterSize = transport.readVInt();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Topology change request: newTopologyId=" + newTopologyId + ", numKeyOwners=" + numKeyOwners + ", hashFunctionVersion=" + hashFunctionVersion + ", hashSpaceSize=" + hashSpace + ", clusterSize=" + clusterSize));
        }
        LinkedHashMap<InetSocketAddress, Integer> servers2HashCode = new LinkedHashMap<InetSocketAddress, Integer>();
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Server read:" + host + ":" + port));
            }
            int hashCode = transport.read4ByteInt();
            servers2HashCode.put(new InetSocketAddress(host, port), hashCode);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Hash code is: " + hashCode));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("New topology: " + servers2HashCode));
        }
        transport.getTransportFactory().updateServers(servers2HashCode.keySet());
        if (hashFunctionVersion == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Not using a consistent hash function (hash function version == 0).");
            }
        } else {
            transport.getTransportFactory().updateHashFunction(servers2HashCode, numKeyOwners, hashFunctionVersion, hashSpace);
        }
    }
}

