/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class BulkGetOperation
extends RetryOnFailureOperation {
    private final int entryCount;

    public BulkGetOperation(TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, Flag[] flags, int entryCount) {
        super(transportFactory, cacheName, topologyId, flags);
        this.entryCount = entryCount;
    }

    @Override
    protected Transport getTransport(int retryCount) {
        return this.transportFactory.getTransport();
    }

    @Override
    protected Object executeOperation(Transport transport) {
        long messageId = this.writeHeader(transport, (short)25);
        transport.writeVInt(this.entryCount);
        transport.flush();
        this.readHeaderAndValidate(transport, messageId, (short)26);
        HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>();
        while (transport.readByte() == 1) {
            result.put(transport.readArray(), transport.readArray());
        }
        return result;
    }
}

