/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class RoundRobinBalancingStrategy
implements RequestBalancingStrategy {
    private static final Log log = LogFactory.getLog(RoundRobinBalancingStrategy.class);
    private int index = 0;
    private InetSocketAddress[] servers;

    @Override
    public void setServers(Collection<InetSocketAddress> servers) {
        this.servers = servers.toArray(new InetSocketAddress[servers.size()]);
        if (this.index >= this.servers.length) {
            this.index = 0;
        }
        if (log.isTraceEnabled()) {
            log.tracef("New server list is: " + Arrays.toString(this.servers), new Object[0]);
        }
    }

    @Override
    public InetSocketAddress nextServer() {
        InetSocketAddress server = this.getServerByIndex(this.index++);
        if (this.index >= this.servers.length) {
            this.index = 0;
        }
        return server;
    }

    public InetSocketAddress dryRunNextServer() {
        return this.getServerByIndex(this.index);
    }

    private InetSocketAddress getServerByIndex(int pos) {
        InetSocketAddress server = this.servers[pos];
        if (log.isTraceEnabled()) {
            log.tracef("Returning server: %s", (Object)server);
        }
        return server;
    }

    public InetSocketAddress[] getServers() {
        return this.servers;
    }

    public int getNextPosition() {
        return this.index;
    }
}

