/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;

public class TransactionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TransactionConfiguration> {
    private static final Log log = LogFactory.getLog(TransactionConfigurationBuilder.class, Log.class);
    private TransactionMode transactionMode = TransactionMode.NONE;
    private TransactionManagerLookup transactionManagerLookup = TransactionConfigurationBuilder.defaultTransactionManagerLookup();

    TransactionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public static TransactionManagerLookup defaultTransactionManagerLookup() {
        return GenericTransactionManagerLookup.getInstance();
    }

    public TransactionConfigurationBuilder transactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transactionManagerLookup = transactionManagerLookup;
        return this;
    }

    public TransactionConfigurationBuilder transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    public void validate() {
        if (this.transactionMode == null) {
            throw log.invalidTransactionMode();
        }
        if (this.transactionManagerLookup == null) {
            throw log.invalidTransactionManagerLookup();
        }
    }

    public TransactionConfiguration create() {
        return new TransactionConfiguration(this.transactionMode, this.transactionManagerLookup);
    }

    public Builder<?> read(TransactionConfiguration template) {
        this.transactionManagerLookup = template.transactionManagerLookup();
        this.transactionMode = template.transactionMode();
        return this;
    }

    void withTransactionProperties(Properties properties) {
        ConfigurationProperties cp = new ConfigurationProperties(properties);
        this.transactionMode = cp.getTransactionMode();
        this.transactionManagerLookup = (TransactionManagerLookup)Util.getInstance((Class)Util.loadClass((String)cp.getTransactionManagerLookup(), (ClassLoader)this.builder.classLoader()));
    }
}

