/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event.impl;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.client.hotrod.event.impl.EventDispatcher;
import org.infinispan.client.hotrod.event.impl.ReconnectTask;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;

public class ClientListenerNotifier {
    private static final Log log = LogFactory.getLog(ClientListenerNotifier.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int RECONNECT_PERIOD = 5000;
    private final ConcurrentMap<WrappedByteArray, EventDispatcher<?>> dispatchers = new ConcurrentHashMap();
    private final ScheduledThreadPoolExecutor reconnectExecutor = new ScheduledThreadPoolExecutor(1);
    private final Codec codec;
    private final Marshaller marshaller;
    private final ChannelFactory channelFactory;
    private final ClassWhiteList whitelist;

    public ClientListenerNotifier(Codec codec, Marshaller marshaller, ChannelFactory channelFactory, ClassWhiteList whitelist) {
        this.codec = codec;
        this.marshaller = marshaller;
        this.channelFactory = channelFactory;
        this.whitelist = whitelist;
        this.reconnectExecutor.setKeepAliveTime(10000L, TimeUnit.MILLISECONDS);
        this.reconnectExecutor.allowCoreThreadTimeOut(true);
    }

    public Marshaller marshaller() {
        return this.marshaller;
    }

    public void addDispatcher(EventDispatcher<?> dispatcher) {
        this.dispatchers.put(new WrappedByteArray(dispatcher.listenerId), dispatcher);
        if (trace) {
            log.tracef("Add dispatcher %s for client listener with id %s, for listener %s", dispatcher, Util.printArray((byte[])dispatcher.listenerId), dispatcher.listener);
        }
    }

    public void failoverListeners(Set<SocketAddress> failedServers) {
        ArrayList failoverListenerIds = new ArrayList();
        for (Map.Entry entry : this.dispatchers.entrySet()) {
            EventDispatcher dispatcher = (EventDispatcher)entry.getValue();
            if (!failedServers.contains(dispatcher.address())) continue;
            failoverListenerIds.add(entry.getKey());
        }
        if (trace && failoverListenerIds.isEmpty()) {
            log.tracef("No event listeners registered in failed servers: %s", failedServers);
        }
        failoverListenerIds.forEach(wrapped -> this.failoverClientListener(wrapped.getBytes()));
    }

    public void failoverClientListener(byte[] listenerId) {
        EventDispatcher<?> dispatcher = this.removeClientListener(listenerId);
        if (dispatcher == null) {
            return;
        }
        dispatcher.invokeFailoverEvent();
        dispatcher.executeFailover().whenComplete((status, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof RejectedExecutionException) {
                    log.debug("Client listener failover rejected, not retrying", (Throwable)throwable);
                } else {
                    log.debug("Unable to failover client listener, so ignore connection reset", (Throwable)throwable);
                    ReconnectTask reconnectTask = new ReconnectTask(dispatcher);
                    ScheduledFuture<?> scheduledFuture = this.reconnectExecutor.scheduleAtFixedRate(reconnectTask, 5000L, 5000L, TimeUnit.MILLISECONDS);
                    reconnectTask.setCancellationFuture(scheduledFuture);
                }
            } else if (trace) {
                log.tracef("Fallback listener id %s from a failed server %s", Util.printArray((byte[])listenerId), dispatcher.address());
            }
        });
    }

    public void startClientListener(byte[] listenerId) {
        EventDispatcher eventDispatcher = (EventDispatcher)this.dispatchers.get(new WrappedByteArray(listenerId));
        eventDispatcher.start();
    }

    public EventDispatcher<?> removeClientListener(byte[] listenerId) {
        return this.removeClientListener(new WrappedByteArray(listenerId));
    }

    private EventDispatcher<?> removeClientListener(WrappedByteArray listenerId) {
        EventDispatcher dispatcher = (EventDispatcher)this.dispatchers.remove(listenerId);
        if (dispatcher == null) {
            if (trace) {
                log.tracef("Client listener %s not present (removed concurrently?)", Util.printArray((byte[])listenerId.getBytes()));
            }
        } else {
            dispatcher.stop();
        }
        if (trace) {
            log.tracef("Remove client listener with id %s", Util.printArray((byte[])listenerId.getBytes()));
        }
        return dispatcher;
    }

    public byte[] findListenerId(Object listener) {
        for (EventDispatcher dispatcher : this.dispatchers.values()) {
            if (!dispatcher.listener.equals(listener)) continue;
            return dispatcher.listenerId;
        }
        return null;
    }

    public boolean isListenerConnected(byte[] listenerId) {
        EventDispatcher dispatcher = (EventDispatcher)this.dispatchers.get(new WrappedByteArray(listenerId));
        return dispatcher != null && dispatcher.isRunning();
    }

    public SocketAddress findAddress(byte[] listenerId) {
        EventDispatcher dispatcher = (EventDispatcher)this.dispatchers.get(new WrappedByteArray(listenerId));
        if (dispatcher != null) {
            return dispatcher.address();
        }
        return null;
    }

    public Set<Object> getListeners(String cacheName) {
        HashSet<Object> ret = new HashSet<Object>(this.dispatchers.size());
        for (EventDispatcher dispatcher : this.dispatchers.values()) {
            if (!dispatcher.cacheName.equals(cacheName)) continue;
            ret.add(dispatcher.listener);
        }
        return ret;
    }

    public void stop() {
        for (WrappedByteArray listenerId : this.dispatchers.keySet()) {
            if (trace) {
                log.tracef("Remote cache manager stopping, remove client listener id %s", Util.printArray((byte[])listenerId.getBytes()));
            }
            this.removeClientListener(listenerId);
        }
    }

    public <T> void invokeEvent(byte[] listenerId, T event) {
        EventDispatcher eventDispatcher = (EventDispatcher)this.dispatchers.get(new WrappedByteArray(listenerId));
        if (eventDispatcher == null) {
            throw log.unexpectedListenerId(Util.printArray((byte[])listenerId));
        }
        eventDispatcher.invokeEvent(event);
    }

    public DataFormat getCacheDataFormat(byte[] listenerId) {
        ClientEventDispatcher clientEventDispatcher = (ClientEventDispatcher)this.dispatchers.get(new WrappedByteArray(listenerId));
        if (clientEventDispatcher == null) {
            throw log.unexpectedListenerId(Util.printArray((byte[])listenerId));
        }
        return clientEventDispatcher.getDataFormat();
    }

    public Codec codec() {
        return this.codec;
    }

    public ClassWhiteList whitelist() {
        return this.whitelist;
    }

    public ChannelFactory channelFactory() {
        return this.channelFactory;
    }
}

