/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSecurityClient;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.commons.dataconversion.MediaType;

public class RestSecurityClientJDK
implements RestSecurityClient {
    private final RestRawClientJDK client;
    private final String path;

    public RestSecurityClientJDK(RestRawClientJDK restClient) {
        this.client = restClient;
        this.path = restClient.getConfiguration().contextPath() + "/v2/security";
    }

    @Override
    public CompletionStage<RestResponse> listPrincipals() {
        return this.client.get(this.path + "/principals");
    }

    @Override
    public CompletionStage<RestResponse> listPrincipals(boolean detailed) {
        return this.client.get(this.path + "/principals" + (detailed ? "?action=detailed" : ""));
    }

    @Override
    public CompletionStage<RestResponse> listUsers() {
        return this.client.get(this.path + "/users");
    }

    @Override
    public CompletionStage<RestResponse> listRoles() {
        return this.client.get(this.path + "/roles");
    }

    @Override
    public CompletionStage<RestResponse> listRoles(boolean detailed) {
        if (detailed) {
            return this.client.get(this.path + "/roles?action=detailed");
        }
        return this.listRoles();
    }

    @Override
    public CompletionStage<RestResponse> listRoles(String principal) {
        Objects.requireNonNull(principal, "principal");
        return this.client.get(this.path + "/roles/" + principal);
    }

    @Override
    public CompletionStage<RestResponse> grant(String principal, List<String> roles) {
        return this.modifyAcl(principal, roles, "grant");
    }

    @Override
    public CompletionStage<RestResponse> deny(String principal, List<String> roles) {
        return this.modifyAcl(principal, roles, "deny");
    }

    private CompletionStage<RestResponse> modifyAcl(String principal, List<String> roles, String action) {
        StringBuilder sb = new StringBuilder(this.path);
        sb.append("/roles/").append(principal).append("?action=").append(action);
        for (String role : roles) {
            sb.append("&role=").append(role);
        }
        return this.client.put(sb.toString());
    }

    @Override
    public CompletionStage<RestResponse> flushCache() {
        return this.client.post(this.path + "/cache?action=flush");
    }

    @Override
    public CompletionStage<RestResponse> createRole(String name, String description, List<String> permissions) {
        return this.createOrUpdateRole(name, description, permissions, true);
    }

    @Override
    public CompletionStage<RestResponse> updateRole(String name, String description, List<String> permissions) {
        return this.createOrUpdateRole(name, description, permissions, false);
    }

    private CompletionStage<RestResponse> createOrUpdateRole(String name, String description, List<String> permissions, boolean create) {
        StringBuilder sb = new StringBuilder(this.path);
        sb.append("/permissions/").append(name).append('?');
        for (int i = 0; i < permissions.size(); ++i) {
            if (i > 0) {
                sb.append('&');
            }
            sb.append("permission=").append(permissions.get(i));
        }
        RestEntity entity = description != null ? RestEntity.create(MediaType.TEXT_PLAIN, description) : RestEntity.EMPTY;
        return create ? this.client.post(sb.toString(), entity) : this.client.put(sb.toString(), entity);
    }

    @Override
    public CompletionStage<RestResponse> removeRole(String name) {
        return this.client.delete(this.path + "/permissions/" + name);
    }

    @Override
    public CompletionStage<RestResponse> describeRole(String name) {
        return this.client.get(this.path + "/permissions/" + name);
    }
}

