/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk.auth;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.jdk.auth.AuthenticationException;
import org.infinispan.client.rest.impl.jdk.auth.HttpAuthenticator;

public class DigestAuthenticator
extends HttpAuthenticator {
    private static final Pattern HEADER_REGEX = Pattern.compile("\\s([a-z]+)=\"?([\\p{Alnum}\\s\\t!#$%&'()*+\\-./:;<=>?@\\[\\\\\\]^_`{|}~]+)\"?");
    private static final String CREDENTIAL_CHARSET = "http.auth.credential-charset";
    private static final int QOP_UNKNOWN = -1;
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final Charset credentialsCharset = StandardCharsets.US_ASCII;
    private String lastNonce;
    private long nonceCount;
    private String cnonce;

    public DigestAuthenticator(HttpClient client, AuthenticationConfiguration configuration) {
        super(client, configuration);
    }

    @Override
    public <T> CompletionStage<HttpResponse<T>> authenticate(HttpResponse<T> response, HttpResponse.BodyHandler<?> bodyHandler) {
        String header = DigestAuthenticator.findHeader(response, "www-authenticate", "Digest");
        Matcher matcher = HEADER_REGEX.matcher(header);
        ConcurrentHashMap<String, String> parameters = new ConcurrentHashMap<String, String>(8);
        while (matcher.find()) {
            parameters.put(matcher.group(1), matcher.group(2));
        }
        String nonce = (String)parameters.get("nonce");
        if (nonce == null) {
            throw new AuthenticationException("Missing nonce in challenge header: " + header);
        }
        String realm = (String)parameters.get("realm");
        if (realm == null) {
            return null;
        }
        boolean isStale = Boolean.parseBoolean((String)parameters.get("stale"));
        HttpRequest request = response.request();
        if (this.havePreviousDigestAuthorizationAndShouldAbort(request, isStale)) {
            return null;
        }
        parameters.put("methodname", request.method());
        parameters.put("uri", this.digestUri(request.uri()));
        parameters.computeIfAbsent("charset", k -> this.getCredentialsCharset(request));
        HttpRequest.Builder newRequest = DigestAuthenticator.copyRequest(request).header("Authorization", this.createDigestHeader(request, parameters));
        return this.client.sendAsync(newRequest.build(), bodyHandler);
    }

    private String digestUri(URI uri) {
        String query = uri.getQuery();
        if (query == null || query.isEmpty()) {
            return uri.getRawPath();
        }
        return uri.getRawPath() + "?" + uri.getRawQuery();
    }

    public static String createCnonce() {
        SecureRandom rnd = new SecureRandom();
        byte[] tmp = new byte[8];
        rnd.nextBytes(tmp);
        return DigestAuthenticator.encode(tmp);
    }

    static String encode(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    private boolean havePreviousDigestAuthorizationAndShouldAbort(HttpRequest request, boolean isStale) {
        Optional<String> previousAuthorizationHeader = request.headers().firstValue("Authorization");
        if (previousAuthorizationHeader.isPresent() && previousAuthorizationHeader.get().startsWith("Digest")) {
            return !isStale;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized String createDigestHeader(HttpRequest request, Map<String, String> parameters) throws AuthenticationException {
        String digestValue;
        String s2;
        String s1;
        MessageDigest digester;
        String uri = parameters.get("uri");
        String realm = parameters.get("realm");
        String nonce = parameters.get("nonce");
        String opaque = parameters.get("opaque");
        String method = parameters.get("methodname");
        String algorithm = parameters.getOrDefault("algorithm", "MD5");
        HashSet<String> qopSet = new HashSet<String>(8);
        int qop = -1;
        String qopList = parameters.get("qop");
        if (qopList != null) {
            StringTokenizer tok = new StringTokenizer(qopList, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                qopSet.add(variant.toLowerCase(Locale.US));
            }
            if (request.bodyPublisher().isPresent() && qopSet.contains("auth-int")) {
                qop = 1;
            } else if (qopSet.contains("auth")) {
                qop = 2;
            }
        } else {
            qop = 0;
        }
        if (qop == -1) {
            throw new AuthenticationException("None of the qop methods is supported: " + qopList);
        }
        String charset = parameters.getOrDefault("charset", StandardCharsets.ISO_8859_1.name());
        String digAlg = algorithm;
        if ("MD5-sess".equalsIgnoreCase(digAlg)) {
            digAlg = "MD5";
        }
        try {
            digester = MessageDigest.getInstance(digAlg);
        }
        catch (Exception ex) {
            throw new AuthenticationException("Unsuppported digest algorithm: " + digAlg, ex);
        }
        String uname = this.configuration.username();
        String pwd = new String(this.configuration.password());
        if (nonce.equals(this.lastNonce)) {
            ++this.nonceCount;
        } else {
            this.nonceCount = 1L;
            this.cnonce = null;
            this.lastNonce = nonce;
        }
        StringBuilder sb = new StringBuilder(256);
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%08x", this.nonceCount);
        formatter.close();
        String nc = sb.toString();
        if (this.cnonce == null) {
            this.cnonce = DigestAuthenticator.createCnonce();
        }
        if ("MD5-sess".equalsIgnoreCase(algorithm)) {
            sb.setLength(0);
            sb.append(uname).append(':').append(realm).append(':').append(pwd);
            String checksum = DigestAuthenticator.encode(digester.digest(this.getBytes(sb.toString(), charset)));
            sb.setLength(0);
            sb.append(checksum).append(':').append(nonce).append(':').append(this.cnonce);
            s1 = sb.toString();
        } else {
            sb.setLength(0);
            sb.append(uname).append(':').append(realm).append(':').append(pwd);
            s1 = sb.toString();
        }
        String hasha1 = DigestAuthenticator.encode(digester.digest(this.getBytes(s1, charset)));
        if (qop == 2) {
            s2 = method + ":" + uri;
        } else if (qop == 1) {
            if (request.bodyPublisher().isPresent()) {
                if (!qopSet.contains("auth")) throw new AuthenticationException("Qop auth-int cannot be used with a non-repeatable entity");
                qop = 2;
                s2 = method + ":" + uri;
            } else {
                digester.reset();
                s2 = method + ":" + uri + ":" + DigestAuthenticator.encode(digester.digest());
            }
        } else {
            s2 = method + ":" + uri;
        }
        String h2 = DigestAuthenticator.encode(digester.digest(this.getBytes(s2, charset)));
        if (qop == 0) {
            sb.setLength(0);
            sb.append(hasha1).append(':').append(nonce).append(':').append(h2);
            digestValue = sb.toString();
        } else {
            sb.setLength(0);
            sb.append(hasha1).append(':').append(nonce).append(':').append(nc).append(':').append(this.cnonce).append(':').append(qop == 1 ? "auth-int" : "auth").append(':').append(h2);
            digestValue = sb.toString();
        }
        String digest = DigestAuthenticator.encode(digester.digest(DigestAuthenticator.getAsciiBytes(digestValue)));
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("Digest username=\"");
        buffer.append(uname);
        buffer.append("\", realm=\"");
        buffer.append(realm);
        buffer.append("\", nonce=\"");
        buffer.append(nonce);
        buffer.append("\", uri=\"");
        buffer.append(uri);
        buffer.append("\", response=\"");
        buffer.append(digest);
        buffer.append("\", ");
        if (qop != 0) {
            buffer.append("qop=");
            buffer.append(qop == 1 ? "auth-int" : "auth");
            buffer.append(", nc=");
            buffer.append(nc);
            buffer.append(", cnonce=\"");
            buffer.append(this.cnonce);
            buffer.append("\", ");
        }
        buffer.append("algorithm=");
        buffer.append(algorithm);
        if (opaque == null) return buffer.toString();
        buffer.append(", opaque=\"");
        buffer.append(opaque);
        buffer.append('\"');
        return buffer.toString();
    }

    private Charset getCredentialsCharset() {
        return this.credentialsCharset;
    }

    private String getCredentialsCharset(HttpRequest request) {
        List<String> charset = request.headers().allValues(CREDENTIAL_CHARSET);
        if (charset.isEmpty()) {
            return this.getCredentialsCharset().name();
        }
        return charset.get(0);
    }

    private byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    private static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return data.getBytes(StandardCharsets.US_ASCII);
    }
}

