/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.interceptor;

import java.util.Collection;
import java.util.EnumSet;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;
import org.infinispan.counter.logging.Log;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.metadata.Metadata;

public class CounterInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(CounterInterceptor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Collection<Flag> FLAGS_TO_SKIP_PERSISTENCE = EnumSet.of(Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE);

    private static ConfigurationMetadata extract(Metadata metadata) {
        return metadata instanceof MetaParamsInternalMetadata ? (ConfigurationMetadata)((MetaParamsInternalMetadata)metadata).findMetaParam(ConfigurationMetadata.class).orElse(null) : null;
    }

    private static boolean isVolatile(ConfigurationMetadata metadata) {
        return metadata != null && metadata.get().storage() == Storage.VOLATILE;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        ConfigurationMetadata entryMetadata = entry == null ? null : CounterInterceptor.extract(entry.getMetadata());
        ConfigurationMetadata commandMetadata = CounterInterceptor.extract(command.getMetadata());
        if (CounterInterceptor.isVolatile(entryMetadata) || CounterInterceptor.isVolatile(commandMetadata)) {
            if (trace) {
                log.tracef("Setting skip persistence for %s", command.getKey());
            }
            command.setFlagsBitSet(EnumUtil.setEnums((long)command.getFlagsBitSet(), FLAGS_TO_SKIP_PERSISTENCE));
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }
}

