/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.executors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class BlockingThreadPoolExecutorFactory
implements ThreadPoolExecutorFactory {
    private static final Log log = LogFactory.getLog(BlockingThreadPoolExecutorFactory.class);
    private final int maxThreads;
    private final int coreThreads;
    private final int queueLength;
    private final long keepAlive;

    public BlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
        this.maxThreads = maxThreads;
        this.coreThreads = coreThreads;
        this.queueLength = queueLength;
        this.keepAlive = keepAlive;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public int coreThreads() {
        return this.coreThreads;
    }

    public int queueLength() {
        return this.queueLength;
    }

    public long keepAlive() {
        return this.keepAlive;
    }

    public ExecutorService createExecutor(ThreadFactory threadFactory) {
        BlockingQueue queue = (BlockingQueue)((Object)(this.queueLength == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.queueLength)));
        return new ThreadPoolExecutor(this.coreThreads, this.maxThreads, this.keepAlive, TimeUnit.MILLISECONDS, queue, threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void validate() {
        if (this.coreThreads < 0) {
            throw log.illegalValueThreadPoolParameter("core threads", ">= 0");
        }
        if (this.maxThreads <= 0) {
            throw log.illegalValueThreadPoolParameter("max threads", "> 0");
        }
        if (this.maxThreads < this.coreThreads) {
            throw log.illegalValueThreadPoolParameter("max threads and core threads", "max threads >= core threads");
        }
        if (this.keepAlive < 0L) {
            throw log.illegalValueThreadPoolParameter("keep alive time", ">= 0");
        }
        if (this.queueLength < 0) {
            throw log.illegalValueThreadPoolParameter("work queue length", ">= 0");
        }
    }

    public String toString() {
        return "BlockingThreadPoolExecutorFactory{maxThreads=" + this.maxThreads + ", coreThreads=" + this.coreThreads + ", queueLength=" + this.queueLength + ", keepAlive=" + this.keepAlive + '}';
    }

    public static BlockingThreadPoolExecutorFactory create(int maxThreads, int queueSize) {
        int coreThreads = queueSize == 0 ? 1 : maxThreads;
        return new BlockingThreadPoolExecutorFactory(maxThreads, coreThreads, queueSize, 60000L);
    }
}

