/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall.jboss;

import java.io.IOException;
import java.util.List;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.commons.marshall.jboss.DefaultContextClassResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Unmarshaller;

public final class GenericJBossMarshaller
extends AbstractJBossMarshaller {
    public GenericJBossMarshaller() {
        this.baseCfg.setClassResolver((ClassResolver)new DefaultContextClassResolver(this.getClass().getClassLoader()));
    }

    public GenericJBossMarshaller(ClassLoader classLoader) {
        this.baseCfg.setClassResolver((ClassResolver)new DefaultContextClassResolver(classLoader != null ? classLoader : this.getClass().getClassLoader()));
    }

    public GenericJBossMarshaller(List<String> whitelist) {
        this.baseCfg.setClassResolver((ClassResolver)new CheckedClassResolver(whitelist, this.getClass().getClassLoader()));
    }

    private static final class CheckedClassResolver
    extends DefaultContextClassResolver {
        private final List<String> whitelist;

        CheckedClassResolver(List<String> whitelist, ClassLoader defaultClassLoader) {
            super(defaultClassLoader);
            this.whitelist = whitelist;
        }

        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            boolean safeClass = MarshallUtil.isSafeClass(name, this.whitelist);
            if (!safeClass) {
                throw AbstractJBossMarshaller.log.classNotInWhitelist(name);
            }
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }
    }
}

