/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;

public class ReadOnlyManyCommand<K, V, R>
extends AbstractTopologyAffectedCommand
implements LocalCommand {
    public static final int COMMAND_ID = 63;
    protected Collection<?> keys;
    protected Function<EntryView.ReadEntryView<K, V>, R> f;
    protected Params params;
    protected DataConversion keyDataConversion;
    protected DataConversion valueDataConversion;

    public ReadOnlyManyCommand(Collection<?> keys, Function<EntryView.ReadEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        this.keys = keys;
        this.f = f;
        this.params = params;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.setFlagsBitSet(params.toFlagsBitSet());
        this.init(componentRegistry);
    }

    public ReadOnlyManyCommand() {
    }

    public ReadOnlyManyCommand(ReadOnlyManyCommand c) {
        this.keys = c.keys;
        this.f = c.f;
        this.params = c.params;
        this.setFlagsBitSet(c.getFlagsBitSet());
        this.keyDataConversion = c.keyDataConversion;
        this.valueDataConversion = c.valueDataConversion;
    }

    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
    }

    public Collection<?> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<?> keys) {
        this.keys = keys;
    }

    public final ReadOnlyManyCommand<K, V, R> withKeys(Collection<?> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 63;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(this.f);
        Params.writeObject(output, this.params);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.f = (Function)input.readObject();
        this.params = Params.readObject(input);
        this.setFlagsBitSet(this.params.toFlagsBitSet());
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyManyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    public Params getParams() {
        return this.params;
    }

    public Function<EntryView.ReadEntryView<K, V>, R> getFunction() {
        return this.f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOnlyManyCommand{");
        sb.append(", keys=").append(this.keys);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }
}

