/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.PostStart;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scopes;

public class ComponentMetadata
implements Serializable {
    private static final long serialVersionUID = 865000096028875386L;
    private static final InjectFieldMetadata[] EMPTY_INJECT_FIELDS = new InjectFieldMetadata[0];
    public static final InjectMethodMetadata[] EMPTY_INJECT_METHODS = new InjectMethodMetadata[0];
    public static final PrioritizedMethodMetadata[] EMPTY_PRIORITIZED_METHODS = new PrioritizedMethodMetadata[0];
    private String name;
    private transient Map<String, String> dependencies;
    private InjectFieldMetadata[] injectFields;
    private InjectMethodMetadata[] injectMethodMetadata;
    private PrioritizedMethodMetadata[] startMethods;
    private PrioritizedMethodMetadata[] postStartMethods;
    private PrioritizedMethodMetadata[] stopMethods;
    private Scopes scope;
    private boolean survivesRestarts;
    volatile transient Class<?> clazz;

    ComponentMetadata() {
        this.survivesRestarts = true;
    }

    public ComponentMetadata(Class<?> component, List<Field> injectFields, List<Method> injectMethods, List<Method> startMethods, List<Method> postStartMethods, List<Method> stopMethods, boolean global, boolean survivesRestarts) {
        this(component, injectFields, injectMethods, startMethods, postStartMethods, stopMethods, global ? Scopes.GLOBAL : Scopes.NAMED_CACHE, survivesRestarts);
    }

    public ComponentMetadata(Class<?> component, List<Field> injectFields, List<Method> injectMethods, List<Method> startMethods, List<Method> postStartMethods, List<Method> stopMethods, Scopes scope, boolean survivesRestarts) {
        int deps;
        Annotation s;
        int i;
        this.clazz = component;
        this.name = component.getName();
        this.scope = scope;
        this.survivesRestarts = survivesRestarts;
        if (startMethods != null && !startMethods.isEmpty()) {
            this.startMethods = new PrioritizedMethodMetadata[startMethods.size()];
            i = 0;
            for (Method m : startMethods) {
                s = m.getAnnotation(Start.class);
                this.startMethods[i++] = new PrioritizedMethodMetadata(m.getName(), s.priority());
            }
        }
        if (postStartMethods != null && !postStartMethods.isEmpty()) {
            this.postStartMethods = new PrioritizedMethodMetadata[postStartMethods.size()];
            i = 0;
            for (Method m : postStartMethods) {
                s = m.getAnnotation(PostStart.class);
                this.postStartMethods[i++] = new PrioritizedMethodMetadata(m.getName(), s.priority());
            }
        }
        if (stopMethods != null && !stopMethods.isEmpty()) {
            this.stopMethods = new PrioritizedMethodMetadata[stopMethods.size()];
            i = 0;
            for (Method m : stopMethods) {
                s = m.getAnnotation(Stop.class);
                this.stopMethods[i++] = new PrioritizedMethodMetadata(m.getName(), s.priority());
            }
        }
        if ((deps = (injectFields == null ? 0 : injectFields.size()) + (injectMethods == null ? 0 : injectMethods.size())) > 0) {
            this.dependencies = new HashMap<String, String>(deps * 2);
        }
        if (injectFields != null && !injectFields.isEmpty()) {
            this.injectFields = new InjectFieldMetadata[injectFields.size()];
            int j = 0;
            for (Field f : injectFields) {
                boolean lazy = f.getType() == ComponentRef.class;
                ComponentName[] cn = (ComponentName[])f.getAnnotationsByType(ComponentName.class);
                String componentType = this.extractDependencyType(f.getType(), f.getGenericType(), lazy);
                String componentName = null;
                if (cn.length > 1) {
                    throw new IllegalStateException("Only one name expected");
                }
                if (cn.length == 1) {
                    componentName = cn[0].value();
                }
                if (componentName == null) {
                    this.dependencies.put(componentType, componentType);
                } else {
                    this.dependencies.put(componentName, componentType);
                }
                this.injectFields[j++] = new InjectFieldMetadata(f.getDeclaringClass().getName(), f.getName(), componentType, componentName, lazy);
            }
        }
        if (injectMethods != null && !injectMethods.isEmpty()) {
            this.injectMethodMetadata = new InjectMethodMetadata[injectMethods.size()];
            int j = 0;
            for (Method m : injectMethods) {
                InjectMethodMetadata injectMethodMetadata = new InjectMethodMetadata(m.getName());
                Class<?>[] parameterTypes = m.getParameterTypes();
                Type[] genericParameterTypes = m.getGenericParameterTypes();
                String[] params = new String[parameterTypes.length];
                String[] paramNames = new String[parameterTypes.length];
                boolean[] paramLazy = new boolean[parameterTypes.length];
                Annotation[][] annotations = m.getParameterAnnotations();
                for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                    String parameterType;
                    boolean lazy;
                    String componentName = this.findComponentName(annotations, i2);
                    paramLazy[i2] = lazy = parameterTypes[i2] == ComponentRef.class;
                    params[i2] = parameterType = this.extractDependencyType(parameterTypes[i2], genericParameterTypes[i2], lazy);
                    if (componentName == null) {
                        this.dependencies.put(parameterType, parameterType);
                        continue;
                    }
                    paramNames[i2] = componentName;
                    this.dependencies.put(componentName, parameterType);
                }
                injectMethodMetadata.parameters = params;
                injectMethodMetadata.parameterNames = paramNames;
                injectMethodMetadata.parameterLazy = paramLazy;
                this.injectMethodMetadata[j++] = injectMethodMetadata;
            }
        }
    }

    public String extractDependencyType(Type erasedType, Type genericType, boolean lazy) {
        Type actualComponentType;
        String componentType = lazy ? ((actualComponentType = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof ParameterizedType ? ((ParameterizedType)actualComponentType).getRawType().getTypeName() : actualComponentType.getTypeName()) : erasedType.getTypeName();
        return componentType;
    }

    private String findComponentName(Annotation[][] annotations, int position) {
        Annotation[] paramAnnotations;
        if (annotations != null && annotations.length > position && (paramAnnotations = annotations[position]) != null) {
            for (Annotation a : paramAnnotations) {
                if (!(a instanceof ComponentName)) continue;
                return ((ComponentName)a).value();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public InjectFieldMetadata[] getInjectFields() {
        return this.injectFields == null ? EMPTY_INJECT_FIELDS : this.injectFields;
    }

    public InjectMethodMetadata[] getInjectMethods() {
        if (this.injectMethodMetadata == null) {
            return EMPTY_INJECT_METHODS;
        }
        return this.injectMethodMetadata;
    }

    public PrioritizedMethodMetadata[] getStartMethods() {
        if (this.startMethods == null) {
            return EMPTY_PRIORITIZED_METHODS;
        }
        return this.startMethods;
    }

    public PrioritizedMethodMetadata[] getPostStartMethods() {
        if (this.postStartMethods == null) {
            return EMPTY_PRIORITIZED_METHODS;
        }
        return this.postStartMethods;
    }

    public PrioritizedMethodMetadata[] getStopMethods() {
        if (this.stopMethods == null) {
            return EMPTY_PRIORITIZED_METHODS;
        }
        return this.stopMethods;
    }

    public boolean isGlobalScope() {
        return this.scope == Scopes.GLOBAL;
    }

    public boolean isSurvivesRestarts() {
        return this.survivesRestarts;
    }

    public boolean isManageable() {
        return false;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public ManageableComponentMetadata toManageableComponentMetadata() {
        throw new UnsupportedOperationException("This component is not manageable!");
    }

    public String toString() {
        return "ComponentMetadata{name='" + this.name + '\'' + ", dependencies=" + this.dependencies + ", injectMethods=" + Arrays.toString(this.injectMethodMetadata) + ", startMethods=" + Arrays.toString(this.startMethods) + ", postStartMethods=" + Arrays.toString(this.postStartMethods) + ", stopMethods=" + Arrays.toString(this.stopMethods) + ", scope=" + (Object)((Object)this.scope) + ", survivesRestarts=" + this.survivesRestarts + '}';
    }

    public Scopes getScope() {
        return this.scope;
    }

    public class InjectFieldMetadata
    implements Serializable {
        private static final long serialVersionUID = 1040295625623725061L;
        private final String fieldClassName;
        private final String fieldName;
        private final String componentName;
        private final String componentType;
        private final boolean lazy;
        private transient Field field;
        private transient Class<?> componentClass;

        public InjectFieldMetadata(String fieldClassName, String fieldName, String componentType, String componentName, boolean lazy) {
            this.fieldClassName = fieldClassName;
            this.fieldName = fieldName;
            this.componentName = componentName;
            this.componentType = componentType;
            this.lazy = lazy;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public String getFieldClassName() {
            return this.fieldClassName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<?> getComponentClass() {
            return this.componentClass;
        }

        public void setComponentClass(Class<?> componentClass) {
            this.componentClass = componentClass;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getDependencyName() {
            return this.componentName != null ? this.componentName : this.componentType;
        }

        public boolean isLazy() {
            return this.lazy;
        }

        public String toString() {
            return "InjectFieldMetadata{fieldName='" + this.fieldName + '\'' + ", componentType='" + this.componentType + '\'' + ", componentName='" + this.componentName + '\'' + ", lazy=" + this.lazy + ", fieldClassName='" + this.fieldClassName + '\'' + '}';
        }
    }

    public static class InjectMethodMetadata
    implements Serializable {
        private static final long serialVersionUID = 3662286908891061057L;
        String methodName;
        transient Method method;
        String[] parameters;
        transient Class<?>[] parameterClasses;
        String[] parameterNames;
        boolean[] parameterLazy;

        private InjectMethodMetadata(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        @Deprecated
        public String getParameterName(int subscript) {
            return this.getDependencyName(subscript);
        }

        public String getDependencyName(int subscript) {
            String name = this.parameterNames == null ? null : this.parameterNames[subscript];
            return name == null ? this.parameters[subscript] : name;
        }

        public boolean isParameterNameSet(int subscript) {
            return this.parameterNames != null && this.parameterNames[subscript] != null;
        }

        public synchronized Method getMethod() {
            return this.method;
        }

        public synchronized void setMethod(Method method) {
            this.method = method;
        }

        public synchronized Class<?>[] getParameterClasses() {
            return this.parameterClasses;
        }

        public synchronized void setParameterClasses(Class<?>[] parameterClasses) {
            this.parameterClasses = parameterClasses;
        }

        public boolean getParameterLazy(int i) {
            return this.parameterLazy[i];
        }

        public String toString() {
            return this.methodName + "(" + String.join((CharSequence)", ", this.parameters) + ")";
        }
    }

    public static class PrioritizedMethodMetadata
    implements Serializable {
        private static final long serialVersionUID = 582810185700077L;
        String methodName;
        transient Method method;
        int priority;

        public PrioritizedMethodMetadata(String methodName, int priority) {
            this.methodName = methodName;
            this.priority = priority;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public int getPriority() {
            return this.priority;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.methodName);
            if (this.method != null) {
                sb.append("(");
                boolean comma = false;
                for (Class<?> paramClass : this.method.getParameterTypes()) {
                    if (comma) {
                        sb.append(", ");
                    } else {
                        comma = true;
                    }
                    sb.append(paramClass.getName());
                }
                sb.append(")");
            }
            sb.append("(priority=").append(this.priority).append(")");
            return sb.toString();
        }
    }
}

