/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CancellationService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CancellationServiceImpl
implements CancellationService {
    private static final Log log = LogFactory.getLog(CancellationServiceImpl.class);
    private final Map<UUID, Thread> commandThreadMap = new ConcurrentHashMap<UUID, Thread>();

    @Override
    public void register(Thread t, UUID id) {
        this.commandThreadMap.put(id, t);
    }

    @Override
    public void unregister(UUID id) {
        this.commandThreadMap.remove(id);
    }

    @Override
    public void cancel(UUID id) {
        Thread thread = this.commandThreadMap.get(id);
        if (thread != null) {
            log.trace("Calling interrupt on thread " + thread);
            thread.interrupt();
        } else {
            log.couldNotInterruptThread(id);
        }
    }
}

