/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.CacheContainerConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxConfigurationBuilder;
import org.infinispan.configuration.global.GlobalMetricsConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;

public class CacheContainerConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<CacheContainerConfiguration> {
    private final AttributeSet attributes = CacheContainerConfiguration.attributeDefinitionSet();
    private final GlobalMetricsConfigurationBuilder metrics;
    private final GlobalJmxConfigurationBuilder jmx;
    private final GlobalStateConfigurationBuilder globalState;
    private final TransportConfigurationBuilder transport;
    private final GlobalSecurityConfigurationBuilder security;
    private final SerializationConfigurationBuilder serialization;
    private final ShutdownConfigurationBuilder shutdown;
    private final ThreadsConfigurationBuilder threads;

    CacheContainerConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.metrics = new GlobalMetricsConfigurationBuilder(globalConfig);
        this.jmx = new GlobalJmxConfigurationBuilder(globalConfig);
        this.globalState = new GlobalStateConfigurationBuilder(globalConfig);
        this.threads = new ThreadsConfigurationBuilder(globalConfig);
        this.transport = new TransportConfigurationBuilder(globalConfig, this.threads);
        this.security = new GlobalSecurityConfigurationBuilder(globalConfig);
        this.serialization = new SerializationConfigurationBuilder(globalConfig);
        this.shutdown = new ShutdownConfigurationBuilder(globalConfig);
    }

    public CacheContainerConfigurationBuilder clusteredDefault() {
        this.transport().defaultTransport().clearProperties();
        return this;
    }

    public CacheContainerConfigurationBuilder nonClusteredDefault() {
        this.transport().transport(null).clearProperties();
        return this;
    }

    public static GlobalConfigurationBuilder defaultClusteredBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().defaultTransport();
        return builder;
    }

    public String defaultCacheName() {
        return (String)this.attributes.attribute(CacheContainerConfiguration.DEFAULT_CACHE).get();
    }

    @Override
    public GlobalMetricsConfigurationBuilder metrics() {
        return this.metrics;
    }

    @Override
    public GlobalJmxConfigurationBuilder jmx() {
        return this.jmx;
    }

    @Override
    public GlobalStateConfigurationBuilder globalState() {
        return this.globalState;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.transport;
    }

    public ThreadsConfigurationBuilder threads() {
        return this.threads;
    }

    @Override
    public ThreadPoolConfigurationBuilder asyncThreadPool() {
        return this.threads.asyncThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder expirationThreadPool() {
        return this.threads.expirationThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder persistenceThreadPool() {
        return this.threads.persistenceThreadPool();
    }

    @Override
    @Deprecated
    public ThreadPoolConfigurationBuilder stateTransferThreadPool() {
        return this.threads.stateTransferThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder listenerThreadPool() {
        return this.threads.listenerThreadPool();
    }

    @Override
    public GlobalSecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.serialization;
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.shutdown;
    }

    public CacheContainerConfigurationBuilder defaultCache(String defaultCacheName) {
        this.attributes.attribute(CacheContainerConfiguration.DEFAULT_CACHE).set((Object)defaultCacheName);
        return this;
    }

    public CacheContainerConfigurationBuilder name(String cacheManagerName) {
        this.attributes.attribute(CacheContainerConfiguration.NAME).set((Object)cacheManagerName);
        return this;
    }

    public String name() {
        return (String)this.attributes.attribute(CacheContainerConfiguration.NAME).get();
    }

    public CacheContainerConfigurationBuilder statistics(boolean statistics) {
        this.attributes.attribute(CacheContainerConfiguration.STATISTICS).set((Object)statistics);
        return this;
    }

    @Deprecated
    public CacheContainerConfigurationBuilder statistics(Boolean statistics) {
        return this.statistics((boolean)statistics);
    }

    public boolean statistics() {
        return (Boolean)this.attributes.attribute(CacheContainerConfiguration.STATISTICS).get();
    }

    CacheContainerConfigurationBuilder zeroCapacityNode(boolean zeroCapacityNode) {
        this.attributes.attribute(CacheContainerConfiguration.ZERO_CAPACITY_NODE).set((Object)zeroCapacityNode);
        return this;
    }

    public CacheContainerConfigurationBuilder asyncExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.ASYNC_EXECUTOR).set((Object)name);
        return this;
    }

    CacheContainerConfigurationBuilder listenerExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.LISTENER_EXECUTOR).set((Object)name);
        return this;
    }

    CacheContainerConfigurationBuilder expirationExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.EXPIRATION_EXECUTOR).set((Object)name);
        return this;
    }

    public CacheContainerConfigurationBuilder persistenceExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.PERSISTENCE_EXECUTOR).set((Object)name);
        return this;
    }

    @Deprecated
    public CacheContainerConfigurationBuilder stateTransferExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.STATE_TRANSFER_EXECUTOR).set((Object)name);
        return this;
    }

    public void validate() {
        ArrayList validationExceptions = new ArrayList();
        Arrays.asList(this.metrics, this.jmx, this.globalState, this.transport, this.security, this.serialization, this.shutdown, this.threads).forEach(c -> {
            try {
                ((Builder)c).validate();
            }
            catch (RuntimeException e) {
                validationExceptions.add(e);
            }
        });
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    public CacheContainerConfiguration create() {
        Attribute attribute = this.attributes.attribute(CacheContainerConfiguration.NAME);
        if (!attribute.isModified()) {
            this.name((String)attribute.getAttributeDefinition().getDefaultValue());
        }
        return new CacheContainerConfiguration(this.attributes.protect(), this.threads.create(), this.metrics.create(), this.jmx.create(), this.transport.create(), this.security.create(), this.serialization.create(), this.globalState.create(), this.shutdown.create(), this.getGlobalConfig().getFeatures());
    }

    public Builder<?> read(CacheContainerConfiguration template) {
        this.attributes.read(template.attributes());
        this.globalState.read(template.globalState());
        this.metrics.read(template.metrics());
        this.jmx.read(template.jmx());
        this.transport.read(template.transport());
        this.security.read(template.security());
        this.serialization.read(template.serialization());
        this.shutdown.read(template.shutdown());
        this.threads.read(template.threads());
        return this;
    }
}

