/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import net.jcip.annotations.GuardedBy;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class TriangleOrderManager {
    private static final Log log = LogFactory.getLog(TriangleOrderManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private final TriangleSequencer[] sequencers;
    @Inject
    DistributionManager distributionManager;

    public TriangleOrderManager(int segments) {
        TriangleSequencer[] triangleSequencers = new TriangleSequencer[segments];
        for (int i = 0; i < segments; ++i) {
            triangleSequencers[i] = new TriangleSequencer();
        }
        this.sequencers = triangleSequencers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next(int segmentId, int commandTopologyId) {
        this.checkTopologyId(commandTopologyId);
        try {
            long l = this.getNext(segmentId, commandTopologyId);
            return l;
        }
        finally {
            this.checkTopologyId(commandTopologyId);
        }
    }

    public boolean isNext(int segmentId, long sequenceNumber, int commandTopologyId) {
        int topologyId = this.distributionManager.getCacheTopology().getTopologyId();
        return commandTopologyId < topologyId || commandTopologyId == topologyId && this.checkIfNext(segmentId, commandTopologyId, sequenceNumber);
    }

    public void markDelivered(int segmentId, long sequenceNumber, int commandTopologyId) {
        this.sequencers[segmentId].deliver(commandTopologyId, sequenceNumber);
    }

    private long getNext(int segmentId, int topologyId) {
        return this.sequencers[segmentId].next(topologyId);
    }

    private boolean checkIfNext(int segmentId, int topologyId, long sequenceNumber) {
        return this.sequencers[segmentId].isNext(topologyId, sequenceNumber);
    }

    private void checkTopologyId(int topologyId) {
        if (topologyId != this.distributionManager.getCacheTopology().getTopologyId()) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
    }

    private static class TriangleSequencer {
        @GuardedBy(value="this")
        private int senderTopologyId = -1;
        @GuardedBy(value="this")
        private int receiverTopologyId = -1;
        @GuardedBy(value="this")
        private long senderSequenceNumber = 1L;
        @GuardedBy(value="this")
        private long receiverSequenceNumber = 1L;

        private TriangleSequencer() {
        }

        private synchronized long next(int commandTopologyId) {
            if (this.senderTopologyId == commandTopologyId) {
                if (trace) {
                    log.tracef("Sender Increment sequence (%s:%s). commandTopologyId=%s", this.senderTopologyId, this.senderSequenceNumber, commandTopologyId);
                }
                return this.senderSequenceNumber++;
            }
            if (this.senderTopologyId < commandTopologyId) {
                if (trace) {
                    log.tracef("Sender update topology. CurrentTopologyId=%s, CommandTopologyId=%s", this.senderTopologyId, commandTopologyId);
                }
                this.senderTopologyId = commandTopologyId;
                this.senderSequenceNumber = 2L;
                return 1L;
            }
            if (trace) {
                log.tracef("Sender old topology. CurrentTopologyId=%s, CommandTopologyId=%s", this.senderTopologyId, commandTopologyId);
            }
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }

        private synchronized void deliver(int commandTopologyId, long sequenceNumber) {
            if (this.receiverTopologyId == commandTopologyId && this.receiverSequenceNumber == sequenceNumber) {
                ++this.receiverSequenceNumber;
                if (trace) {
                    log.tracef("Deliver done. Next sequence (%s:%s)", this.receiverTopologyId, this.receiverSequenceNumber);
                }
            }
        }

        private synchronized boolean isNext(int commandTopologyId, long sequenceNumber) {
            if (this.receiverTopologyId == commandTopologyId) {
                if (trace) {
                    log.tracef("Receiver old topology. Current sequence (%s:%s), command sequence (%s:%s)", new Object[]{this.receiverTopologyId, this.receiverSequenceNumber, commandTopologyId, sequenceNumber});
                }
                return this.receiverSequenceNumber == sequenceNumber;
            }
            if (this.receiverTopologyId < commandTopologyId) {
                if (trace) {
                    log.tracef("Receiver update topology. CommandTopologyId=%s, command sequence=%s", commandTopologyId, sequenceNumber);
                }
                this.receiverTopologyId = commandTopologyId;
                this.receiverSequenceNumber = 1L;
                return 1L == sequenceNumber;
            }
            if (trace) {
                log.tracef("Receiver old topology. Current sequence (%s:%s), command sequence (%s:%s)", new Object[]{this.receiverTopologyId, this.receiverSequenceNumber, commandTopologyId, sequenceNumber});
            }
            return true;
        }
    }
}

