/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import javax.transaction.Transaction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.TxBatchUpdater;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

public class TransactionalStoreInterceptor
extends DDAsyncInterceptor {
    @Inject
    PersistenceManager persistenceManager;
    @Inject
    InternalEntryFactory entryFactory;
    @Inject
    MarshallableEntryFactory marshalledEntryFactory;

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Transaction tx = ctx.getTransaction();
            TxBatchUpdater modBuilder = TxBatchUpdater.createTxStoreUpdater(this.persistenceManager, this.entryFactory, this.marshalledEntryFactory, ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAffectedKeys());
            List<WriteCommand> modifications = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications();
            for (WriteCommand writeCommand : modifications) {
                writeCommand.acceptVisitor(ctx, modBuilder);
            }
            return this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, this.persistenceManager.prepareAllTxStores(tx, modBuilder.getModifications(), PersistenceManager.AccessMode.SHARED));
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, this.persistenceManager.commitAllTxStores(ctx.getTransaction(), PersistenceManager.AccessMode.SHARED));
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, this.persistenceManager.rollbackAllTxStores(ctx.getTransaction(), PersistenceManager.AccessMode.SHARED));
        }
        return this.invokeNext(ctx, command);
    }
}

