/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricID;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.metrics.impl.NameUtils;

@Scope(value=Scopes.NONE)
abstract class AbstractMetricsRegistration {
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    BasicComponentRegistry basicComponentRegistry;
    @Inject
    MetricsCollector metricsCollector;
    protected String namePrefix;
    private Set<MetricID> metricIds;

    AbstractMetricsRegistration() {
    }

    @Start
    protected void start() {
        if (this.metricsEnabled()) {
            this.namePrefix = this.initNamePrefix();
            this.metricIds = Collections.synchronizedSet(new HashSet());
            try {
                this.processComponents();
            }
            catch (Exception e) {
                throw new CacheException("Failure while registering metrics", (Throwable)e);
            }
        }
    }

    @Stop
    protected void stop() {
        if (this.metricIds != null) {
            this.unregisterMetrics(this.metricIds);
            this.metricIds = null;
        }
    }

    public boolean metricsEnabled() {
        return this.metricsCollector != null;
    }

    protected abstract String initNamePrefix();

    private void processComponents() {
        for (ComponentRef<?> component : this.basicComponentRegistry.getRegisteredComponents()) {
            MBeanMetadata beanMetadata;
            Object instance;
            if (component.isAlias() || (instance = component.wired()) == null || (beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName())) == null) continue;
            Set<MetricID> ids = this.registerMetrics(instance, beanMetadata, null, component.getName(), null);
            this.metricIds.addAll(ids);
        }
    }

    private Set<MetricID> registerMetrics(Object instance, MBeanMetadata beanMetadata, String type, String componentName, String prefix) {
        String jmxObjectName = beanMetadata.getJmxObjectName();
        if (jmxObjectName == null) {
            jmxObjectName = componentName;
        }
        if (jmxObjectName == null) {
            throw new IllegalArgumentException("No MBean name and no component name was specified");
        }
        String metricPrefix = this.namePrefix;
        if (!jmxObjectName.equals("Cache") && !jmxObjectName.equals("CacheManager")) {
            if (prefix != null) {
                metricPrefix = metricPrefix + NameUtils.decamelize(prefix) + '_';
            }
            if (type != null && !type.equals(jmxObjectName)) {
                metricPrefix = metricPrefix + NameUtils.decamelize(type) + '_';
            }
            metricPrefix = metricPrefix + NameUtils.decamelize(jmxObjectName) + '_';
        }
        return this.internalRegisterMetrics(instance, beanMetadata, metricPrefix);
    }

    protected Set<MetricID> internalRegisterMetrics(Object instance, MBeanMetadata beanMetadata, String metricPrefix) {
        return this.metricsCollector.registerMetrics(instance, beanMetadata, metricPrefix, null);
    }

    public void registerMetrics(Object instance, String type, String componentName) {
        if (this.metricsCollector == null) {
            throw new IllegalStateException("Microprofile metrics are not initialized");
        }
        MBeanMetadata beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        if (beanMetadata == null) {
            throw new IllegalArgumentException("No MBean metadata available for " + instance.getClass().getName());
        }
        Set<MetricID> ids = this.registerMetrics(instance, beanMetadata, type, componentName, null);
        this.metricIds.addAll(ids);
    }

    public Set<MetricID> registerExternalMetrics(Object instance, String prefix) {
        if (this.metricsCollector == null) {
            throw new IllegalStateException("Microprofile metrics are not initialized");
        }
        MBeanMetadata beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        if (beanMetadata == null) {
            throw new IllegalArgumentException("No MBean metadata available for " + instance.getClass().getName());
        }
        return this.registerMetrics(instance, beanMetadata, null, null, prefix);
    }

    public void unregisterMetrics(Set<MetricID> metricIds) {
        if (this.metricsCollector == null) {
            throw new IllegalStateException("Microprofile metrics are not initialized");
        }
        try {
            for (MetricID metricId : metricIds) {
                this.metricsCollector.unregisterMetric(metricId);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering metrics", (Throwable)e);
        }
    }
}

