/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.Constants;
import org.infinispan.metrics.impl.NameUtils;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class MetricsCollector
implements Constants {
    private static final Log log = LogFactory.getLog(MetricsCollector.class);
    private final MetricRegistry registry;
    private Tag nodeTag;
    private Tag cacheManagerTag;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    ComponentRef<Transport> transportRef;

    protected MetricsCollector(MetricRegistry registry) {
        this.registry = registry;
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Start
    protected void start() {
        String nodeName;
        Transport transport = this.transportRef.running();
        String string = nodeName = transport != null ? transport.getAddress().toString() : this.globalConfig.transport().nodeName();
        if (nodeName == null) {
            nodeName = MetricsCollector.generateRandomName();
        }
        this.nodeTag = new Tag("node", nodeName);
        if (this.globalConfig.metrics().namesAsTags()) {
            this.cacheManagerTag = new Tag("cache_manager", this.globalConfig.cacheManagerName());
        }
    }

    private static String generateRandomName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getByName(null).getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (hostName == null) {
            hostName = "localhost";
        } else {
            int dotPos = hostName.indexOf(46);
            if (dotPos > 0 && !Character.isDigit(hostName.charAt(0))) {
                hostName = hostName.substring(0, dotPos);
            }
        }
        int rand = 1 + ThreadLocalRandom.current().nextInt(65534);
        return hostName + '-' + rand;
    }

    public Set<MetricID> registerMetrics(Object instance, MBeanMetadata beanMetadata, String namePrefix, String cacheName) {
        HashSet<MetricID> metricIds = new HashSet<MetricID>();
        GlobalMetricsConfiguration metricsCfg = this.globalConfig.metrics();
        for (MBeanMetadata.AttributeMetadata attr : beanMetadata.getAttributes()) {
            Supplier<?> getter = attr.getter(instance);
            Consumer<?> setter = attr.setter(instance);
            if (getter == null && setter == null) continue;
            String metricName = namePrefix + NameUtils.decamelize(attr.getName());
            int numTags = 1;
            if (this.cacheManagerTag != null) {
                ++numTags;
                if (cacheName != null) {
                    ++numTags;
                }
            }
            Tag[] tags = new Tag[numTags];
            tags[0] = this.nodeTag;
            if (this.cacheManagerTag != null) {
                tags[1] = this.cacheManagerTag;
                if (cacheName != null) {
                    tags[2] = new Tag("cache", cacheName);
                }
            }
            MetricID metricId = new MetricID(metricName, tags);
            if (getter != null) {
                if (!metricsCfg.gauges()) continue;
                Gauge gaugeMetric = () -> (Number)getter.get();
                Metadata metadata = new MetadataBuilder().withType(MetricType.GAUGE).withUnit("none").withName(metricName).withDisplayName(attr.getName()).withDescription(attr.getDescription()).build();
                if (log.isTraceEnabled()) {
                    log.tracef("Registering gauge metric %s", metricId);
                }
                this.registry.register(metadata, (Metric)gaugeMetric, tags);
                metricIds.add(metricId);
                continue;
            }
            if (!metricsCfg.histograms()) continue;
            Metadata metadata = new MetadataBuilder().withType(MetricType.TIMER).withUnit("nanoseconds").withName(metricName).withDisplayName(attr.getName()).withDescription(attr.getDescription()).build();
            if (log.isTraceEnabled()) {
                log.tracef("Registering histogram metric %s", metricId);
            }
            Timer timerMetric = this.registry.timer(metadata, tags);
            setter.accept(timerMetric);
            metricIds.add(metricId);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Registered %d metrics. Metric registry @%x contains %d metrics.", metricIds.size(), System.identityHashCode(this.registry), this.registry.getMetrics().size());
        }
        return metricIds;
    }

    public void unregisterMetric(MetricID metricId) {
        boolean removed = this.registry.remove(metricId);
        if (log.isTraceEnabled()) {
            if (removed) {
                log.tracef("Unregistered metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.getMetrics().size());
            } else {
                log.tracef("Could not remove unexisting metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.getMetrics().size());
            }
        }
    }
}

