/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.primitive.l;

import io.reactivex.Flowable;
import java.util.stream.LongStream;
import org.infinispan.stream.impl.intops.IntermediateOperation;

public class LimitLongOperation
implements IntermediateOperation<Long, LongStream, Long, LongStream> {
    private final long limit;

    public LimitLongOperation(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Limit must be greater than 0");
        }
        this.limit = limit;
    }

    @Override
    public LongStream perform(LongStream stream) {
        return stream.limit(this.limit);
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public Flowable<Long> mapFlowable(Flowable<Long> input) {
        return input.limit(this.limit);
    }
}

