/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1006)
public class IracEntryVersion {
    private final Map<String, TopologyIracVersion> vectorClock;

    public IracEntryVersion(Map<String, TopologyIracVersion> vectorClock) {
        this.vectorClock = Objects.requireNonNull(vectorClock);
    }

    @ProtoFactory
    static IracEntryVersion protoFactory(List<MapEntry> entries) {
        Map<String, TopologyIracVersion> vectorClock = entries.stream().collect(Collectors.toMap(MapEntry::getSite, MapEntry::getVersion));
        return new IracEntryVersion(vectorClock);
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    List<MapEntry> entries() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(3);
        this.vectorClock.forEach((? super K site, ? super V version) -> entries.add(new MapEntry((String)site, (TopologyIracVersion)version)));
        return entries;
    }

    public Map<String, TopologyIracVersion> toMap() {
        return Collections.unmodifiableMap(this.vectorClock);
    }

    public void forEach(BiConsumer<String, TopologyIracVersion> consumer) {
        this.vectorClock.forEach(consumer);
    }

    public InequalVersionComparisonResult compareTo(IracEntryVersion other) {
        VectorClock vectorClock = new VectorClock();
        this.forEach(vectorClock::setOurs);
        other.forEach(vectorClock::setTheirs);
        Merger merger = Merger.NONE;
        for (VersionCompare v : vectorClock.values()) {
            merger = merger.accept(v);
        }
        return merger.result();
    }

    public IracEntryVersion merge(IracEntryVersion other) {
        if (other == null || other.vectorClock.isEmpty()) {
            return this;
        }
        HashMap<String, TopologyIracVersion> copy = new HashMap<String, TopologyIracVersion>(this.vectorClock);
        for (Map.Entry<String, TopologyIracVersion> entry : other.vectorClock.entrySet()) {
            copy.merge(entry.getKey(), entry.getValue(), TopologyIracVersion::max);
        }
        return new IracEntryVersion(copy);
    }

    public int getTopology(String siteName) {
        return this.vectorClock.getOrDefault(siteName, TopologyIracVersion.NO_VERSION).getTopologyId();
    }

    public String toString() {
        LinkedList entries = new LinkedList();
        this.vectorClock.forEach((? super K site, ? super V version) -> entries.add(site + "=" + version));
        return "(" + String.join((CharSequence)", ", entries) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IracEntryVersion version = (IracEntryVersion)o;
        return this.vectorClock.equals(version.vectorClock);
    }

    public int hashCode() {
        return this.vectorClock.hashCode();
    }

    private static class VectorClock {
        private final Map<String, VersionCompare> vectorClock = new HashMap<String, VersionCompare>();

        private VectorClock() {
        }

        public String toString() {
            return "VectorClock{vectorClock=" + this.vectorClock + '}';
        }

        void setOurs(String site, TopologyIracVersion version) {
            VersionCompare v = this.vectorClock.get(site);
            if (v == null) {
                v = new VersionCompare();
                this.vectorClock.put(site, v);
            }
            v.ours = version;
            if (v.theirs == null) {
                v.theirs = TopologyIracVersion.NO_VERSION;
            }
        }

        void setTheirs(String site, TopologyIracVersion version) {
            VersionCompare v = this.vectorClock.get(site);
            if (v == null) {
                v = new VersionCompare();
                this.vectorClock.put(site, v);
            }
            v.theirs = version;
            if (v.ours == null) {
                v.ours = TopologyIracVersion.NO_VERSION;
            }
        }

        Collection<VersionCompare> values() {
            return this.vectorClock.values();
        }
    }

    private static class VersionCompare {
        TopologyIracVersion ours;
        TopologyIracVersion theirs;

        private VersionCompare() {
        }

        public String toString() {
            return "VersionCompare{ours=" + this.ours + ", theirs=" + this.theirs + '}';
        }
    }

    @ProtoTypeId(value=1008)
    public static class MapEntry {
        @ProtoField(value=1)
        final String site;
        @ProtoField(value=2)
        final TopologyIracVersion version;

        @ProtoFactory
        MapEntry(String site, TopologyIracVersion version) {
            this.site = site;
            this.version = version;
        }

        public String getSite() {
            return this.site;
        }

        public TopologyIracVersion getVersion() {
            return this.version;
        }

        public String toString() {
            return "MapEntry{site='" + this.site + '\'' + ", version=" + this.version + '}';
        }
    }

    private static enum Merger {
        NONE{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare < 0) {
                    return OLD;
                }
                if (compare > 0) {
                    return NEW;
                }
                return EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                throw new IllegalStateException();
            }
        }
        ,
        OLD{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare < 0) {
                    return OLD;
                }
                if (compare > 0) {
                    return CONFLICT;
                }
                return OLD_OR_EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.BEFORE;
            }
        }
        ,
        OLD_OR_EQUALS{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                return compare <= 0 ? OLD_OR_EQUALS : CONFLICT;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.BEFORE;
            }
        }
        ,
        NEW{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare > 0) {
                    return NEW;
                }
                if (compare < 0) {
                    return CONFLICT;
                }
                return NEW_OR_EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.AFTER;
            }
        }
        ,
        NEW_OR_EQUALS{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                return compare < 0 ? CONFLICT : NEW_OR_EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.AFTER;
            }
        }
        ,
        EQUALS{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare < 0) {
                    return OLD_OR_EQUALS;
                }
                if (compare > 0) {
                    return NEW_OR_EQUALS;
                }
                return EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.EQUAL;
            }
        }
        ,
        CONFLICT{

            @Override
            Merger accept(VersionCompare versions) {
                return CONFLICT;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.CONFLICTING;
            }
        };


        abstract Merger accept(VersionCompare var1);

        abstract InequalVersionComparisonResult result();
    }
}

