/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ResourceDMBean
implements DynamicMBean,
MBeanRegistration {
    private static final Log log = LogFactory.getLog(ResourceDMBean.class);
    private final Object obj;
    private final Class<?> objectClass;
    private final MBeanOperationInfo[] opInfos;
    private final String[] opNames;
    private final MBeanAttributeInfo[] attInfos;
    private final Map<String, InvokableMBeanAttributeInfo> atts = new HashMap<String, InvokableMBeanAttributeInfo>(2);
    private final String mbeanName;
    private final String description;
    private ObjectName objectName;
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>(64);
    private static final Map<String, Method> METHOD_CACHE = new ConcurrentHashMap<String, Method>(64);

    ResourceDMBean(Object instance, MBeanMetadata mBeanMetadata, String componentName) {
        if (instance == null) {
            throw new NullPointerException("Cannot make an MBean wrapper for null instance");
        }
        this.obj = instance;
        this.objectClass = instance.getClass();
        if (mBeanMetadata.getJmxObjectName() != null) {
            this.mbeanName = mBeanMetadata.getJmxObjectName();
        } else if (componentName != null) {
            this.mbeanName = componentName;
        } else {
            throw new IllegalArgumentException("MBean.objectName and componentName cannot be both null");
        }
        this.description = mBeanMetadata.getDescription();
        int i = 0;
        this.attInfos = new MBeanAttributeInfo[mBeanMetadata.getAttributes().size()];
        for (MBeanMetadata.AttributeMetadata attributeMetadata : mBeanMetadata.getAttributes()) {
            String attributeName = attributeMetadata.getName();
            if (this.atts.containsKey(attributeName)) {
                throw new IllegalArgumentException("Component " + this.objectClass.getName() + " metadata has a duplicate attribute: " + attributeName);
            }
            InvokableMBeanAttributeInfo info = this.toJmxInfo(attributeMetadata);
            this.atts.put(attributeName, info);
            this.attInfos[i++] = info.attributeInfo;
            if (!log.isTraceEnabled()) continue;
            log.tracef("Attribute %s [r=%b,w=%b,is=%b,type=%s]", new Object[]{attributeName, info.attributeInfo.isReadable(), info.attributeInfo.isWritable(), info.attributeInfo.isIs(), info.attributeInfo.getType()});
        }
        this.opInfos = new MBeanOperationInfo[mBeanMetadata.getOperations().size()];
        this.opNames = new String[this.opInfos.length];
        i = 0;
        for (MBeanMetadata.OperationMetadata operation : mBeanMetadata.getOperations()) {
            this.opNames[i] = operation.getOperationName();
            MBeanOperationInfo op = this.toJmxInfo(operation);
            this.opInfos[i++] = op;
            if (!log.isTraceEnabled()) continue;
            log.tracef("Operation %s %s", op.getReturnType(), op.getName());
        }
    }

    String getMBeanName() {
        return this.mbeanName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    private static Field findField(Class<?> objectClass, String fieldName) {
        String key = objectClass.getName() + "#" + fieldName;
        Field f = FIELD_CACHE.get(key);
        if (f == null && (f = ReflectionUtil.getField((String)fieldName, objectClass)) != null) {
            FIELD_CACHE.put(key, f);
        }
        return f;
    }

    private static Method findSetter(Class<?> objectClass, String fieldName) {
        String key = objectClass.getName() + "#s#" + fieldName;
        Method m = METHOD_CACHE.get(key);
        if (m == null && (m = ReflectionUtil.findSetterForField(objectClass, (String)fieldName)) != null) {
            METHOD_CACHE.put(key, m);
        }
        return m;
    }

    private static Method findGetter(Class<?> objectClass, String fieldName) {
        String key = objectClass.getName() + "#g#" + fieldName;
        Method m = METHOD_CACHE.get(key);
        if (m == null && (m = ReflectionUtil.findGetterForField(objectClass, (String)fieldName)) != null) {
            METHOD_CACHE.put(key, m);
        }
        return m;
    }

    private InvokableMBeanAttributeInfo toJmxInfo(MBeanMetadata.AttributeMetadata attributeMetadata) {
        Field field;
        if (!attributeMetadata.isUseSetter() && (field = ResourceDMBean.findField(this.objectClass, attributeMetadata.getName())) != null) {
            return new InvokableFieldBasedMBeanAttributeInfo(attributeMetadata.getName(), attributeMetadata.getType(), attributeMetadata.getDescription(), true, attributeMetadata.isWritable(), attributeMetadata.isIs(), field);
        }
        Method setter = null;
        Method getter = null;
        try {
            setter = attributeMetadata.isWritable() ? ResourceDMBean.findSetter(this.objectClass, attributeMetadata.getName()) : null;
            getter = ResourceDMBean.findGetter(this.objectClass, attributeMetadata.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return new InvokableSetterBasedMBeanAttributeInfo(attributeMetadata.getName(), attributeMetadata.getType(), attributeMetadata.getDescription(), true, attributeMetadata.isWritable(), attributeMetadata.isIs(), getter, setter);
    }

    private MBeanOperationInfo toJmxInfo(MBeanMetadata.OperationMetadata operationMetadata) {
        MBeanMetadata.OperationParameterMetadata[] parameters = operationMetadata.getMethodParameters();
        MBeanParameterInfo[] params = new MBeanParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = new MBeanParameterInfo(parameters[i].getName(), parameters[i].getType(), parameters[i].getDescription());
        }
        return new MBeanOperationInfo(operationMetadata.getMethodName(), operationMetadata.getDescription(), params, operationMetadata.getReturnType(), 3);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.objectClass.getName(), this.description, this.attInfos, null, this.opInfos, null);
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        if (attr == null) {
            throw new AttributeNotFoundException("Unknown attribute '" + name + "'. Known attributes names are: " + this.atts.keySet());
        }
        return attr.getValue();
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + attribute);
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            log.couldNotFindAttribute(name);
        }
        return al;
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (Object aList : list) {
            Attribute attr = (Attribute)aList;
            try {
                this.setNamedAttribute(attr);
                results.add(attr);
            }
            catch (Exception e) {
                log.failedToUpdateAttribute(attr.getName(), attr.getValue());
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException {
        int i;
        if (log.isDebugEnabled()) {
            log.debugf("Invoke method called on %s", name);
        }
        MBeanOperationInfo opInfo = null;
        for (i = 0; i < this.opNames.length; ++i) {
            if (!this.opNames[i].equals(name)) continue;
            opInfo = this.opInfos[i];
            break;
        }
        if (opInfo == null) {
            String msg = "Operation " + name + " not amongst operations in " + Arrays.toString(this.opInfos);
            throw new MBeanException(new ServiceNotFoundException(msg), msg);
        }
        for (i = 0; i < sig.length; ++i) {
            if (args[i] == null) continue;
            if (log.isDebugEnabled()) {
                log.debugf("Argument value before transformation: %s and its class: %s. For method.invoke we need it to be class: %s", args[i], args[i].getClass(), sig[i]);
            }
            if (sig[i].equals(Integer.TYPE.getName()) || sig[i].equals(Integer.class.getName())) {
                if (args[i].getClass() == Integer.class || args[i].getClass() == Integer.TYPE) continue;
                args[i] = Integer.parseInt((String)args[i]);
                continue;
            }
            if (!sig[i].equals(Long.class.getName()) && !sig[i].equals(Long.TYPE.getName()) || args[i].getClass() == Long.class || args[i].getClass() == Long.TYPE) continue;
            args[i] = Long.parseLong((String)args[i]);
        }
        try {
            Class[] classes = new Class[sig.length];
            for (int i2 = 0; i2 < classes.length; ++i2) {
                classes[i2] = ReflectionUtil.getClassForName((String)sig[i2], null);
            }
            Method method = this.objectClass.getMethod(opInfo.getName(), classes);
            return method.invoke(this.obj, args);
        }
        catch (Exception e) {
            throw new MBeanException(new Exception(ResourceDMBean.getRootCause(e)));
        }
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Attribute getNamedAttribute(String name) {
        char firstChar;
        Attribute result = null;
        InvokableMBeanAttributeInfo i = this.atts.get(name);
        if (i == null && name.length() > 0 && Character.isUpperCase(firstChar = name.charAt(0))) {
            name = Character.toLowerCase(firstChar) + name.substring(1);
            i = this.atts.get(name);
        }
        if (i != null) {
            try {
                result = new Attribute(name, i.invoke(null));
                if (!log.isTraceEnabled()) return result;
                log.tracef("Attribute %s has r=%b,w=%b,is=%b and value %s", new Object[]{name, i.attributeInfo.isReadable(), i.attributeInfo.isWritable(), i.attributeInfo.isIs(), result.getValue()});
                return result;
            }
            catch (Exception e) {
                log.debugf(e, "Exception while reading value of attribute %s", name);
                throw new CacheException((Throwable)e);
            }
        } else {
            log.queriedAttributeNotFound(name);
        }
        return result;
    }

    private void setNamedAttribute(Attribute attribute) throws MBeanException, AttributeNotFoundException {
        char firstChar;
        String name;
        InvokableMBeanAttributeInfo i;
        if (log.isDebugEnabled()) {
            log.debugf("Invoking set on attribute %s with value %s", attribute.getName(), attribute.getValue());
        }
        if ((i = this.atts.get(name = attribute.getName())) == null && name.length() > 0 && Character.isUpperCase(firstChar = name.charAt(0))) {
            name = name.replaceFirst(Character.toString(firstChar), Character.toString(Character.toLowerCase(firstChar)));
            i = this.atts.get(name);
        }
        if (i != null) {
            try {
                i.invoke(attribute);
            }
            catch (Exception e) {
                log.errorWritingValueForAttribute(name, e);
                throw new MBeanException(e, "Error invoking setter for attribute " + name);
            }
        } else {
            log.couldNotInvokeSetOnAttribute(name, attribute.getValue());
            throw new AttributeNotFoundException("Could not find attribute " + name);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
        this.objectName = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != ResourceDMBean.class) {
            return false;
        }
        ResourceDMBean that = (ResourceDMBean)o;
        return this.obj == that.obj;
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public String toString() {
        return "ResourceDMBean{obj=" + System.identityHashCode(this.obj) + ", objectClass=" + this.objectClass + ", mbeanName='" + this.mbeanName + '\'' + ", description='" + this.description + '\'' + ", objectName=" + this.objectName + '}';
    }

    private final class InvokableSetterBasedMBeanAttributeInfo
    extends InvokableMBeanAttributeInfo {
        private final Method setter;
        private final Method getter;

        InvokableSetterBasedMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Method getter, Method setter) {
            super(name, type, description, isReadable, isWritable, isIs);
            this.setter = setter;
            this.getter = getter;
        }

        @Override
        Object invoke(Attribute a) throws IllegalAccessException, InvocationTargetException {
            if (a == null) {
                if (!Modifier.isPublic(this.getter.getModifiers())) {
                    this.getter.setAccessible(true);
                }
                return this.getter.invoke(ResourceDMBean.this.obj, new Object[0]);
            }
            if (!Modifier.isPublic(this.setter.getModifiers())) {
                this.setter.setAccessible(true);
            }
            return this.setter.invoke(ResourceDMBean.this.obj, a.getValue());
        }
    }

    private final class InvokableFieldBasedMBeanAttributeInfo
    extends InvokableMBeanAttributeInfo {
        private final Field field;

        InvokableFieldBasedMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Field field) {
            super(name, type, description, isReadable, isWritable, isIs);
            this.field = field;
        }

        @Override
        Object invoke(Attribute a) throws IllegalAccessException {
            if (!Modifier.isPublic(this.field.getModifiers())) {
                this.field.setAccessible(true);
            }
            if (a == null) {
                return this.field.get(ResourceDMBean.this.obj);
            }
            this.field.set(ResourceDMBean.this.obj, a.getValue());
            return null;
        }
    }

    private static abstract class InvokableMBeanAttributeInfo {
        private final MBeanAttributeInfo attributeInfo;

        InvokableMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
            this.attributeInfo = new MBeanAttributeInfo(name, type, description, isReadable, isWritable, isIs);
        }

        abstract Object invoke(Attribute var1) throws IllegalAccessException, InvocationTargetException;
    }
}

