package org.infinispan.remoting.transport.jgroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Generated;
import static org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;
import org.jgroups.stack.Protocol;

@Generated(value = "org.infinispan.component.processor.external.JGroupsComponentProcessor", date = "2022-04-29T09:11:49.398927Z")
public class JGroupsMetricsMetadata {
   public static final Map<Class<? extends Protocol>, Collection<AttributeMetadata>> PROTOCOL_METADATA = new HashMap<>();
   private JGroupsMetricsMetadata() {}
   static {
      List<AttributeMetadata> attributes;
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfHeartbeatsSent", "Number of heartbeats sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.FD, ?>) org.jgroups.protocols.FD::getNumberOfHeartbeatsSent, null));
      attributes.add(new AttributeMetadata("getNumSuspectEventsGenerated", "Number of suspect events received", false, false, "int",
                               false, (Function<org.jgroups.protocols.FD, ?>) org.jgroups.protocols.FD::getNumSuspectEventsGenerated, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FD.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumSuspectedMembers", "The number of currently suspected members", false, false, "int",
                               false, (Function<org.jgroups.protocols.FD_SOCK, ?>) org.jgroups.protocols.FD_SOCK::getNumSuspectedMembers, null));
      attributes.add(new AttributeMetadata("getClientBindPortActual", "The actual client_bind_port", false, false, "int",
                               false, (Function<org.jgroups.protocols.FD_SOCK, ?>) org.jgroups.protocols.FD_SOCK::getClientBindPortActual, null));
      attributes.add(new AttributeMetadata("getNumSuspectEventsGenerated", "Number of suspect event generated", false, false, "int",
                               false, (Function<org.jgroups.protocols.FD_SOCK, ?>) org.jgroups.protocols.FD_SOCK::getNumSuspectEventsGenerated, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FD_SOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfViews", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.GMS, ?>) org.jgroups.protocols.pbcast.GMS::getNumberOfViews, null));
      attributes.add(new AttributeMetadata("getNumMembers", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.GMS, ?>) org.jgroups.protocols.pbcast.GMS::getNumMembers, null));
      attributes.add(new AttributeMetadata("getViewHandlerSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.GMS, ?>) org.jgroups.protocols.pbcast.GMS::getViewHandlerSize, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.GMS.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getStableSent", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STABLE, ?>) org.jgroups.protocols.pbcast.STABLE::getStableSent, null));
      attributes.add(new AttributeMetadata("getStableReceived", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STABLE, ?>) org.jgroups.protocols.pbcast.STABLE::getStableReceived, null));
      attributes.add(new AttributeMetadata("getStabilitySent", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STABLE, ?>) org.jgroups.protocols.pbcast.STABLE::getStabilitySent, null));
      attributes.add(new AttributeMetadata("getStabilityReceived", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STABLE, ?>) org.jgroups.protocols.pbcast.STABLE::getStabilityReceived, null));
      attributes.add(new AttributeMetadata("getNumVotes", "The number of votes for the current digest", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STABLE, ?>) org.jgroups.protocols.pbcast.STABLE::getNumVotes, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STABLE.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfStateRequests", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_TRANSFER, ?>) org.jgroups.protocols.pbcast.STATE_TRANSFER::getNumberOfStateRequests, null));
      attributes.add(new AttributeMetadata("getNumberOfStateBytesSent", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_TRANSFER, ?>) org.jgroups.protocols.pbcast.STATE_TRANSFER::getNumberOfStateBytesSent, null));
      attributes.add(new AttributeMetadata("getAverageStateSize", "", false, false, "double",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_TRANSFER, ?>) org.jgroups.protocols.pbcast.STATE_TRANSFER::getAverageStateSize, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE_TRANSFER.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getDroppedMessages", "Number of messages dropped when sending because of insufficient buffer space", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getDroppedMessages, null));
      attributes.add(new AttributeMetadata("getBundlerBufferSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getBundlerBufferSize, null));
      attributes.add(new AttributeMetadata("bundlerNumSpins", "Number of spins before a real lock is acquired", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::bundlerNumSpins, null));
      attributes.add(new AttributeMetadata("getNumberOfThreadDumps", "Number of thread dumps", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getNumberOfThreadDumps, null));
      attributes.add(new AttributeMetadata("getDifferentClusterMessages", "Number of messages from members in a different cluster", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getDifferentClusterMessages, null));
      attributes.add(new AttributeMetadata("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getDifferentVersionMessages, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "Current number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeActive", "Current number of active threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getThreadPoolSizeActive, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeLargest", "Largest number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSize", "Current number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getInternalThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSizeLargest", "Largest number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getInternalThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getNumTimerTasks", "Number of timer tasks queued up for execution", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getNumTimerTasks, null));
      attributes.add(new AttributeMetadata("getTimerThreads", "Number of threads currently in the pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.UDP, ?>) org.jgroups.protocols.UDP::getTimerThreads, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UDP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getOpenConnections", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getOpenConnections, null));
      attributes.add(new AttributeMetadata("getBundlerBufferSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getBundlerBufferSize, null));
      attributes.add(new AttributeMetadata("bundlerNumSpins", "Number of spins before a real lock is acquired", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::bundlerNumSpins, null));
      attributes.add(new AttributeMetadata("getNumberOfThreadDumps", "Number of thread dumps", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getNumberOfThreadDumps, null));
      attributes.add(new AttributeMetadata("getDifferentClusterMessages", "Number of messages from members in a different cluster", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getDifferentClusterMessages, null));
      attributes.add(new AttributeMetadata("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getDifferentVersionMessages, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "Current number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeActive", "Current number of active threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getThreadPoolSizeActive, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeLargest", "Largest number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSize", "Current number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getInternalThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSizeLargest", "Largest number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getInternalThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getNumTimerTasks", "Number of timer tasks queued up for execution", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getNumTimerTasks, null));
      attributes.add(new AttributeMetadata("getTimerThreads", "Number of threads currently in the pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP, ?>) org.jgroups.protocols.TCP::getTimerThreads, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TCP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getBundlerBufferSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getBundlerBufferSize, null));
      attributes.add(new AttributeMetadata("bundlerNumSpins", "Number of spins before a real lock is acquired", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::bundlerNumSpins, null));
      attributes.add(new AttributeMetadata("getNumberOfThreadDumps", "Number of thread dumps", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getNumberOfThreadDumps, null));
      attributes.add(new AttributeMetadata("getDifferentClusterMessages", "Number of messages from members in a different cluster", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getDifferentClusterMessages, null));
      attributes.add(new AttributeMetadata("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getDifferentVersionMessages, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "Current number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeActive", "Current number of active threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getThreadPoolSizeActive, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeLargest", "Largest number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSize", "Current number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getInternalThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSizeLargest", "Largest number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getInternalThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getNumTimerTasks", "Number of timer tasks queued up for execution", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getNumTimerTasks, null));
      attributes.add(new AttributeMetadata("getTimerThreads", "Number of threads currently in the pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TUNNEL, ?>) org.jgroups.protocols.TUNNEL::getTimerThreads, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TUNNEL.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getForwardTableSize", "Number of messages in the forward-table", false, false, "int",
                               false, (Function<org.jgroups.protocols.SEQUENCER, ?>) org.jgroups.protocols.SEQUENCER::getForwardTableSize, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SEQUENCER.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getAverageFlushDuration", "", false, false, "double",
                               false, (Function<org.jgroups.protocols.pbcast.FLUSH, ?>) org.jgroups.protocols.pbcast.FLUSH::getAverageFlushDuration, null));
      attributes.add(new AttributeMetadata("getTotalTimeInFlush", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.FLUSH, ?>) org.jgroups.protocols.pbcast.FLUSH::getTotalTimeInFlush, null));
      attributes.add(new AttributeMetadata("getNumberOfFlushes", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.FLUSH, ?>) org.jgroups.protocols.pbcast.FLUSH::getNumberOfFlushes, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.FLUSH.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfStateRequests", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE, ?>) org.jgroups.protocols.pbcast.STATE::getNumberOfStateRequests, null));
      attributes.add(new AttributeMetadata("getNumberOfStateBytesSent", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE, ?>) org.jgroups.protocols.pbcast.STATE::getNumberOfStateBytesSent, null));
      attributes.add(new AttributeMetadata("getAverageStateSize", "", false, false, "double",
                               false, (Function<org.jgroups.protocols.pbcast.STATE, ?>) org.jgroups.protocols.pbcast.STATE::getAverageStateSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STATE, ?>) org.jgroups.protocols.pbcast.STATE::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolCompletedTasks", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE, ?>) org.jgroups.protocols.pbcast.STATE::getThreadPoolCompletedTasks, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfStateRequests", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_SOCK, ?>) org.jgroups.protocols.pbcast.STATE_SOCK::getNumberOfStateRequests, null));
      attributes.add(new AttributeMetadata("getNumberOfStateBytesSent", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_SOCK, ?>) org.jgroups.protocols.pbcast.STATE_SOCK::getNumberOfStateBytesSent, null));
      attributes.add(new AttributeMetadata("getAverageStateSize", "", false, false, "double",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_SOCK, ?>) org.jgroups.protocols.pbcast.STATE_SOCK::getAverageStateSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_SOCK, ?>) org.jgroups.protocols.pbcast.STATE_SOCK::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolCompletedTasks", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.STATE_SOCK, ?>) org.jgroups.protocols.pbcast.STATE_SOCK::getThreadPoolCompletedTasks, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE_SOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getBundlerBufferSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getBundlerBufferSize, null));
      attributes.add(new AttributeMetadata("bundlerNumSpins", "Number of spins before a real lock is acquired", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::bundlerNumSpins, null));
      attributes.add(new AttributeMetadata("getNumberOfThreadDumps", "Number of thread dumps", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getNumberOfThreadDumps, null));
      attributes.add(new AttributeMetadata("getDifferentClusterMessages", "Number of messages from members in a different cluster", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getDifferentClusterMessages, null));
      attributes.add(new AttributeMetadata("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getDifferentVersionMessages, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "Current number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeActive", "Current number of active threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getThreadPoolSizeActive, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeLargest", "Largest number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSize", "Current number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getInternalThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSizeLargest", "Largest number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getInternalThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getNumTimerTasks", "Number of timer tasks queued up for execution", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getNumTimerTasks, null));
      attributes.add(new AttributeMetadata("getTimerThreads", "Number of threads currently in the pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.SHARED_LOOPBACK, ?>) org.jgroups.protocols.SHARED_LOOPBACK::getTimerThreads, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SHARED_LOOPBACK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfBlockings", "Number of times flow control blocks sender", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC, ?>) org.jgroups.protocols.MFC::getNumberOfBlockings, null));
      attributes.add(new AttributeMetadata("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", false, false, "double",
                               false, (Function<org.jgroups.protocols.MFC, ?>) org.jgroups.protocols.MFC::getAverageTimeBlocked, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsReceived", "Number of credit requests received", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC, ?>) org.jgroups.protocols.MFC::getNumberOfCreditRequestsReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsSent", "Number of credit requests sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC, ?>) org.jgroups.protocols.MFC::getNumberOfCreditRequestsSent, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesReceived", "Number of credit responses received", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC, ?>) org.jgroups.protocols.MFC::getNumberOfCreditResponsesReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesSent", "Number of credit responses sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC, ?>) org.jgroups.protocols.MFC::getNumberOfCreditResponsesSent, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MFC.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfBlockings", "Number of times flow control blocks sender", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC, ?>) org.jgroups.protocols.UFC::getNumberOfBlockings, null));
      attributes.add(new AttributeMetadata("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", false, false, "double",
                               false, (Function<org.jgroups.protocols.UFC, ?>) org.jgroups.protocols.UFC::getAverageTimeBlocked, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsReceived", "Number of credit requests received", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC, ?>) org.jgroups.protocols.UFC::getNumberOfCreditRequestsReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsSent", "Number of credit requests sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC, ?>) org.jgroups.protocols.UFC::getNumberOfCreditRequestsSent, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesReceived", "Number of credit responses received", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC, ?>) org.jgroups.protocols.UFC::getNumberOfCreditResponsesReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesSent", "Number of credit responses sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC, ?>) org.jgroups.protocols.UFC::getNumberOfCreditResponsesSent, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UFC.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumSubscriptions", "Number of subscriptions", false, false, "int",
                               false, (Function<org.jgroups.protocols.STOMP, ?>) org.jgroups.protocols.STOMP::getNumSubscriptions, null));
      attributes.add(new AttributeMetadata("getNumConnections", "Number of client connections", false, false, "int",
                               false, (Function<org.jgroups.protocols.STOMP, ?>) org.jgroups.protocols.STOMP::getNumConnections, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.STOMP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumServerLocks", "Number of server locks (only on coord)", false, false, "int",
                               false, (Function<org.jgroups.protocols.CENTRAL_LOCK, ?>) org.jgroups.protocols.CENTRAL_LOCK::getNumServerLocks, null));
      attributes.add(new AttributeMetadata("getNumClientLocks", "Number of client locks", false, false, "int",
                               false, (Function<org.jgroups.protocols.CENTRAL_LOCK, ?>) org.jgroups.protocols.CENTRAL_LOCK::getNumClientLocks, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.CENTRAL_LOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getViews", "Number of cached ViewIds", false, false, "int",
                               false, (Function<org.jgroups.protocols.MERGE3, ?>) org.jgroups.protocols.MERGE3::getViews, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MERGE3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getPendingRsvpRequests", "Number of pending RSVP requests", false, false, "int",
                               false, (Function<org.jgroups.protocols.RSVP, ?>) org.jgroups.protocols.RSVP::getPendingRsvpRequests, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.RSVP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNonMemberMessages", "Number of messages from non-members", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getNonMemberMessages, null));
      attributes.add(new AttributeMetadata("getBecomeServerQueueSizeActual", "Actual size of the become_server_queue", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getBecomeServerQueueSizeActual, null));
      attributes.add(new AttributeMetadata("getXmitTableUndeliveredMsgs", "Total number of undelivered messages in all retransmit buffers", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableUndeliveredMsgs, null));
      attributes.add(new AttributeMetadata("getXmitTableMissingMessages", "Total number of missing (= not received) messages in all retransmit buffers", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableMissingMessages, null));
      attributes.add(new AttributeMetadata("getXmitTableCapacity", "Capacity of the retransmit buffer. Computed as xmit_table_num_rows * xmit_table_msgs_per_row", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableCapacity, null));
      attributes.add(new AttributeMetadata("getXmitTableNumCurrentRows", "Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumCurrentRows, null));
      attributes.add(new AttributeMetadata("getSizeOfAllMessages", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getSizeOfAllMessages, null));
      attributes.add(new AttributeMetadata("getSizeOfAllMessagesInclHeaders", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getSizeOfAllMessagesInclHeaders, null));
      attributes.add(new AttributeMetadata("getXmitTableNumCompactions", "Number of retransmit table compactions", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumCompactions, null));
      attributes.add(new AttributeMetadata("getXmitTableNumMoves", "Number of retransmit table moves", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumMoves, null));
      attributes.add(new AttributeMetadata("getXmitTableNumResizes", "Number of retransmit table resizes", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumResizes, null));
      attributes.add(new AttributeMetadata("getXmitTableNumPurges", "Number of retransmit table purges", false, false, "int",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumPurges, null));
      attributes.add(new AttributeMetadata("getCurrentSeqno", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.pbcast.NAKACK2, ?>) org.jgroups.protocols.pbcast.NAKACK2::getCurrentSeqno, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.NAKACK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getAvgToaSendDuration", "The average duration (in milliseconds) in processing and sending the anycast message to all the recipients", false, false, "double",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getAvgToaSendDuration, null));
      attributes.add(new AttributeMetadata("getAvgDataMessageReceivedDuration", "The average duration (in milliseconds) in processing a data message received", false, false, "double",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getAvgDataMessageReceivedDuration, null));
      attributes.add(new AttributeMetadata("getAvgProposeMessageReceivedDuration", "The average duration (in milliseconds) in processing a propose message received(not the last one", false, false, "double",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getAvgProposeMessageReceivedDuration, null));
      attributes.add(new AttributeMetadata("getAvgLastProposeMessageReceivedDuration", "The average duration (in milliseconds) in processing the last propose message received. This last propose message will originate the sending of the final message", false, false, "double",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getAvgLastProposeMessageReceivedDuration, null));
      attributes.add(new AttributeMetadata("getAvgFinalMessageReceivedDuration", "The average duration (in milliseconds) in processing a final message received", false, false, "double",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getAvgFinalMessageReceivedDuration, null));
      attributes.add(new AttributeMetadata("getNumberOfAnycastMessagesSent", "The number of anycast messages sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfAnycastMessagesSent, null));
      attributes.add(new AttributeMetadata("getNumberOfFinalAnycastSent", "The number of final anycast sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfFinalAnycastSent, null));
      attributes.add(new AttributeMetadata("getNumberOfAnycastMessagesDelivered", "The number of anycast messages delivered", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfAnycastMessagesDelivered, null));
      attributes.add(new AttributeMetadata("getNumberOfProposeMessageSent", "The number of propose messages sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfProposeMessageSent, null));
      attributes.add(new AttributeMetadata("getNumberOfFinalMessagesDelivered", "The number of final messages delivered", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfFinalMessagesDelivered, null));
      attributes.add(new AttributeMetadata("getNumberOfDataMessagesDelivered", "The number of data messages delivered", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfDataMessagesDelivered, null));
      attributes.add(new AttributeMetadata("getNumberOfProposeMessageReceived", "The number of propose messages received", false, false, "int",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getNumberOfProposeMessageReceived, null));
      attributes.add(new AttributeMetadata("getAvgNumberOfUnicastSentPerAnycast", "The average number of unicasts messages created per anycast message", false, false, "double",
                               false, (Function<org.jgroups.protocols.tom.TOA, ?>) org.jgroups.protocols.tom.TOA::getAvgNumberOfUnicastSentPerAnycast, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.tom.TOA.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getNumForwardedToSiteMaster, null));
      attributes.add(new AttributeMetadata("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getTimeForwardingToSM, null));
      attributes.add(new AttributeMetadata("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getAvgMsgsForwardingToSM, null));
      attributes.add(new AttributeMetadata("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getNumRelayed, null));
      attributes.add(new AttributeMetadata("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getTimeRelaying, null));
      attributes.add(new AttributeMetadata("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getAvgMsgsRelaying, null));
      attributes.add(new AttributeMetadata("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getNumForwardedToLocalMbr, null));
      attributes.add(new AttributeMetadata("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getTimeForwardingToLocalMbr, null));
      attributes.add(new AttributeMetadata("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getAvgMsgsForwardingToLocalMbr, null));
      attributes.add(new AttributeMetadata("getNumLocalDeliveries", "Number of messages delivered locally, e.g. received and delivered to self", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getNumLocalDeliveries, null));
      attributes.add(new AttributeMetadata("getTimeDeliveringLocally", "The total time (ms) spent delivering received messages locally", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getTimeDeliveringLocally, null));
      attributes.add(new AttributeMetadata("getAvgMsgsDeliveringLocally", "The average number of messages / s for delivering received messages locally", false, false, "long",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getAvgMsgsDeliveringLocally, null));
      attributes.add(new AttributeMetadata("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", false, false, "int",
                               false, (Function<org.jgroups.protocols.relay.RELAY2, ?>) org.jgroups.protocols.relay.RELAY2::getNumberOfNoRouteErrors, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.relay.RELAY2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getDeliveryTableSize", "Total number of all seqnos maintained for all receivers", false, false, "int",
                               false, (Function<org.jgroups.protocols.FORWARD_TO_COORD, ?>) org.jgroups.protocols.FORWARD_TO_COORD::getDeliveryTableSize, null));
      attributes.add(new AttributeMetadata("getForwardTableSize", "Number of messages for which no ack has been received yet", false, false, "int",
                               false, (Function<org.jgroups.protocols.FORWARD_TO_COORD, ?>) org.jgroups.protocols.FORWARD_TO_COORD::getForwardTableSize, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FORWARD_TO_COORD.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumRules", "The number of rules currently installed", false, false, "int",
                               false, (Function<org.jgroups.protocols.rules.SUPERVISOR, ?>) org.jgroups.protocols.rules.SUPERVISOR::getNumRules, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.rules.SUPERVISOR.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumSendConnections", "Returns the number of outgoing (send) connections", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumSendConnections, null));
      attributes.add(new AttributeMetadata("getNumReceiveConnections", "Returns the number of incoming (receive) connections", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumReceiveConnections, null));
      attributes.add(new AttributeMetadata("getTimestamper", "Next seqno issued by the timestamper", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getTimestamper, null));
      attributes.add(new AttributeMetadata("getNumMessagesReceived", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumMessagesReceived, null));
      attributes.add(new AttributeMetadata("getNumAcksSent", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumAcksSent, null));
      attributes.add(new AttributeMetadata("getNumAcksReceived", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumAcksReceived, null));
      attributes.add(new AttributeMetadata("getNumXmits", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumXmits, null));
      attributes.add(new AttributeMetadata("getAgeOutCacheSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getAgeOutCacheSize, null));
      attributes.add(new AttributeMetadata("getNumUnackedMessages", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumUnackedMessages, null));
      attributes.add(new AttributeMetadata("getXmitTableUndeliveredMessages", "Total number of undelivered messages in all receive windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableUndeliveredMessages, null));
      attributes.add(new AttributeMetadata("getXmitTableDeliverableMessages", "Total number of deliverable messages in all receive windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableDeliverableMessages, null));
      attributes.add(new AttributeMetadata("getNumMessagesSent", "", false, false, "long",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumMessagesSent, null));
      attributes.add(new AttributeMetadata("getNumConnections", "Returns the total number of outgoing (send) and incoming (receive) connections", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getNumConnections, null));
      attributes.add(new AttributeMetadata("getXmitTableMissingMessages", "Total number of missing messages in all receive windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableMissingMessages, null));
      attributes.add(new AttributeMetadata("getXmitTableNumCompactions", "Number of compactions in all (receive and send) windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableNumCompactions, null));
      attributes.add(new AttributeMetadata("getXmitTableNumMoves", "Number of moves in all (receive and send) windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableNumMoves, null));
      attributes.add(new AttributeMetadata("getXmitTableNumResizes", "Number of resizes in all (receive and send) windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableNumResizes, null));
      attributes.add(new AttributeMetadata("getXmitTableNumPurges", "Number of purges in all (receive and send) windows", false, false, "int",
                               false, (Function<org.jgroups.protocols.UNICAST3, ?>) org.jgroups.protocols.UNICAST3::getXmitTableNumPurges, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UNICAST3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("latencyInNs", "Average latency in ns", false, false, "double",
                               false, (Function<org.jgroups.protocols.PERF, ?>) org.jgroups.protocols.PERF::latencyInNs, null));
      attributes.add(new AttributeMetadata("latencyInMs", "Average latency in ms", false, false, "double",
                               false, (Function<org.jgroups.protocols.PERF, ?>) org.jgroups.protocols.PERF::latencyInMs, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.PERF.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getFwdQueueSize", "Number of messages in the forward-queue", false, false, "int",
                               false, (Function<org.jgroups.protocols.SEQUENCER2, ?>) org.jgroups.protocols.SEQUENCER2::getFwdQueueSize, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SEQUENCER2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getOpenConnections", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getOpenConnections, null));
      attributes.add(new AttributeMetadata("numSelects", "Number of times select() was called", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::numSelects, null));
      attributes.add(new AttributeMetadata("numPartialWrites", "Number of partial writes for all connections (not all bytes were written)", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::numPartialWrites, null));
      attributes.add(new AttributeMetadata("getBundlerBufferSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getBundlerBufferSize, null));
      attributes.add(new AttributeMetadata("bundlerNumSpins", "Number of spins before a real lock is acquired", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::bundlerNumSpins, null));
      attributes.add(new AttributeMetadata("getNumberOfThreadDumps", "Number of thread dumps", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getNumberOfThreadDumps, null));
      attributes.add(new AttributeMetadata("getDifferentClusterMessages", "Number of messages from members in a different cluster", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getDifferentClusterMessages, null));
      attributes.add(new AttributeMetadata("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getDifferentVersionMessages, null));
      attributes.add(new AttributeMetadata("getThreadPoolSize", "Current number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeActive", "Current number of active threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getThreadPoolSizeActive, null));
      attributes.add(new AttributeMetadata("getThreadPoolSizeLargest", "Largest number of threads in the thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSize", "Current number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getInternalThreadPoolSize, null));
      attributes.add(new AttributeMetadata("getInternalThreadPoolSizeLargest", "Largest number of threads in the internal thread pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getInternalThreadPoolSizeLargest, null));
      attributes.add(new AttributeMetadata("getNumTimerTasks", "Number of timer tasks queued up for execution", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getNumTimerTasks, null));
      attributes.add(new AttributeMetadata("getTimerThreads", "Number of threads currently in the pool", false, false, "int",
                               false, (Function<org.jgroups.protocols.TCP_NIO2, ?>) org.jgroups.protocols.TCP_NIO2::getTimerThreads, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TCP_NIO2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfQueuedMessages, null));
      attributes.add(new AttributeMetadata("getQueuedSize", "The total size of all currently queued messages for all destinations", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getQueuedSize, null));
      attributes.add(new AttributeMetadata("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfQueuings, null));
      attributes.add(new AttributeMetadata("getNumberOfBlockings", "Number of times flow control blocks sender", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfBlockings, null));
      attributes.add(new AttributeMetadata("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", false, false, "double",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getAverageTimeBlocked, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsReceived", "Number of credit requests received", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfCreditRequestsReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsSent", "Number of credit requests sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfCreditRequestsSent, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesReceived", "Number of credit responses received", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfCreditResponsesReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesSent", "Number of credit responses sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.UFC_NB, ?>) org.jgroups.protocols.UFC_NB::getNumberOfCreditResponsesSent, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UFC_NB.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfQueuedMessages, null));
      attributes.add(new AttributeMetadata("getQueuedSize", "The total size of all currently queued messages", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getQueuedSize, null));
      attributes.add(new AttributeMetadata("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfQueuings, null));
      attributes.add(new AttributeMetadata("getNumberOfBlockings", "Number of times flow control blocks sender", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfBlockings, null));
      attributes.add(new AttributeMetadata("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", false, false, "double",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getAverageTimeBlocked, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsReceived", "Number of credit requests received", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfCreditRequestsReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditRequestsSent", "Number of credit requests sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfCreditRequestsSent, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesReceived", "Number of credit responses received", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfCreditResponsesReceived, null));
      attributes.add(new AttributeMetadata("getNumberOfCreditResponsesSent", "Number of credit responses sent", false, false, "int",
                               false, (Function<org.jgroups.protocols.MFC_NB, ?>) org.jgroups.protocols.MFC_NB::getNumberOfCreditResponsesSent, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MFC_NB.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("requestQueueSize", "", false, false, "int",
                               false, (Function<org.jgroups.protocols.CENTRAL_LOCK2, ?>) org.jgroups.protocols.CENTRAL_LOCK2::requestQueueSize, null));
      attributes.add(new AttributeMetadata("getNumServerLocks", "Number of server locks (only on coord)", false, false, "int",
                               false, (Function<org.jgroups.protocols.CENTRAL_LOCK2, ?>) org.jgroups.protocols.CENTRAL_LOCK2::getNumServerLocks, null));
      attributes.add(new AttributeMetadata("getNumClientLocks", "Number of client locks", false, false, "int",
                               false, (Function<org.jgroups.protocols.CENTRAL_LOCK2, ?>) org.jgroups.protocols.CENTRAL_LOCK2::getNumClientLocks, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.CENTRAL_LOCK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getForkStacks", "Number of fork-stacks", false, false, "int",
                               false, (Function<org.jgroups.protocols.FORK, ?>) org.jgroups.protocols.FORK::getForkStacks, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FORK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new AttributeMetadata("getDroppedMessages", "The number of dropped messages", false, false, "long",
                               false, (Function<org.jgroups.protocols.RED, ?>) org.jgroups.protocols.RED::getDroppedMessages, null));
      attributes.add(new AttributeMetadata("getTotalMessages", "Total number of messages processed", false, false, "long",
                               false, (Function<org.jgroups.protocols.RED, ?>) org.jgroups.protocols.RED::getTotalMessages, null));
      attributes.add(new AttributeMetadata("getDropRate", "Percentage of all messages that were dropped", false, false, "double",
                               false, (Function<org.jgroups.protocols.RED, ?>) org.jgroups.protocols.RED::getDropRate, null));
      PROTOCOL_METADATA.put(org.jgroups.protocols.RED.class, attributes);
   }
}

