/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IracExecutor
implements Function<Void, CompletionStage<Void>>,
Runnable {
    private static final Log log = LogFactory.getLog(IracExecutor.class);
    private final WrappedRunnable runnable;
    private volatile CompletableFuture<Void> lastRunnable;
    private volatile Executor executor;
    private volatile ExponentialBackOff backOff;
    final AtomicBoolean hasPendingRunnable;
    private volatile boolean backOffEnabled;

    public IracExecutor(Supplier<CompletionStage<Void>> runnable) {
        this.runnable = new WrappedRunnable(Objects.requireNonNull(runnable));
        this.lastRunnable = CompletableFutures.completedNull();
        this.executor = new WithinThreadExecutor();
        this.hasPendingRunnable = new AtomicBoolean();
    }

    public void setExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public void setBackOff(ExponentialBackOff backOff) {
        this.backOff = Objects.requireNonNull(backOff);
    }

    @Override
    public void run() {
        if (this.hasPendingRunnable.compareAndSet(false, true)) {
            this.lastRunnable = this.backOffEnabled ? ((CompletableFuture)this.lastRunnable.thenCompose((Function)this)).thenComposeAsync((Function)this.runnable, this.executor) : this.lastRunnable.thenComposeAsync((Function)this.runnable, this.executor);
        }
    }

    public void enableBackOff() {
        this.backOffEnabled = true;
    }

    public void disableBackOff() {
        this.backOffEnabled = false;
        this.backOff.reset();
    }

    @Override
    public CompletionStage<Void> apply(Void unused) {
        return this.backOff.asyncBackOff();
    }

    private class WrappedRunnable
    implements Function<Void, CompletionStage<Void>> {
        private final Supplier<CompletionStage<Void>> runnable;

        private WrappedRunnable(Supplier<CompletionStage<Void>> runnable) {
            this.runnable = runnable;
        }

        @Override
        public CompletionStage<Void> apply(Void unused) {
            IracExecutor.this.hasPendingRunnable.set(false);
            try {
                return this.runnable.get();
            }
            catch (Throwable e) {
                log.unexpectedErrorFromIrac(e);
                return CompletableFutures.completedNull();
            }
        }
    }
}

