/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Arrays;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=28)
public class InvalidateCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 6;
    private static final Log log = LogFactory.getLog(InvalidateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object[] keys;

    public InvalidateCommand() {
    }

    public InvalidateCommand(CacheNotifier notifier, Object ... keys) {
        this.keys = keys;
        this.notifier = notifier;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        if (trace) {
            log.trace((Object)"Invalidating keys {0}", Arrays.toString(this.keys));
        }
        for (Object k : this.keys) {
            this.invalidate(ctx, k);
        }
        return null;
    }

    protected void invalidate(InvocationContext ctx, Object keyToInvalidate) throws Throwable {
        this.key = keyToInvalidate;
        super.perform(ctx);
    }

    protected void notify(InvocationContext ctx, Object value, boolean isPre) {
        this.notifier.notifyCacheEntryInvalidated(this.key, isPre, ctx);
    }

    public byte getCommandId() {
        return 6;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "keys=" + Arrays.toString(this.keys) + '}';
    }

    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{0};
        }
        if (this.keys.length == 1) {
            return new Object[]{1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 1];
        retval[0] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 1, this.keys.length);
        return retval;
    }

    public void setParameters(int commandId, Object[] args) {
        int size = (Integer)args[0];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[1];
        } else if (size > 0) {
            System.arraycopy(args, 1, this.keys, 0, size);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    public Object getKey() {
        throw new UnsupportedOperationException("Not supported.  Use getKeys() instead.");
    }

    public Object[] getKeys() {
        return this.keys;
    }
}

