/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.config.CloneableConfigurationComponent;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.Dynamic;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractConfigurationBean
implements CloneableConfigurationComponent {
    private static final long serialVersionUID = 4879873994727821938L;
    protected static final TypedProperties EMPTY_PROPERTIES = new TypedProperties();
    protected transient Log log = LogFactory.getLog(this.getClass());
    private boolean accessible;
    protected List<String> overriddenConfigurationElements = new LinkedList<String>();

    protected AbstractConfigurationBean() {
    }

    protected String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    protected TypedProperties toTypedProperties(Properties p) {
        return TypedProperties.toTypedProperties(p);
    }

    protected TypedProperties toTypedProperties(String s) {
        TypedProperties tp = new TypedProperties();
        if (s != null && s.trim().length() > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes());
            try {
                tp.load(stream);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to parse properties string " + s, e);
            }
        }
        return tp;
    }

    protected abstract boolean hasComponentStarted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testImmutability(String fieldName) {
        try {
            if (!this.accessible && this.hasComponentStarted() && !this.getClass().getDeclaredField(fieldName).isAnnotationPresent(Dynamic.class)) {
                throw new ConfigurationException("Attempted to modify a non-Dynamic configuration element [" + fieldName + "] after the component has started!");
            }
        }
        catch (NoSuchFieldException e) {
            this.log.warn("Field " + fieldName + " not found!!");
        }
        finally {
            this.accessible = false;
        }
        this.overriddenConfigurationElements.add(fieldName);
    }

    public void applyOverrides(AbstractConfigurationBean overrides) {
        for (String overridenField : overrides.overriddenConfigurationElements) {
            try {
                ReflectionUtil.setValue(this, overridenField, ReflectionUtil.getValue(overrides, overridenField));
            }
            catch (Exception e1) {
                throw new CacheException("Could not apply value for field " + overridenField + " from instance " + overrides + " on instance " + this, e1);
            }
        }
        List<Field> fields = ReflectionUtil.getFields(overrides.getClass(), AbstractConfigurationBean.class);
        for (Field field : fields) {
            if (!AbstractConfigurationBean.class.isAssignableFrom(field.getType())) continue;
            AbstractConfigurationBean fieldValueOverrides = null;
            AbstractConfigurationBean fieldValueThis = null;
            try {
                field.setAccessible(true);
                fieldValueOverrides = (AbstractConfigurationBean)field.get(overrides);
                fieldValueThis = (AbstractConfigurationBean)field.get(this);
                if (fieldValueThis == null && fieldValueOverrides != null) {
                    field.set(this, fieldValueOverrides);
                    continue;
                }
                if (fieldValueOverrides == null || fieldValueThis == null) continue;
                fieldValueThis.applyOverrides(fieldValueOverrides);
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not apply override for field " + field + " in class " + overrides), e);
            }
        }
        fields = ReflectionUtil.getFields(overrides.getClass(), Collection.class);
        for (Field field : fields) {
            Type[] fieldArgTypes;
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) continue;
            ParameterizedType aType = (ParameterizedType)genericType;
            for (Type fieldArgType : fieldArgTypes = aType.getActualTypeArguments()) {
                Class fieldArgClass = (Class)fieldArgType;
                if (fieldArgClass.isPrimitive() || fieldArgClass.equals(String.class)) continue;
                try {
                    field.setAccessible(true);
                    Collection c = (Collection)field.get(this);
                    Collection c2 = (Collection)field.get(overrides);
                    if (c.isEmpty() && !c2.isEmpty()) {
                        c.addAll(c2);
                        continue;
                    }
                    if (c.isEmpty() || c2.isEmpty()) continue;
                    Iterator i = c.iterator();
                    Iterator i2 = c2.iterator();
                    while (i.hasNext() && i2.hasNext()) {
                        Object nextThis = i.next();
                        Object nextOverrides = i2.next();
                        if (!AbstractConfigurationBean.class.isAssignableFrom(nextThis.getClass()) || !AbstractConfigurationBean.class.isAssignableFrom(nextOverrides.getClass())) continue;
                        ((AbstractConfigurationBean)nextThis).applyOverrides((AbstractConfigurationBean)nextOverrides);
                    }
                    while (i2.hasNext()) {
                        c.add(i2.next());
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not apply override for field " + field + " in class " + overrides.getClass()), e);
                }
            }
        }
    }

    public CloneableConfigurationComponent clone() throws CloneNotSupportedException {
        AbstractConfigurationBean c = (AbstractConfigurationBean)super.clone();
        return c;
    }
}

