/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationElement(name="loaders", parent="default")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CacheLoaderManagerConfig
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 2210349340378984424L;
    @XmlAttribute
    private Boolean passivation = false;
    @XmlAttribute
    private Boolean preload = false;
    @XmlAttribute
    private Boolean shared = false;
    @XmlElement(name="loader")
    private List<CacheLoaderConfig> cacheLoaderConfigs = new LinkedList<CacheLoaderConfig>();

    @ConfigurationAttribute(name="preload", containingElement="loaders")
    public void setPreload(boolean preload) {
        this.testImmutability("preload");
        this.preload = preload;
    }

    @ConfigurationAttribute(name="passivation", containingElement="loaders")
    public void setPassivation(boolean passivation) {
        this.testImmutability("passivation");
        this.passivation = passivation;
    }

    public boolean isPassivation() {
        return this.passivation;
    }

    public void addCacheLoaderConfig(CacheLoaderConfig clc) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs.add(clc);
    }

    public List<CacheLoaderConfig> getCacheLoaderConfigs() {
        return this.cacheLoaderConfigs;
    }

    public void setCacheLoaderConfigs(List<CacheLoaderConfig> configs) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs = configs == null ? new LinkedList() : configs;
    }

    public CacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.size() == 0) {
            return null;
        }
        return this.cacheLoaderConfigs.get(0);
    }

    public boolean useChainingCacheLoader() {
        return !this.isPassivation() && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return "CacheLoaderManagerConfig{" + "shared=" + this.shared + ", passivation=" + this.passivation + ", preload='" + this.preload + '\'' + ", cacheLoaderConfigs.size()=" + this.cacheLoaderConfigs.size() + '}';
    }

    @ConfigurationAttribute(name="shared", containingElement="loaders")
    public void setShared(boolean shared) {
        this.testImmutability("shared");
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CacheLoaderManagerConfig) {
            CacheLoaderManagerConfig other = (CacheLoaderManagerConfig)obj;
            return this.passivation == other.passivation && this.shared == other.shared && Util.safeEquals(this.preload, other.preload) && Util.safeEquals(this.cacheLoaderConfigs, other.cacheLoaderConfigs);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result = 51 * result + (this.passivation != false ? 0 : 1);
        result = 51 * result + (this.shared != false ? 0 : 1);
        result = 51 * result + (this.preload != false ? 0 : 1);
        result = 51 * result + (this.cacheLoaderConfigs == null ? 0 : ((Object)this.cacheLoaderConfigs).hashCode());
        return result;
    }

    @Override
    public CacheLoaderManagerConfig clone() throws CloneNotSupportedException {
        CacheLoaderManagerConfig clone = (CacheLoaderManagerConfig)super.clone();
        if (this.cacheLoaderConfigs != null) {
            LinkedList<CacheLoaderConfig> clcs = new LinkedList<CacheLoaderConfig>();
            for (CacheLoaderConfig clc : this.cacheLoaderConfigs) {
                clcs.add(clc.clone());
            }
            clone.cacheLoaderConfigs = clcs;
        }
        return clone;
    }

    public boolean isFetchPersistentState() {
        for (CacheLoaderConfig iclc : this.cacheLoaderConfigs) {
            if (!(iclc instanceof CacheStoreConfig) || !((CacheStoreConfig)iclc).isFetchPersistentState()) continue;
            return true;
        }
        return false;
    }

    public boolean isPreload() {
        return this.preload;
    }
}

