/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.infinispan.CacheException;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.Dynamic;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DefaultConsistentHash;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.annotations.Start;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
@ConfigurationElements(elements={@ConfigurationElement(name="default", parent="infinispan", description="This section configures the default cache.  This is also used as a template for other named caches defined."), @ConfigurationElement(name="namedCache", parent="infinispan", description="This section overrides the default cache configuration.  Named sections are applied to caches obtained via CacheManager.getCache(name)."), @ConfigurationElement(name="locking", parent="default", description="This element defines locking characteristics of the cache."), @ConfigurationElement(name="transaction", parent="default", description="This element defines transactionat (JTA) characteristics of the cache."), @ConfigurationElement(name="jmxStatistics", parent="default", description="This element defines how JMX components are bound to an MBean server."), @ConfigurationElement(name="lazyDeserialization", parent="default", description="This element defines lazy deserialization characteristics of the cache."), @ConfigurationElement(name="invocationBatching", parent="default", description="This section defines whether invocation batching is allowed in this cache instance."), @ConfigurationElement(name="clustering", parent="default", description="This section defines clustering characteristics of the cache."), @ConfigurationElement(name="stateRetrieval", parent="clustering", description="This section configures how state retrieval is performed on new caches in a cluster."), @ConfigurationElement(name="sync", parent="clustering", description="Specifies that network communications are synchronous.  Charcteristics of this can be tuned here."), @ConfigurationElement(name="hash", parent="clustering", description="Allows you to fine-tune rehashing characteristics.  Only used with the 'distributed' cache mode, and otherwise ignored."), @ConfigurationElement(name="l1", parent="clustering", description="Enables and defines details of the L1 cache.  Only used with the 'distributed' cache mode, and otherwise ignored."), @ConfigurationElement(name="async", parent="clustering", description="Specifies that network communications are asynchronous.  Charcteristics of this can be tuned here."), @ConfigurationElement(name="eviction", parent="default", description="Enables or disables eviction, and configures characteristics accordingly."), @ConfigurationElement(name="expiration", parent="default", description="Enables or disables expiration, and configures characteristics accordingly."), @ConfigurationElement(name="unsafe", parent="default", description="Allows you to tune various unsafe or non-standard characteristics.  Use with care."), @ConfigurationElement(name="deadlockDetection", parent="default", description="Enables or disables, and tunes, deadlock detection."), @ConfigurationElement(name="customInterceptors", parent="default", description="Configures custom interceptors to be added to the cache.")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
public class Configuration
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 5553791890144997466L;
    @XmlTransient
    private GlobalConfiguration globalConfiguration;
    @XmlAttribute
    private String name;
    @XmlElement
    private LockingType locking = new LockingType();
    @XmlElement
    private CacheLoaderManagerConfig loaders = new CacheLoaderManagerConfig();
    @XmlElement
    private TransactionType transaction = new TransactionType(null);
    @XmlElement
    private CustomInterceptorsType customInterceptors = new CustomInterceptorsType();
    @XmlElement
    private EvictionType eviction = new EvictionType();
    @XmlElement
    private ExpirationType expiration = new ExpirationType();
    @XmlElement
    private UnsafeType unsafe = new UnsafeType();
    @XmlElement
    private ClusteringType clustering = new ClusteringType();
    @XmlElement
    private BooleanAttributeType jmxStatistics = new BooleanAttributeType();
    @XmlElement
    private BooleanAttributeType lazyDeserialization = new BooleanAttributeType();
    @XmlElement
    private BooleanAttributeType invocationBatching = new BooleanAttributeType();
    @XmlElement
    private DeadlockDetectionType deadlockDetection = new DeadlockDetectionType();

    @Start(priority=1)
    private void correctIsolationLevels() {
        switch (this.locking.isolationLevel) {
            case NONE: 
            case READ_UNCOMMITTED: {
                this.locking.isolationLevel = IsolationLevel.READ_COMMITTED;
                break;
            }
            case SERIALIZABLE: {
                this.locking.isolationLevel = IsolationLevel.REPEATABLE_READ;
            }
        }
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public String getName() {
        return this.name;
    }

    @Inject
    private void injectGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public boolean isStateTransferEnabled() {
        return this.clustering.stateRetrieval.fetchInMemoryState != false || this.loaders != null && this.loaders.isFetchPersistentState();
    }

    public long getDeadlockDetectionSpinDuration() {
        return this.deadlockDetection.spinDuration;
    }

    @ConfigurationAttribute(name="spinDuration", containingElement="deadlockDetection", description="Allows you to tune how long the inner deadlock detection loop should spin for (in milliseconds)", defaultValue="100")
    public void setDeadlockDetectionSpinDuration(long eagerDeadlockSpinDuration) {
        this.deadlockDetection.setSpinDuration(eagerDeadlockSpinDuration);
    }

    public boolean isEnableDeadlockDetection() {
        return this.deadlockDetection.enabled;
    }

    @ConfigurationAttribute(name="enabled", containingElement="deadlockDetection", description="Enables deadlock detection.", defaultValue="false")
    public void setEnableDeadlockDetection(boolean useEagerDeadlockDetection) {
        this.deadlockDetection.setEnabled(useEagerDeadlockDetection);
    }

    public void setUseLockStriping(boolean useLockStriping) {
        this.locking.setUseLockStriping(useLockStriping);
    }

    public boolean isUseLockStriping() {
        return this.locking.useLockStriping;
    }

    public boolean isUnsafeUnreliableReturnValues() {
        return this.unsafe.unreliableReturnValues;
    }

    @ConfigurationAttribute(name="unreliableReturnValues", containingElement="unsafe", description="If enabled, forces distribution code to skip looking up remote values when overwriting, rendering return values from certain methods (e.g., Cache.put()) unreliable.  Use with care.  Only used with 'distributed' cache mode.", defaultValue="false")
    public void setUnsafeUnreliableReturnValues(boolean unsafeUnreliableReturnValues) {
        this.unsafe.setUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    @ConfigurationAttribute(name="rehashRpcTimeout", containingElement="hash", description="Timeout for rehash-related RPC calls, in milliseconds.", defaultValue="600000")
    public void setRehashRpcTimeout(long rehashRpcTimeout) {
        this.clustering.hash.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public long getRehashRpcTimeout() {
        return this.clustering.hash.rehashRpcTimeout;
    }

    public boolean isWriteSkewCheck() {
        return this.locking.writeSkewCheck;
    }

    @ConfigurationAttribute(name="writeSkewCheck", containingElement="locking")
    public void setWriteSkewCheck(boolean writeSkewCheck) {
        this.locking.setWriteSkewCheck(writeSkewCheck);
    }

    public int getConcurrencyLevel() {
        return this.locking.concurrencyLevel;
    }

    @ConfigurationAttribute(name="concurrencyLevel", containingElement="locking")
    public void setConcurrencyLevel(int concurrencyLevel) {
        this.locking.setConcurrencyLevel(concurrencyLevel);
    }

    @ConfigurationAttribute(name="replQueueMaxElements", containingElement="async")
    public void setReplQueueMaxElements(int replQueueMaxElements) {
        this.clustering.async.setReplQueueMaxElements(replQueueMaxElements);
    }

    @ConfigurationAttribute(name="replQueueInterval", containingElement="async")
    public void setReplQueueInterval(long replQueueInterval) {
        this.clustering.async.setReplQueueInterval(replQueueInterval);
    }

    public void setReplQueueInterval(long replQueueInterval, TimeUnit timeUnit) {
        this.setReplQueueInterval(timeUnit.toMillis(replQueueInterval));
    }

    @ConfigurationAttribute(name="enabled", containingElement="jmxStatistics")
    public void setExposeJmxStatistics(boolean useMbean) {
        this.jmxStatistics.setEnabled(useMbean);
    }

    @ConfigurationAttribute(name="enabled", containingElement="invocationBatching")
    public void setInvocationBatchingEnabled(boolean enabled) {
        this.invocationBatching.setEnabled(enabled);
    }

    @ConfigurationAttribute(name="fetchInMemoryState", containingElement="stateRetrieval")
    public void setFetchInMemoryState(boolean fetchInMemoryState) {
        this.clustering.stateRetrieval.setFetchInMemoryState(fetchInMemoryState);
    }

    @ConfigurationAttribute(name="lockAcquisitionTimeout", containingElement="locking")
    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.locking.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout, TimeUnit timeUnit) {
        this.setLockAcquisitionTimeout(timeUnit.toMillis(lockAcquisitionTimeout));
    }

    @ConfigurationAttribute(name="replTimeout", containingElement="sync")
    public void setSyncReplTimeout(long syncReplTimeout) {
        this.clustering.sync.setReplTimeout(syncReplTimeout);
    }

    public void setSyncReplTimeout(long syncReplTimeout, TimeUnit timeUnit) {
        this.setSyncReplTimeout(timeUnit.toMillis(syncReplTimeout));
    }

    public void setCacheMode(CacheMode cacheModeInt) {
        this.clustering.setMode(cacheModeInt);
    }

    @ConfigurationAttribute(name="mode", containingElement="clustering", allowedValues={"LOCAL", "REPL", "INVALIDATION", "DIST"})
    public void setCacheMode(String cacheMode) {
        if (cacheMode == null) {
            throw new ConfigurationException("Cache mode cannot be null", "CacheMode");
        }
        this.clustering.setMode(CacheMode.valueOf(this.uc(cacheMode)));
        if (this.clustering.mode == null) {
            this.log.warn("Unknown cache mode '" + cacheMode + "', using defaults.");
            this.clustering.setMode(CacheMode.LOCAL);
        }
    }

    public String getCacheModeString() {
        return this.clustering.mode == null ? null : this.clustering.mode.toString();
    }

    public void setCacheModeString(String cacheMode) {
        this.setCacheMode(cacheMode);
    }

    public long getEvictionWakeUpInterval() {
        return this.eviction.wakeUpInterval;
    }

    @ConfigurationAttribute(name="wakeUpInterval", containingElement="eviction")
    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.eviction.setWakeUpInterval(evictionWakeUpInterval);
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.eviction.strategy;
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.eviction.setStrategy(evictionStrategy);
    }

    @ConfigurationAttribute(name="strategy", containingElement="eviction", allowedValues={"NONE", "FIFO", "LRU"})
    public void setEvictionStrategy(String eStrategy) {
        this.eviction.strategy = EvictionStrategy.valueOf(this.uc(eStrategy));
        if (this.eviction.strategy == null) {
            this.log.warn("Unknown evictionStrategy  '" + eStrategy + "', using defaults.");
            this.eviction.setStrategy(EvictionStrategy.NONE);
        }
    }

    public int getEvictionMaxEntries() {
        return this.eviction.maxEntries;
    }

    @ConfigurationAttribute(name="maxEntries", containingElement="eviction")
    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.eviction.setMaxEntries(evictionMaxEntries);
    }

    public long getExpirationLifespan() {
        return this.expiration.lifespan;
    }

    @ConfigurationAttribute(name="lifespan", containingElement="expiration")
    public void setExpirationLifespan(long expirationLifespan) {
        this.expiration.setLifespan(expirationLifespan);
    }

    public long getExpirationMaxIdle() {
        return this.expiration.maxIdle;
    }

    @ConfigurationAttribute(name="maxIdle", containingElement="expiration")
    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.expiration.setMaxIdle(expirationMaxIdle);
    }

    @ConfigurationAttribute(name="transactionManagerLookupClass", containingElement="transaction", description="", defaultValue="org.infinispan.transaction.lookup.GenericTransactionManagerLookup")
    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.transaction.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transaction.transactionManagerLookup = transactionManagerLookup;
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.loaders = cacheLoaderManagerConfig;
    }

    @ConfigurationAttribute(name="syncCommitPhase", containingElement="transaction")
    public void setSyncCommitPhase(boolean syncCommitPhase) {
        this.transaction.setSyncCommitPhase(syncCommitPhase);
    }

    @ConfigurationAttribute(name="syncRollbackPhase", containingElement="transaction")
    public void setSyncRollbackPhase(boolean syncRollbackPhase) {
        this.transaction.setSyncRollbackPhase(syncRollbackPhase);
    }

    @ConfigurationAttribute(name="useEagerLocking", containingElement="transaction")
    public void setUseEagerLocking(boolean useEagerLocking) {
        this.transaction.setUseEagerLocking(useEagerLocking);
    }

    @ConfigurationAttribute(name="useReplQueue", containingElement="async")
    public void setUseReplQueue(boolean useReplQueue) {
        this.clustering.async.setUseReplQueue(useReplQueue);
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.locking.setIsolationLevel(isolationLevel);
    }

    @ConfigurationAttribute(name="timeout", containingElement="stateRetrieval")
    public void setStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.clustering.stateRetrieval.setTimeout(stateRetrievalTimeout);
    }

    public void setStateRetrievalTimeout(long stateRetrievalTimeout, TimeUnit timeUnit) {
        this.setStateRetrievalTimeout(timeUnit.toMillis(stateRetrievalTimeout));
    }

    @ConfigurationAttribute(name="isolationLevel", containingElement="locking", allowedValues={"NONE", "SERIALIZABLE", "REPEATABLE_READ", "READ_COMMITTED", "READ_UNCOMMITTED"})
    public void setIsolationLevel(String isolationLevel) {
        if (isolationLevel == null) {
            throw new ConfigurationException("Isolation level cannot be null", "IsolationLevel");
        }
        this.locking.setIsolationLevel(IsolationLevel.valueOf(this.uc(isolationLevel)));
        if (this.locking.isolationLevel == null) {
            this.log.warn("Unknown isolation level '" + isolationLevel + "', using defaults.");
            this.locking.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        }
    }

    @ConfigurationAttribute(name="enabled", containingElement="lazyDeserialization")
    public void setUseLazyDeserialization(boolean useLazyDeserialization) {
        this.lazyDeserialization.setEnabled(useLazyDeserialization);
    }

    @ConfigurationAttribute(name="enabled", containingElement="l1")
    public void setL1CacheEnabled(boolean l1CacheEnabled) {
        this.clustering.l1.setEnabled(l1CacheEnabled);
    }

    @ConfigurationAttribute(name="lifespan", containingElement="l1")
    public void setL1Lifespan(long l1Lifespan) {
        this.clustering.l1.setLifespan(l1Lifespan);
    }

    @ConfigurationAttribute(name="onRehash", containingElement="l1")
    public void setL1OnRehash(boolean l1OnRehash) {
        this.clustering.l1.setOnRehash(l1OnRehash);
    }

    @ConfigurationAttribute(name="consistentHashClass", containingElement="hash")
    public void setConsistentHashClass(String consistentHashClass) {
        this.clustering.hash.setConsistentHashClass(consistentHashClass);
    }

    @ConfigurationAttribute(name="numOwners", containingElement="hash")
    public void setNumOwners(int numOwners) {
        this.clustering.hash.setNumOwners(numOwners);
    }

    @ConfigurationAttribute(name="rehashWait", containingElement="hash")
    public void setRehashWaitTime(long rehashWaitTime) {
        this.clustering.hash.setRehashWait(rehashWaitTime);
    }

    @ConfigurationAttribute(name="asyncMarshalling", containingElement="async")
    public void setUseAsyncMarshalling(boolean useAsyncMarshalling) {
        this.clustering.async.setAsyncMarshalling(useAsyncMarshalling);
    }

    public boolean isUseAsyncMarshalling() {
        return this.clustering.async.asyncMarshalling;
    }

    public boolean isUseReplQueue() {
        return this.clustering.async.useReplQueue;
    }

    public int getReplQueueMaxElements() {
        return this.clustering.async.replQueueMaxElements;
    }

    public long getReplQueueInterval() {
        return this.clustering.async.replQueueInterval;
    }

    public boolean isExposeJmxStatistics() {
        return this.jmxStatistics.enabled;
    }

    public boolean isInvocationBatchingEnabled() {
        return this.invocationBatching.enabled;
    }

    public boolean isFetchInMemoryState() {
        return this.clustering.stateRetrieval.fetchInMemoryState;
    }

    public long getLockAcquisitionTimeout() {
        return this.locking.lockAcquisitionTimeout;
    }

    public long getSyncReplTimeout() {
        return this.clustering.sync.replTimeout;
    }

    public CacheMode getCacheMode() {
        return this.clustering.mode;
    }

    public IsolationLevel getIsolationLevel() {
        return this.locking.isolationLevel;
    }

    public String getTransactionManagerLookupClass() {
        return this.transaction.transactionManagerLookupClass;
    }

    public TransactionManagerLookup getTransactionManagerLookup() {
        return this.transaction.transactionManagerLookup;
    }

    public CacheLoaderManagerConfig getCacheLoaderManagerConfig() {
        return this.loaders;
    }

    public boolean isSyncCommitPhase() {
        return this.transaction.syncCommitPhase;
    }

    public boolean isSyncRollbackPhase() {
        return this.transaction.syncRollbackPhase;
    }

    public boolean isUseEagerLocking() {
        return this.transaction.useEagerLocking;
    }

    public long getStateRetrievalTimeout() {
        return this.clustering.stateRetrieval.timeout;
    }

    public boolean isUseLazyDeserialization() {
        return this.lazyDeserialization.enabled;
    }

    public boolean isL1CacheEnabled() {
        return this.clustering.l1.enabled;
    }

    public long getL1Lifespan() {
        return this.clustering.l1.lifespan;
    }

    public boolean isL1OnRehash() {
        return this.clustering.l1.onRehash;
    }

    public String getConsistentHashClass() {
        return this.clustering.hash.consistentHashClass;
    }

    public int getNumOwners() {
        return this.clustering.hash.numOwners;
    }

    public long getRehashWaitTime() {
        return this.clustering.hash.rehashWait;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.locking.concurrencyLevel != that.locking.concurrencyLevel) {
            return false;
        }
        if (this.eviction.maxEntries != that.eviction.maxEntries) {
            return false;
        }
        if (this.eviction.wakeUpInterval != that.eviction.wakeUpInterval) {
            return false;
        }
        if (this.expiration.lifespan != that.expiration.lifespan) {
            return false;
        }
        if (this.expiration.maxIdle != that.expiration.maxIdle) {
            return false;
        }
        if (this.jmxStatistics.enabled != that.jmxStatistics.enabled) {
            return false;
        }
        if (this.clustering.stateRetrieval.fetchInMemoryState != that.clustering.stateRetrieval.fetchInMemoryState) {
            return false;
        }
        if (this.invocationBatching.enabled != that.invocationBatching.enabled) {
            return false;
        }
        if (this.clustering.l1.enabled != that.clustering.l1.enabled) {
            return false;
        }
        if (this.clustering.l1.lifespan != that.clustering.l1.lifespan) {
            return false;
        }
        if (this.clustering.hash.rehashWait != that.clustering.hash.rehashWait) {
            return false;
        }
        if (this.clustering.l1.onRehash != that.clustering.l1.onRehash) {
            return false;
        }
        if (this.locking.lockAcquisitionTimeout != that.locking.lockAcquisitionTimeout) {
            return false;
        }
        if (this.clustering.hash.numOwners != that.clustering.hash.numOwners) {
            return false;
        }
        if (this.clustering.async.replQueueInterval != that.clustering.async.replQueueInterval) {
            return false;
        }
        if (this.clustering.async.replQueueMaxElements != that.clustering.async.replQueueMaxElements) {
            return false;
        }
        if (this.clustering.stateRetrieval.timeout != that.clustering.stateRetrieval.timeout) {
            return false;
        }
        if (this.transaction.syncCommitPhase != that.transaction.syncCommitPhase) {
            return false;
        }
        if (this.clustering.sync.replTimeout != that.clustering.sync.replTimeout) {
            return false;
        }
        if (this.clustering.hash.rehashRpcTimeout != that.clustering.hash.rehashRpcTimeout) {
            return false;
        }
        if (this.transaction.syncRollbackPhase != that.transaction.syncRollbackPhase) {
            return false;
        }
        if (this.transaction.useEagerLocking != that.transaction.useEagerLocking) {
            return false;
        }
        if (this.lazyDeserialization.enabled != that.lazyDeserialization.enabled) {
            return false;
        }
        if (this.locking.useLockStriping != that.locking.useLockStriping) {
            return false;
        }
        if (this.clustering.async.useReplQueue != that.clustering.async.useReplQueue) {
            return false;
        }
        if (this.locking.writeSkewCheck != that.locking.writeSkewCheck) {
            return false;
        }
        if (this.loaders != null ? !this.loaders.equals(that.loaders) : that.loaders != null) {
            return false;
        }
        if (this.clustering.mode != that.clustering.mode) {
            return false;
        }
        if (this.clustering.hash.consistentHashClass != null ? !this.clustering.hash.consistentHashClass.equals(that.clustering.hash.consistentHashClass) : that.clustering.hash.consistentHashClass != null) {
            return false;
        }
        if (this.customInterceptors.customInterceptors != null ? !((Object)this.customInterceptors.customInterceptors).equals(that.customInterceptors.customInterceptors) : that.customInterceptors.customInterceptors != null) {
            return false;
        }
        if (this.eviction.strategy != that.eviction.strategy) {
            return false;
        }
        if (this.globalConfiguration != null ? !this.globalConfiguration.equals(that.globalConfiguration) : that.globalConfiguration != null) {
            return false;
        }
        if (this.locking.isolationLevel != that.locking.isolationLevel) {
            return false;
        }
        if (this.transaction.transactionManagerLookupClass != null ? !this.transaction.transactionManagerLookupClass.equals(that.transaction.transactionManagerLookupClass) : that.transaction.transactionManagerLookupClass != null) {
            return false;
        }
        return this.clustering.async.asyncMarshalling == that.clustering.async.asyncMarshalling;
    }

    public int hashCode() {
        int result = this.globalConfiguration != null ? this.globalConfiguration.hashCode() : 0;
        result = 31 * result + (this.locking.useLockStriping != false ? 1 : 0);
        result = 31 * result + (this.clustering.async.useReplQueue != false ? 1 : 0);
        result = 31 * result + this.clustering.async.replQueueMaxElements;
        result = 31 * result + (int)(this.clustering.async.replQueueInterval ^ this.clustering.async.replQueueInterval >>> 32);
        result = 31 * result + (this.jmxStatistics.enabled != false ? 1 : 0);
        result = 31 * result + (this.clustering.stateRetrieval.fetchInMemoryState != false ? 1 : 0);
        result = 31 * result + (int)(this.locking.lockAcquisitionTimeout ^ this.locking.lockAcquisitionTimeout >>> 32);
        result = 31 * result + (int)(this.clustering.sync.replTimeout ^ this.clustering.sync.replTimeout >>> 32);
        result = 31 * result + (this.clustering.mode != null ? this.clustering.mode.hashCode() : 0);
        result = 31 * result + (int)(this.clustering.stateRetrieval.timeout ^ this.clustering.stateRetrieval.timeout >>> 32);
        result = 31 * result + (this.locking.isolationLevel != null ? this.locking.isolationLevel.hashCode() : 0);
        result = 31 * result + (this.transaction.transactionManagerLookupClass != null ? this.transaction.transactionManagerLookupClass.hashCode() : 0);
        result = 31 * result + (this.loaders != null ? this.loaders.hashCode() : 0);
        result = 31 * result + (this.transaction.syncCommitPhase != false ? 1 : 0);
        result = 31 * result + (this.transaction.syncRollbackPhase != false ? 1 : 0);
        result = 31 * result + (this.transaction.useEagerLocking != false ? 1 : 0);
        result = 31 * result + (this.lazyDeserialization.enabled != false ? 1 : 0);
        result = 31 * result + (this.customInterceptors.customInterceptors != null ? ((Object)this.customInterceptors.customInterceptors).hashCode() : 0);
        result = 31 * result + (this.locking.writeSkewCheck != false ? 1 : 0);
        result = 31 * result + this.locking.concurrencyLevel;
        result = 31 * result + (this.invocationBatching.enabled != false ? 1 : 0);
        result = 31 * result + (int)(this.eviction.wakeUpInterval ^ this.eviction.wakeUpInterval >>> 32);
        result = 31 * result + (this.eviction.strategy != null ? this.eviction.strategy.hashCode() : 0);
        result = 31 * result + this.eviction.maxEntries;
        result = 31 * result + (int)(this.expiration.lifespan ^ this.expiration.lifespan >>> 32);
        result = 31 * result + (int)(this.expiration.maxIdle ^ this.expiration.maxIdle >>> 32);
        result = 31 * result + (this.clustering.l1.enabled != false ? 1 : 0);
        result = 31 * result + (int)(this.clustering.l1.lifespan ^ this.clustering.l1.lifespan >>> 32);
        result = 31 * result + (int)(this.clustering.hash.rehashWait ^ this.clustering.hash.rehashWait >>> 32);
        result = 31 * result + (int)(this.clustering.hash.rehashRpcTimeout ^ this.clustering.hash.rehashRpcTimeout >>> 32);
        result = 31 * result + (this.clustering.l1.onRehash != false ? 1 : 0);
        result = 31 * result + (this.clustering.hash.consistentHashClass != null ? this.clustering.hash.consistentHashClass.hashCode() : 0);
        result = 31 * result + this.clustering.hash.numOwners;
        result = 31 * result + (this.clustering.async.asyncMarshalling != false ? 1 : 0);
        return result;
    }

    @Override
    public Configuration clone() {
        try {
            Configuration dolly = (Configuration)super.clone();
            if (this.globalConfiguration != null) {
                dolly.globalConfiguration = this.globalConfiguration.clone();
            }
            if (this.locking != null) {
                dolly.locking = (LockingType)this.locking.clone();
            }
            if (this.loaders != null) {
                dolly.loaders = this.loaders.clone();
            }
            if (this.transaction != null) {
                dolly.transaction = (TransactionType)this.transaction.clone();
            }
            if (this.customInterceptors != null) {
                dolly.customInterceptors = this.customInterceptors.clone();
            }
            if (this.eviction != null) {
                dolly.eviction = (EvictionType)this.eviction.clone();
            }
            if (this.expiration != null) {
                dolly.expiration = (ExpirationType)this.expiration.clone();
            }
            if (this.unsafe != null) {
                dolly.unsafe = (UnsafeType)this.unsafe.clone();
            }
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
            }
            if (this.jmxStatistics != null) {
                dolly.jmxStatistics = (BooleanAttributeType)this.jmxStatistics.clone();
            }
            if (this.lazyDeserialization != null) {
                dolly.lazyDeserialization = (BooleanAttributeType)this.lazyDeserialization.clone();
            }
            if (this.invocationBatching != null) {
                dolly.invocationBatching = (BooleanAttributeType)this.invocationBatching.clone();
            }
            if (this.deadlockDetection != null) {
                dolly.deadlockDetection = (DeadlockDetectionType)this.deadlockDetection.clone();
            }
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Unexpected!", e);
        }
    }

    public boolean isUsingCacheLoaders() {
        return this.getCacheLoaderManagerConfig() != null && !this.getCacheLoaderManagerConfig().getCacheLoaderConfigs().isEmpty();
    }

    public List<CustomInterceptorConfig> getCustomInterceptors() {
        return this.customInterceptors.customInterceptors == null ? Collections.EMPTY_LIST : this.customInterceptors.customInterceptors;
    }

    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.testImmutability("customInterceptors");
        this.customInterceptors.customInterceptors = customInterceptors;
    }

    public void assertValid() throws ConfigurationException {
        if (this.clustering.mode.isDistributed() && this.clustering.stateRetrieval.fetchInMemoryState.booleanValue()) {
            throw new ConfigurationException("Cache cannot use DISTRIBUTION mode and have fetchInMemoryState set to true");
        }
    }

    public boolean isOnePhaseCommit() {
        return !this.getCacheMode().isSynchronous();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheMode {
        LOCAL,
        REPL_SYNC,
        REPL_ASYNC,
        INVALIDATION_SYNC,
        INVALIDATION_ASYNC,
        DIST_SYNC,
        DIST_ASYNC;


        public boolean isInvalidation() {
            return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
        }

        public boolean isSynchronous() {
            return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
        }

        public boolean isClustered() {
            return this != LOCAL;
        }

        public boolean isDistributed() {
            return this == DIST_SYNC || this == DIST_ASYNC;
        }

        public boolean isReplicated() {
            return this == REPL_SYNC || this == REPL_ASYNC;
        }

        public CacheMode toSync() {
            switch (this) {
                case REPL_ASYNC: {
                    return REPL_SYNC;
                }
                case INVALIDATION_ASYNC: {
                    return INVALIDATION_SYNC;
                }
                case DIST_ASYNC: {
                    return DIST_SYNC;
                }
            }
            return this;
        }

        public CacheMode toAsync() {
            switch (this) {
                case REPL_SYNC: {
                    return REPL_ASYNC;
                }
                case INVALIDATION_SYNC: {
                    return INVALIDATION_ASYNC;
                }
                case DIST_SYNC: {
                    return DIST_ASYNC;
                }
            }
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class CustomInterceptorsType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 7187545782011884661L;
        @XmlElement(name="interceptor")
        private List<CustomInterceptorConfig> customInterceptors = new ArrayList<CustomInterceptorConfig>();

        private CustomInterceptorsType() {
        }

        public CustomInterceptorsType clone() throws CloneNotSupportedException {
            CustomInterceptorsType dolly = (CustomInterceptorsType)super.clone();
            if (this.customInterceptors != null) {
                dolly.customInterceptors = new ArrayList<CustomInterceptorConfig>();
                for (CustomInterceptorConfig config : this.customInterceptors) {
                    CustomInterceptorConfig clone = config.clone();
                    dolly.customInterceptors.add(clone);
                }
            }
            return dolly;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class UnsafeType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -9200921443651234163L;
        private Boolean unreliableReturnValues = false;

        private UnsafeType() {
        }

        @XmlAttribute
        public void setUnreliableReturnValues(Boolean unreliableReturnValues) {
            this.testImmutability("unreliableReturnValues");
            this.unreliableReturnValues = unreliableReturnValues;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class DeadlockDetectionType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -7178286048602531152L;
        private Boolean enabled = false;
        private Long spinDuration = 100L;

        private DeadlockDetectionType() {
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @XmlAttribute
        public void setSpinDuration(Long spinDuration) {
            this.testImmutability("spinDuration");
            this.spinDuration = spinDuration;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class BooleanAttributeType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 2296863404153834686L;
        Boolean enabled = false;

        private BooleanAttributeType() {
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class L1Type
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -4703587764861110638L;
        private Boolean enabled = true;
        private Long lifespan = 600000L;
        private Boolean onRehash = true;

        private L1Type() {
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @XmlAttribute
        public void setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
        }

        @XmlAttribute
        public void setOnRehash(Boolean onRehash) {
            this.testImmutability("onRehash");
            this.onRehash = onRehash;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class HashType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 752218766840948822L;
        private String consistentHashClass = DefaultConsistentHash.class.getName();
        private Integer numOwners = 2;
        private Long rehashWait = 60000L;
        private Long rehashRpcTimeout = 600000L;

        private HashType() {
        }

        @XmlAttribute(name="class")
        public void setConsistentHashClass(String consistentHashClass) {
            this.testImmutability("class");
            this.consistentHashClass = consistentHashClass;
        }

        @XmlAttribute
        public void setNumOwners(Integer numOwners) {
            this.testImmutability("numOwners");
            this.numOwners = numOwners;
        }

        @XmlAttribute
        public void setRehashWait(Long rehashWaitTime) {
            this.testImmutability("rehashWait");
            this.rehashWait = rehashWaitTime;
        }

        @XmlAttribute
        public void setRehashRpcTimeout(Long rehashRpcTimeout) {
            this.testImmutability("rehashRpcTimeout");
            this.rehashRpcTimeout = rehashRpcTimeout;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class SyncType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 8419216253674289524L;
        @Dynamic
        private Long replTimeout = 15000L;

        private SyncType() {
        }

        @XmlAttribute
        public void setReplTimeout(Long replTimeout) {
            this.testImmutability("replTimeout");
            this.replTimeout = replTimeout;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class StateRetrievalType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 3709234918426217096L;
        @Dynamic
        private Boolean fetchInMemoryState = false;
        @Dynamic
        private Long timeout = 10000L;

        private StateRetrievalType() {
        }

        @XmlAttribute
        public void setFetchInMemoryState(Boolean fetchInMemoryState) {
            this.testImmutability("fetchInMemoryState");
            this.fetchInMemoryState = fetchInMemoryState;
        }

        @XmlAttribute
        public void setTimeout(Long timeout) {
            this.testImmutability("timeout");
            this.timeout = timeout;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class EvictionType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -1248563712058858791L;
        private Long wakeUpInterval = 5000L;
        private EvictionStrategy strategy = EvictionStrategy.NONE;
        private Integer maxEntries = -1;

        private EvictionType() {
        }

        @XmlAttribute
        public void setWakeUpInterval(Long wakeUpInterval) {
            this.testImmutability("wakeUpInterval");
            this.wakeUpInterval = wakeUpInterval;
        }

        @XmlAttribute
        public void setStrategy(EvictionStrategy strategy) {
            this.testImmutability("strategy");
            this.strategy = strategy;
        }

        @XmlAttribute
        public void setMaxEntries(Integer maxEntries) {
            this.testImmutability("maxEntries");
            this.maxEntries = maxEntries;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class ExpirationType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 5757161438110848530L;
        private Long lifespan = -1L;
        private Long maxIdle = -1L;

        private ExpirationType() {
        }

        @XmlAttribute
        public void setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
        }

        @XmlAttribute
        public void setMaxIdle(Long maxIdle) {
            this.testImmutability("maxIdle");
            this.maxIdle = maxIdle;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class AsyncType
    extends AbstractNamedCacheConfigurationBean {
        @XmlTransient
        private boolean readFromXml = false;
        private static final long serialVersionUID = -7726319188826197399L;
        private Boolean useReplQueue = false;
        private Integer replQueueMaxElements = 1000;
        private Long replQueueInterval = 5000L;
        private Boolean asyncMarshalling = true;

        private AsyncType(boolean readFromXml) {
            this.readFromXml = readFromXml;
        }

        private AsyncType() {
            this(true);
        }

        @XmlAttribute
        public void setUseReplQueue(Boolean useReplQueue) {
            this.testImmutability("useReplQueue");
            this.useReplQueue = useReplQueue;
        }

        @XmlAttribute
        public void setReplQueueMaxElements(Integer replQueueMaxElements) {
            this.testImmutability("replQueueMaxElements");
            this.replQueueMaxElements = replQueueMaxElements;
        }

        @XmlAttribute
        public void setReplQueueInterval(Long replQueueInterval) {
            this.testImmutability("replQueueInterval");
            this.replQueueInterval = replQueueInterval;
        }

        @XmlAttribute
        public void setAsyncMarshalling(Boolean asyncMarshalling) {
            this.testImmutability("asyncMarshalling");
            this.asyncMarshalling = asyncMarshalling;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClusteringTypeAdapter
    extends XmlAdapter<ClusteringType, ClusteringType> {
        private ClusteringTypeAdapter() {
        }

        public ClusteringType marshal(ClusteringType ct) throws Exception {
            return ct;
        }

        public ClusteringType unmarshal(ClusteringType ct) throws Exception {
            if (ct.stringMode != null) {
                String mode = ct.stringMode.toLowerCase();
                if (mode.startsWith("r")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.REPL_SYNC);
                    } else {
                        ct.setMode(CacheMode.REPL_ASYNC);
                    }
                } else if (mode.startsWith("i")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.INVALIDATION_SYNC);
                    } else {
                        ct.setMode(CacheMode.INVALIDATION_ASYNC);
                    }
                } else if (mode.startsWith("d")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.DIST_SYNC);
                    } else {
                        ct.setMode(CacheMode.DIST_ASYNC);
                    }
                } else {
                    throw new ConfigurationException("Invalid clustering mode" + ct.stringMode);
                }
            }
            return ct;
        }
    }

    @XmlJavaTypeAdapter(value=ClusteringTypeAdapter.class)
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(propOrder={})
    private static class ClusteringType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 4048135465543498430L;
        @XmlAttribute(name="mode")
        private String stringMode;
        @XmlTransient
        private CacheMode mode = CacheMode.LOCAL;
        @XmlElement
        private SyncType sync = new SyncType();
        @XmlElement
        private StateRetrievalType stateRetrieval = new StateRetrievalType();
        @XmlElement
        private L1Type l1 = new L1Type();
        @XmlElement
        private AsyncType async = new AsyncType(false);
        @XmlElement
        private HashType hash = new HashType();

        private ClusteringType() {
        }

        public void setMode(CacheMode mode) {
            this.testImmutability("mode");
            this.mode = mode;
        }

        public boolean isSynchronous() {
            return !this.async.readFromXml;
        }

        public ClusteringType clone() throws CloneNotSupportedException {
            ClusteringType dolly = (ClusteringType)super.clone();
            dolly.sync = (SyncType)this.sync.clone();
            dolly.stateRetrieval = (StateRetrievalType)this.stateRetrieval.clone();
            dolly.l1 = (L1Type)this.l1.clone();
            dolly.async = (AsyncType)this.async.clone();
            dolly.hash = (HashType)this.hash.clone();
            return dolly;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class LockingType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 8142143187082119506L;
        @Dynamic
        private Long lockAcquisitionTimeout = 10000L;
        private IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
        private Boolean writeSkewCheck = false;
        private Boolean useLockStriping = true;
        private Integer concurrencyLevel = 500;

        private LockingType() {
        }

        @XmlAttribute
        public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
            this.testImmutability("lockAcquisitionTimeout");
            this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        }

        @XmlAttribute
        public void setIsolationLevel(IsolationLevel isolationLevel) {
            this.testImmutability("isolationLevel");
            this.isolationLevel = isolationLevel;
        }

        @XmlAttribute
        public void setWriteSkewCheck(Boolean writeSkewCheck) {
            this.testImmutability("writeSkewCheck");
            this.writeSkewCheck = writeSkewCheck;
        }

        @XmlAttribute
        public void setUseLockStriping(Boolean useLockStriping) {
            this.testImmutability("useLockStriping");
            this.useLockStriping = useLockStriping;
        }

        @XmlAttribute
        public void setConcurrencyLevel(Integer concurrencyLevel) {
            this.testImmutability("concurrencyLevel");
            this.concurrencyLevel = concurrencyLevel;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class TransactionType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -3867090839830874603L;
        private String transactionManagerLookupClass;
        @XmlTransient
        private TransactionManagerLookup transactionManagerLookup;
        @Dynamic
        private Boolean syncCommitPhase = false;
        @Dynamic
        private Boolean syncRollbackPhase = false;
        @Dynamic
        private Boolean useEagerLocking = false;

        public TransactionType(String transactionManagerLookupClass) {
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        public TransactionType() {
            this.transactionManagerLookupClass = GenericTransactionManagerLookup.class.getName();
        }

        @XmlAttribute
        public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
            this.testImmutability("transactionManagerLookupClass");
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        @XmlAttribute
        public void setSyncCommitPhase(Boolean syncCommitPhase) {
            this.testImmutability("syncCommitPhase");
            this.syncCommitPhase = syncCommitPhase;
        }

        @XmlAttribute
        public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
            this.testImmutability("syncRollbackPhase");
            this.syncRollbackPhase = syncRollbackPhase;
        }

        @XmlAttribute
        public void setUseEagerLocking(Boolean useEagerLocking) {
            this.testImmutability("useEagerLocking");
            this.useEagerLocking = useEagerLocking;
        }
    }
}

