/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.AbstractConfigurationBeanWithGCR;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ConfigurationProperties;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.executors.DefaultExecutorFactory;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.TypedProperties;

@NonVolatile
@Scope(value=Scopes.GLOBAL)
@ConfigurationElements(elements={@ConfigurationElement(name="global", parent="infinispan", description=""), @ConfigurationElement(name="asyncListenerExecutor", parent="global", description=""), @ConfigurationElement(name="transport", parent="global", description=""), @ConfigurationElement(name="evictionScheduledExecutor", parent="global", description=""), @ConfigurationElement(name="replicationQueueScheduledExecutor", parent="global", description=""), @ConfigurationElement(name="globalJmxStatistics", parent="global", description=""), @ConfigurationElement(name="asyncTransportExecutor", parent="global", description=""), @ConfigurationElement(name="serialization", parent="global", description=""), @ConfigurationElement(name="shutdown", parent="global", description="")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
public class GlobalConfiguration
extends AbstractConfigurationBean {
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    @XmlElement
    private FactoryClassWithPropertiesType asyncListenerExecutor = new FactoryClassWithPropertiesType(DefaultExecutorFactory.class.getName());
    @XmlElement
    private FactoryClassWithPropertiesType asyncTransportExecutor = new FactoryClassWithPropertiesType(DefaultExecutorFactory.class.getName());
    @XmlElement
    private FactoryClassWithPropertiesType evictionScheduledExecutor = new FactoryClassWithPropertiesType(DefaultScheduledExecutorFactory.class.getName());
    @XmlElement
    private FactoryClassWithPropertiesType replicationQueueScheduledExecutor = new FactoryClassWithPropertiesType(DefaultScheduledExecutorFactory.class.getName());
    @XmlElement
    private GlobalJmxStatisticsType globalJmxStatistics = new GlobalJmxStatisticsType();
    @XmlElement
    private TransportType transport = new TransportType(null);
    @XmlElement
    private SerializationType serialization = new SerializationType();
    @XmlTransient
    private Configuration defaultConfiguration;
    @XmlElement
    private ShutdownType shutdown = new ShutdownType();
    @XmlTransient
    private GlobalComponentRegistry gcr;

    public boolean isExposeGlobalJmxStatistics() {
        return this.globalJmxStatistics.enabled;
    }

    @ConfigurationAttribute(name="enabled", containingElement="globalJmxStatistics", description="If true, global JMX statistics are published")
    public void setExposeGlobalJmxStatistics(boolean exposeGlobalJmxStatistics) {
        this.testImmutability("exposeGlobalManagementStatistics");
        this.globalJmxStatistics.setEnabled(exposeGlobalJmxStatistics);
    }

    @ConfigurationAttribute(name="jmxDomain", containingElement="globalJmxStatistics", description="If JMX statistics are enabled then all 'published' JMX objects will appear under this name")
    public void setJmxDomain(String jmxObjectName) {
        this.globalJmxStatistics.setJmxDomain(jmxObjectName);
    }

    public String getJmxDomain() {
        return this.globalJmxStatistics.jmxDomain;
    }

    public String getMBeanServerLookup() {
        return this.globalJmxStatistics.mBeanServerLookup;
    }

    @ConfigurationAttribute(name="mBeanServerLookup", containingElement="globalJmxStatistics", description="")
    public void setMBeanServerLookup(String mBeanServerLookup) {
        this.globalJmxStatistics.setMBeanServerLookup(mBeanServerLookup);
    }

    public boolean isAllowDuplicateDomains() {
        return this.globalJmxStatistics.allowDuplicateDomains;
    }

    @ConfigurationAttribute(name="allowDuplicateDomains", containingElement="globalJmxStatistics", description="")
    public void setAllowDuplicateDomains(boolean allowDuplicateDomains) {
        this.globalJmxStatistics.setAllowDuplicateDomains(allowDuplicateDomains);
    }

    @Inject
    private void injectDependencies(GlobalComponentRegistry gcr) {
        this.gcr = gcr;
        gcr.registerComponent((Object)this.asyncListenerExecutor, "asyncListenerExecutor");
        gcr.registerComponent((Object)this.asyncTransportExecutor, "asyncTransportExecutor");
        gcr.registerComponent((Object)this.evictionScheduledExecutor, "evictionScheduledExecutor");
        gcr.registerComponent((Object)this.replicationQueueScheduledExecutor, "replicationQueueScheduledExecutor");
        gcr.registerComponent((Object)this.replicationQueueScheduledExecutor, "replicationQueueScheduledExecutor");
        gcr.registerComponent((Object)this.globalJmxStatistics, "globalJmxStatistics");
        gcr.registerComponent((Object)this.transport, "transport");
        gcr.registerComponent((Object)this.serialization, "serialization");
        gcr.registerComponent((Object)this.shutdown, "shutdown");
    }

    protected boolean hasComponentStarted() {
        return this.gcr != null && this.gcr.getStatus() != null && this.gcr.getStatus() == ComponentStatus.RUNNING;
    }

    public String getAsyncListenerExecutorFactoryClass() {
        return this.asyncListenerExecutor.factory;
    }

    @ConfigurationAttribute(name="factory", containingElement="asyncListenerExecutor", description="ExecutorService factory class for asynchronous listeners")
    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.asyncListenerExecutor.setFactory(asyncListenerExecutorFactoryClass);
    }

    public String getAsyncTransportExecutorFactoryClass() {
        return this.asyncTransportExecutor.factory;
    }

    @ConfigurationAttribute(name="factory", containingElement="asyncTransportExecutor", description="ExecutorService factory class for async transport")
    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.asyncTransportExecutor.setFactory(asyncTransportExecutorFactoryClass);
    }

    public String getEvictionScheduledExecutorFactoryClass() {
        return this.evictionScheduledExecutor.factory;
    }

    @ConfigurationAttribute(name="factory", containingElement="evictionScheduledExecutor", description="ExecutorService factory class for eviction threads")
    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.evictionScheduledExecutor.setFactory(evictionScheduledExecutorFactoryClass);
    }

    public String getReplicationQueueScheduledExecutorFactoryClass() {
        return this.replicationQueueScheduledExecutor.factory;
    }

    @ConfigurationAttribute(name="factory", containingElement="replicationQueueScheduledExecutor", description="ExecutorService factory class for replication queue threads")
    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.replicationQueueScheduledExecutor.setFactory(replicationQueueScheduledExecutorFactoryClass);
    }

    public String getMarshallerClass() {
        return this.serialization.marshallerClass;
    }

    @ConfigurationAttribute(name="marshallerClass", containingElement="serialization")
    public void setMarshallerClass(String marshallerClass) {
        this.serialization.setMarshallerClass(marshallerClass);
    }

    public String getTransportClass() {
        return this.transport.transportClass;
    }

    @ConfigurationAttribute(name="transportClass", containingElement="transport", description="Transport class, by default null i.e. no transport", defaultValue="org.infinispan.remoting.transport.jgroups.JGroupsTransport")
    public void setTransportClass(String transportClass) {
        this.transport.setTransportClass(transportClass);
    }

    public Properties getTransportProperties() {
        return this.transport.properties;
    }

    @ConfigurationProperties(elements={@ConfigurationProperty(name="configurationString", parentElement="transport"), @ConfigurationProperty(name="configurationFile", parentElement="transport"), @ConfigurationProperty(name="configurationXml", parentElement="transport")})
    public void setTransportProperties(Properties transportProperties) {
        this.transport.setProperties(this.toTypedProperties(transportProperties));
    }

    public void setTransportProperties(String transportPropertiesString) {
        this.transport.setProperties(this.toTypedProperties(transportPropertiesString));
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setDefaultConfiguration(Configuration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public String getClusterName() {
        return this.transport.clusterName;
    }

    @ConfigurationAttribute(name="clusterName", containingElement="transport")
    public void setClusterName(String clusterName) {
        this.transport.setClusterName(clusterName);
    }

    public ShutdownHookBehavior getShutdownHookBehavior() {
        return this.shutdown.hookBehavior;
    }

    public void setShutdownHookBehavior(ShutdownHookBehavior shutdownHookBehavior) {
        this.shutdown.setHookBehavior(shutdownHookBehavior);
    }

    @ConfigurationAttribute(name="hookBehavior", containingElement="shutdown", allowedValues={"DEFAULT", "REGISTER", "DONT_REGISTER"}, defaultValue="DEFAULT")
    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        if (shutdownHookBehavior == null) {
            throw new ConfigurationException("Shutdown hook behavior cannot be null", "ShutdownHookBehavior");
        }
        ShutdownHookBehavior temp = ShutdownHookBehavior.valueOf(this.uc(shutdownHookBehavior));
        if (temp == null) {
            this.log.warn("Unknown shutdown hook behavior '" + shutdownHookBehavior + "', using defaults.");
            temp = ShutdownHookBehavior.DEFAULT;
        }
        this.setShutdownHookBehavior(temp);
    }

    public Properties getAsyncListenerExecutorProperties() {
        return this.asyncListenerExecutor.properties;
    }

    @ConfigurationProperties(elements={@ConfigurationProperty(name="maxThreads", parentElement="asyncListenerExecutor"), @ConfigurationProperty(name="threadNamePrefix", parentElement="asyncListenerExecutor")})
    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.asyncListenerExecutor.setProperties(this.toTypedProperties(asyncListenerExecutorProperties));
    }

    public void setAsyncListenerExecutorProperties(String asyncListenerExecutorPropertiesString) {
        this.asyncListenerExecutor.setProperties(this.toTypedProperties(asyncListenerExecutorPropertiesString));
    }

    public Properties getAsyncTransportExecutorProperties() {
        return this.asyncTransportExecutor.properties;
    }

    @ConfigurationProperties(elements={@ConfigurationProperty(name="maxThreads", parentElement="asyncTransportExecutor"), @ConfigurationProperty(name="threadNamePrefix", parentElement="asyncTransportExecutor")})
    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.asyncTransportExecutor.setProperties(this.toTypedProperties(asyncTransportExecutorProperties));
    }

    public void setAsyncTransportExecutorProperties(String asyncSerializationExecutorPropertiesString) {
        this.asyncTransportExecutor.setProperties(this.toTypedProperties(asyncSerializationExecutorPropertiesString));
    }

    public Properties getEvictionScheduledExecutorProperties() {
        return this.evictionScheduledExecutor.properties;
    }

    @ConfigurationProperties(elements={@ConfigurationProperty(name="maxThreads", parentElement="evictionScheduledExecutor"), @ConfigurationProperty(name="threadNamePrefix", parentElement="evictionScheduledExecutor")})
    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.evictionScheduledExecutor.setProperties(this.toTypedProperties(evictionScheduledExecutorProperties));
    }

    public void setEvictionScheduledExecutorProperties(String evictionScheduledExecutorPropertiesString) {
        this.evictionScheduledExecutor.setProperties(this.toTypedProperties(evictionScheduledExecutorPropertiesString));
    }

    public Properties getReplicationQueueScheduledExecutorProperties() {
        return this.replicationQueueScheduledExecutor.properties;
    }

    @ConfigurationProperties(elements={@ConfigurationProperty(name="maxThreads", parentElement="replicationQueueScheduledExecutor"), @ConfigurationProperty(name="threadNamePrefix", parentElement="replicationQueueScheduledExecutor")})
    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.replicationQueueScheduledExecutor.setProperties(this.toTypedProperties(replicationQueueScheduledExecutorProperties));
    }

    public void setReplicationQueueScheduledExecutorProperties(String replicationQueueScheduledExecutorPropertiesString) {
        this.replicationQueueScheduledExecutor.setProperties(this.toTypedProperties(replicationQueueScheduledExecutorPropertiesString));
    }

    public short getMarshallVersion() {
        return Version.getVersionShort(this.serialization.version);
    }

    public String getMarshallVersionString() {
        return this.serialization.version;
    }

    public void setMarshallVersion(short marshallVersion) {
        this.testImmutability("marshallVersion");
        this.serialization.version = Version.decodeVersionForSerialization(marshallVersion);
    }

    @ConfigurationAttribute(name="version", containingElement="serialization", defaultValue="4.0.0.BETA1")
    public void setMarshallVersion(String marshallVersion) {
        this.serialization.setVersion(marshallVersion);
    }

    public long getDistributedSyncTimeout() {
        return this.transport.distributedSyncTimeout;
    }

    @ConfigurationAttribute(name="distributedSyncTimeout", containingElement="transport")
    public void setDistributedSyncTimeout(long distributedSyncTimeout) {
        this.transport.distributedSyncTimeout = distributedSyncTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfiguration that = (GlobalConfiguration)o;
        if (this.serialization.version != that.serialization.version) {
            return false;
        }
        if (this.asyncListenerExecutor.factory != null ? !this.asyncListenerExecutor.factory.equals(that.asyncListenerExecutor.factory) : that.asyncListenerExecutor.factory != null) {
            return false;
        }
        if (this.asyncListenerExecutor.properties != null ? !this.asyncListenerExecutor.properties.equals(that.asyncListenerExecutor.properties) : that.asyncListenerExecutor.properties != null) {
            return false;
        }
        if (this.asyncTransportExecutor.factory != null ? !this.asyncTransportExecutor.factory.equals(that.asyncTransportExecutor.factory) : that.asyncTransportExecutor.factory != null) {
            return false;
        }
        if (this.asyncTransportExecutor.properties != null ? !this.asyncTransportExecutor.properties.equals(that.asyncTransportExecutor.properties) : that.asyncTransportExecutor.properties != null) {
            return false;
        }
        if (this.transport.clusterName != null ? !this.transport.clusterName.equals(that.transport.clusterName) : that.transport.clusterName != null) {
            return false;
        }
        if (this.defaultConfiguration != null ? !this.defaultConfiguration.equals(that.defaultConfiguration) : that.defaultConfiguration != null) {
            return false;
        }
        if (this.evictionScheduledExecutor.factory != null ? !this.evictionScheduledExecutor.factory.equals(that.evictionScheduledExecutor.factory) : that.evictionScheduledExecutor.factory != null) {
            return false;
        }
        if (this.evictionScheduledExecutor.properties != null ? !this.evictionScheduledExecutor.properties.equals(that.evictionScheduledExecutor.properties) : that.evictionScheduledExecutor.properties != null) {
            return false;
        }
        if (this.serialization.marshallerClass != null ? !this.serialization.marshallerClass.equals(that.serialization.marshallerClass) : that.serialization.marshallerClass != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor.factory != null ? !this.replicationQueueScheduledExecutor.factory.equals(that.replicationQueueScheduledExecutor.factory) : that.replicationQueueScheduledExecutor.factory != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor.properties != null ? !this.replicationQueueScheduledExecutor.properties.equals(that.replicationQueueScheduledExecutor.properties) : that.replicationQueueScheduledExecutor.properties != null) {
            return false;
        }
        if (this.shutdown != that.shutdown) {
            return false;
        }
        if (this.transport.transportClass != null ? !this.transport.transportClass.equals(that.transport.transportClass) : that.transport.transportClass != null) {
            return false;
        }
        if (this.transport.properties != null ? !this.transport.properties.equals(that.transport.properties) : that.transport.properties != null) {
            return false;
        }
        return this.transport.distributedSyncTimeout == that.transport.distributedSyncTimeout;
    }

    public int hashCode() {
        int result = this.asyncListenerExecutor.factory != null ? this.asyncListenerExecutor.factory.hashCode() : 0;
        result = 31 * result + (this.asyncListenerExecutor.properties != null ? this.asyncListenerExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor.factory != null ? this.asyncTransportExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor.properties != null ? this.asyncTransportExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor.factory != null ? this.evictionScheduledExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor.properties != null ? this.evictionScheduledExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor.factory != null ? this.replicationQueueScheduledExecutor.factory.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor.properties != null ? this.replicationQueueScheduledExecutor.properties.hashCode() : 0);
        result = 31 * result + (this.serialization.marshallerClass != null ? this.serialization.marshallerClass.hashCode() : 0);
        result = 31 * result + (this.transport.transportClass != null ? this.transport.transportClass.hashCode() : 0);
        result = 31 * result + (this.transport.properties != null ? this.transport.properties.hashCode() : 0);
        result = 31 * result + (this.defaultConfiguration != null ? this.defaultConfiguration.hashCode() : 0);
        result = 31 * result + (this.transport.clusterName != null ? this.transport.clusterName.hashCode() : 0);
        result = 31 * result + this.shutdown.hookBehavior.hashCode();
        result = 31 * result + this.serialization.version.hashCode();
        result = (int)((long)(31 * result) + this.transport.distributedSyncTimeout);
        return result;
    }

    public GlobalConfiguration clone() {
        try {
            return (GlobalConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Problems cloning configuration component!", e);
        }
    }

    public static GlobalConfiguration getClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(JGroupsTransport.class.getName());
        gc.setTransportProperties((Properties)null);
        Properties p = new Properties();
        p.setProperty("threadNamePrefix", "asyncTransportThread");
        gc.setAsyncTransportExecutorProperties(p);
        return gc;
    }

    public static GlobalConfiguration getNonClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(null);
        gc.setTransportProperties((Properties)null);
        return gc;
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class ShutdownType
    extends AbstractConfigurationBeanWithGCR {
        private ShutdownHookBehavior hookBehavior = ShutdownHookBehavior.DEFAULT;

        private ShutdownType() {
        }

        @XmlAttribute
        public void setHookBehavior(ShutdownHookBehavior hookBehavior) {
            this.testImmutability("hookBehavior");
            this.hookBehavior = hookBehavior;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class GlobalJmxStatisticsType
    extends AbstractConfigurationBeanWithGCR {
        private Boolean enabled = false;
        private String jmxDomain = "infinispan";
        private String mBeanServerLookup = PlatformMBeanServerLookup.class.getName();
        private Boolean allowDuplicateDomains = false;

        private GlobalJmxStatisticsType() {
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        @XmlAttribute
        public void setJmxDomain(String jmxDomain) {
            this.testImmutability("jmxDomain");
            this.jmxDomain = jmxDomain;
        }

        @XmlAttribute
        public void setMBeanServerLookup(String beanServerLookup) {
            this.testImmutability("mBeanServerLookup");
            this.mBeanServerLookup = beanServerLookup;
        }

        @XmlAttribute
        public void setAllowDuplicateDomains(Boolean allowDuplicateDomains) {
            this.testImmutability("allowDuplicateDomains");
            this.allowDuplicateDomains = allowDuplicateDomains;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class SerializationType
    extends AbstractConfigurationBeanWithGCR {
        private String marshallerClass = VersionAwareMarshaller.class.getName();
        private String version = Version.getMajorVersion();

        @XmlAttribute
        public void setMarshallerClass(String marshallerClass) {
            this.testImmutability("marshallerClass");
            this.marshallerClass = marshallerClass;
        }

        @XmlAttribute
        public void setVersion(String version) {
            this.testImmutability("version");
            this.version = version;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class TransportType
    extends AbstractConfigurationBeanWithGCR {
        private String clusterName = "Infinispan-Cluster";
        private Long distributedSyncTimeout = 60000L;
        private String transportClass = null;
        private TypedProperties properties = EMPTY_PROPERTIES;

        public TransportType() {
            this.transportClass = JGroupsTransport.class.getName();
        }

        public TransportType(String transportClass) {
            this.transportClass = transportClass;
        }

        @XmlAttribute
        public void setClusterName(String clusterName) {
            this.testImmutability("clusterName");
            this.clusterName = clusterName;
        }

        @XmlAttribute
        public void setDistributedSyncTimeout(Long distributedSyncTimeout) {
            this.testImmutability("distributedSyncTimeout");
            this.distributedSyncTimeout = distributedSyncTimeout;
        }

        @XmlAttribute
        public void setTransportClass(String transportClass) {
            this.testImmutability("transportClass");
            this.transportClass = transportClass;
        }

        @XmlElement
        public void setProperties(TypedProperties properties) {
            this.properties = properties;
        }

        public TransportType clone() throws CloneNotSupportedException {
            TransportType dolly = (TransportType)super.clone();
            dolly.properties = (TypedProperties)this.properties.clone();
            return dolly;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    private static class FactoryClassWithPropertiesType
    extends AbstractConfigurationBeanWithGCR {
        @XmlAttribute
        private String factory;
        @XmlElement(name="properties")
        private TypedProperties properties = EMPTY_PROPERTIES;

        public FactoryClassWithPropertiesType(String factory) {
            this.factory = factory;
        }

        public FactoryClassWithPropertiesType() {
            this.factory = "";
        }

        public void setFactory(String factory) {
            this.testImmutability("factory");
            this.factory = factory;
        }

        public void setProperties(TypedProperties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        public FactoryClassWithPropertiesType clone() throws CloneNotSupportedException {
            FactoryClassWithPropertiesType dolly = (FactoryClassWithPropertiesType)super.clone();
            dolly.properties = (TypedProperties)this.properties.clone();
            return dolly;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShutdownHookBehavior {
        DEFAULT,
        REGISTER,
        DONT_REGISTER;

    }
}

