/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.parsing.XmlConfigurationParser;
import org.infinispan.util.FileLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="infinispan")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InfinispanConfiguration
implements XmlConfigurationParser {
    public static final String VALIDATING_SYSTEM_PROPERTY = "infinispan.config.validate";
    public static final String SCHEMA_SYSTEM_PROPERTY = "infinispan.config.schema";
    private static final String DEFAULT_SCHEMA_LOCATION = "schema/infinispan-config-" + Version.getMajorVersion() + ".xsd";
    public static final String SCHEMA_URL_SYSTEM_PROPERTY = "infinispan.config.schema.url";
    private static final String DEFAULT_SCHEMA_URL = "http://www.jboss.org/infinispan/infinispan-config-" + Version.getMajorVersion() + ".xsd";
    @XmlElement
    private GlobalConfiguration global;
    @XmlElement(name="default")
    private Configuration defaultConfiguration;
    @XmlElement(name="namedCache")
    private List<Configuration> namedCaches;

    public static InfinispanConfiguration newInfinispanConfiguration(String configFileName, String schemaFileName) throws IOException {
        InputStream inputStream = configFileName != null ? InfinispanConfiguration.findInputStream(configFileName) : null;
        InputStream schemaIS = schemaFileName != null ? InfinispanConfiguration.findInputStream(schemaFileName) : null;
        return InfinispanConfiguration.newInfinispanConfiguration(inputStream, schemaIS);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(String configFileName) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(configFileName, null);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(InputStream config) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(config, null);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(InputStream config, InputStream schema) throws IOException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{InfinispanConfiguration.class});
            Unmarshaller u = jc.createUnmarshaller();
            if (schema != null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                u.setSchema(factory.newSchema(new StreamSource(schema)));
            }
            InfinispanConfiguration doc = (InfinispanConfiguration)u.unmarshal(config);
            doc.parseGlobalConfiguration().setDefaultConfiguration(doc.parseDefaultConfiguration());
            return doc;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static boolean skipSchemaValidation() {
        String s = System.getProperty(VALIDATING_SYSTEM_PROPERTY);
        return s != null && !Boolean.parseBoolean(s);
    }

    public static InputStream findSchemaInputStream() {
        boolean validating;
        boolean bl = validating = !InfinispanConfiguration.skipSchemaValidation();
        if (!validating) {
            return null;
        }
        FileLookup fileLookup = new FileLookup();
        InputStream is = fileLookup.lookupFile(InfinispanConfiguration.schemaPath());
        if (is != null) {
            return is;
        }
        try {
            is = new URL(InfinispanConfiguration.schemaURL()).openStream();
            return is;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String resolveSchemaPath() {
        boolean validating;
        boolean bl = validating = !InfinispanConfiguration.skipSchemaValidation();
        if (!validating) {
            return null;
        }
        return InfinispanConfiguration.schemaPath();
    }

    private static String schemaPath() {
        return System.getProperty(SCHEMA_SYSTEM_PROPERTY, DEFAULT_SCHEMA_LOCATION);
    }

    private static String schemaURL() {
        return System.getProperty(SCHEMA_URL_SYSTEM_PROPERTY, DEFAULT_SCHEMA_URL);
    }

    private static InputStream findInputStream(String fileName) throws FileNotFoundException {
        if (fileName == null) {
            throw new NullPointerException("File name cannot be null!");
        }
        FileLookup fileLookup = new FileLookup();
        InputStream is = fileLookup.lookupFile(fileName);
        if (is == null) {
            throw new FileNotFoundException("File " + fileName + " could not be found, either on the classpath or on the file system!");
        }
        return is;
    }

    @Override
    public Configuration parseDefaultConfiguration() throws ConfigurationException {
        return this.defaultConfiguration;
    }

    @Override
    public GlobalConfiguration parseGlobalConfiguration() {
        return this.global;
    }

    @Override
    public Map<String, Configuration> parseNamedConfigurations() throws ConfigurationException {
        if (this.namedCaches == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Configuration> map = new HashMap<String, Configuration>(7);
        for (Configuration conf : this.namedCaches) {
            map.put(conf.getName(), conf);
        }
        return map;
    }
}

