/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.config.parsing.TreeWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode {
    private final String name;
    private final TreeNode parent;
    private final int depth;
    private final Set<TreeNode> children = new HashSet<TreeNode>();

    public TreeNode(String name, TreeNode parent, int depth) {
        this.name = name;
        this.parent = parent;
        this.depth = depth;
    }

    public TreeNode() {
        this.name = "";
        this.parent = null;
        this.depth = -1;
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Set<TreeNode> getChildren() {
        return this.children;
    }

    public void accept(TreeWalker tw) {
        tw.visitNode(this);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TreeNode)) {
            return false;
        }
        TreeNode tn = (TreeNode)other;
        return this.parent.name != null && tn.parent != null && this.parent.name.equals(tn.parent.name) && this.name.equals(tn.name);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.parent != null && this.parent.name != null ? this.parent.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name;
    }
}

