/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SimpleDataContainer
implements DataContainer {
    final ConcurrentMap<Object, InternalCacheEntry> immortalEntries = new ConcurrentHashMap<Object, InternalCacheEntry>();
    final ConcurrentMap<Object, InternalCacheEntry> mortalEntries = new ConcurrentHashMap<Object, InternalCacheEntry>();
    final AtomicInteger numEntries = new AtomicInteger(0);

    private InternalCacheEntry peek(Object key) {
        InternalCacheEntry e = (InternalCacheEntry)this.immortalEntries.get(key);
        if (e == null) {
            e = (InternalCacheEntry)this.mortalEntries.get(key);
        }
        return e;
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry e = this.peek(k);
        if (e != null) {
            if (e.isExpired()) {
                this.mortalEntries.remove(k);
                this.numEntries.getAndDecrement();
                e = null;
            } else {
                e.touch();
            }
        }
        return e;
    }

    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        InternalCacheEntry e = (InternalCacheEntry)this.immortalEntries.get(k);
        if (e != null) {
            e.setValue(v);
            if (lifespan > -1L) {
                e = e.setLifespan(lifespan);
            }
            if (maxIdle > -1L) {
                e = e.setMaxIdle(maxIdle);
            }
            if (e.canExpire()) {
                this.immortalEntries.remove(k);
                this.mortalEntries.put(k, e);
            }
        } else {
            e = (InternalCacheEntry)this.mortalEntries.get(k);
            if (e != null) {
                e.setValue(v);
                InternalCacheEntry original = e;
                e = e.setLifespan(lifespan).setMaxIdle(maxIdle);
                if (!e.canExpire()) {
                    this.mortalEntries.remove(k);
                    this.immortalEntries.put(k, e);
                } else if (e != original) {
                    this.mortalEntries.put(k, e);
                }
            } else {
                this.numEntries.getAndIncrement();
                e = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                if (e.canExpire()) {
                    this.mortalEntries.put(k, e);
                } else {
                    this.immortalEntries.put(k, e);
                }
            }
        }
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice = this.peek(k);
        if (ice != null && ice.isExpired()) {
            this.mortalEntries.remove(k);
            this.numEntries.getAndDecrement();
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.immortalEntries.remove(k);
        if (e == null) {
            e = (InternalCacheEntry)this.mortalEntries.remove(k);
        }
        if (e != null) {
            this.numEntries.getAndDecrement();
        }
        return e == null || e.isExpired() ? null : e;
    }

    @Override
    public int size() {
        return this.numEntries.get();
    }

    @Override
    @Stop(priority=999)
    public void clear() {
        this.immortalEntries.clear();
        this.mortalEntries.clear();
        this.numEntries.set(0);
    }

    @Override
    public Set<Object> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        Iterator entries = this.mortalEntries.values().iterator();
        while (entries.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)entries.next();
            if (!e.isExpired()) continue;
            entries.remove();
            this.numEntries.getAndDecrement();
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator(this.immortalEntries.values().iterator(), this.mortalEntries.values().iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends MortalInmortalIterator
    implements Iterator<Object> {
        private ValueIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            super(immortalIterator, mortalIterator);
        }

        @Override
        public Object next() {
            return ((InternalCacheEntry)this.currentIterator.next()).getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(SimpleDataContainer.this.immortalEntries.values().iterator(), SimpleDataContainer.this.mortalEntries.values().iterator());
        }

        @Override
        public int size() {
            return SimpleDataContainer.this.immortalEntries.size() + SimpleDataContainer.this.mortalEntries.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmutableEntryIterator
    extends MortalInmortalIterator
    implements Iterator<InternalCacheEntry> {
        private ImmutableEntryIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            super(immortalIterator, mortalIterator);
        }

        @Override
        public InternalCacheEntry next() {
            return Immutables.immutableInternalCacheEntry((InternalCacheEntry)this.currentIterator.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MortalInmortalIterator
    implements Iterator<InternalCacheEntry> {
        private EntryIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            super(immortalIterator, mortalIterator);
        }

        @Override
        public InternalCacheEntry next() {
            return (InternalCacheEntry)this.currentIterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MortalInmortalIterator {
        Iterator<Iterator<InternalCacheEntry>> metaIterator;
        Iterator<InternalCacheEntry> currentIterator;
        InternalCacheEntry next;

        private MortalInmortalIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            this.metaIterator = Arrays.asList(immortalIterator, mortalIterator).iterator();
            if (this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
            }
        }

        public boolean hasNext() {
            boolean hasNext = this.currentIterator.hasNext();
            while (!hasNext && this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
                hasNext = this.currentIterator.hasNext();
            }
            return hasNext;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<InternalCacheEntry> {
        private EntrySet() {
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new ImmutableEntryIterator(SimpleDataContainer.this.immortalEntries.values().iterator(), SimpleDataContainer.this.mortalEntries.values().iterator());
        }

        @Override
        public int size() {
            return SimpleDataContainer.this.immortalEntries.size() + SimpleDataContainer.this.mortalEntries.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<Object> {
        Iterator<Iterator<Object>> metaIterator;
        Iterator<Object> currentIterator;

        private KeyIterator(Iterator<Object> immortalIterator, Iterator<Object> mortalIterator) {
            this.metaIterator = Arrays.asList(immortalIterator, mortalIterator).iterator();
            if (this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.currentIterator.hasNext();
            while (!hasNext && this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
                hasNext = this.currentIterator.hasNext();
            }
            return hasNext;
        }

        @Override
        public Object next() {
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<Object> {
        final Set<Object> immortalKeys;
        final Set<Object> mortalKeys;

        public KeySet() {
            this.immortalKeys = SimpleDataContainer.this.immortalEntries.keySet();
            this.mortalKeys = SimpleDataContainer.this.mortalEntries.keySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator(this.immortalKeys.iterator(), this.mortalKeys.iterator());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.immortalKeys.contains(o) || this.mortalKeys.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.immortalKeys.size() + this.mortalKeys.size();
        }
    }
}

