/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=10)
public class ImmortalCacheEntry
extends AbstractInternalCacheEntry {
    private ImmortalCacheValue cacheValue;

    ImmortalCacheEntry(Object key, Object value) {
        super(key);
        this.cacheValue = new ImmortalCacheValue(value);
    }

    public final boolean isExpired() {
        return false;
    }

    public final boolean canExpire() {
        return false;
    }

    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle > -1L) {
            return new TransientCacheEntry(this.key, this.cacheValue.value, maxIdle);
        }
        return this;
    }

    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan > -1L) {
            return new MortalCacheEntry(this.key, this.cacheValue.value, lifespan);
        }
        return this;
    }

    public final long getCreated() {
        return -1L;
    }

    public final long getLastUsed() {
        return -1L;
    }

    public final long getLifespan() {
        return -1L;
    }

    public final long getMaxIdle() {
        return -1L;
    }

    public final long getExpiryTime() {
        return -1L;
    }

    public final void touch() {
    }

    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    public Object getValue() {
        return this.cacheValue.value;
    }

    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmortalCacheEntry that = (ImmortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.cacheValue != null ? !this.cacheValue.equals(that.cacheValue) : that.cacheValue != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.cacheValue != null ? this.cacheValue.hashCode() : 0);
        return result;
    }

    public ImmortalCacheEntry clone() {
        ImmortalCacheEntry clone = (ImmortalCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            ImmortalCacheEntry ice = (ImmortalCacheEntry)subject;
            output.writeObject(ice.key);
            output.writeObject(((ImmortalCacheEntry)ice).cacheValue.value);
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            return new ImmortalCacheEntry(k, v);
        }
    }
}

